/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.h;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableCombineLatest<T, R>
extends z<R> {
    final ae<? extends T>[] aiV;
    final Iterable<? extends ae<? extends T>> aiW;
    final io.reactivex.rxjava3.b.h<? super Object[], ? extends R> aiX;
    final int aiY;
    final boolean aiZ;

    public ObservableCombineLatest(ae<? extends T>[] sources, Iterable<? extends ae<? extends T>> sourcesIterable, io.reactivex.rxjava3.b.h<? super Object[], ? extends R> combiner, int bufferSize, boolean delayError) {
        this.aiV = sources;
        this.aiW = sourcesIterable;
        this.aiX = combiner;
        this.aiY = bufferSize;
        this.aiZ = delayError;
    }

    @Override
    public void d(ag<? super R> observer) {
        ae<? extends T>[] sources = this.aiV;
        int count = 0;
        if (sources == null) {
            sources = new ae[8];
            try {
                for (ae<? extends T> ae2 : this.aiW) {
                    if (count == sources.length) {
                        ae[] b2 = new ae[count + (count >> 2)];
                        System.arraycopy(sources, 0, b2, 0, count);
                        sources = b2;
                    }
                    sources[count++] = Objects.requireNonNull(ae2, "The Iterator returned a null ObservableSource");
                }
            }
            catch (Throwable ex) {
                a.k(ex);
                EmptyDisposable.error(ex, observer);
                return;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptyDisposable.complete(observer);
            return;
        }
        LatestCoordinator<? extends T, R> lc = new LatestCoordinator<T, R>(observer, this.aiX, count, this.aiY, this.aiZ);
        lc.subscribe(sources);
    }

    static final class CombinerObserver<T, R>
    extends AtomicReference<b>
    implements ag<T> {
        private static final long serialVersionUID = -4823716997131257941L;
        final LatestCoordinator<T, R> parent;
        final int index;

        CombinerObserver(LatestCoordinator<T, R> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this, d2);
        }

        @Override
        public void onNext(T t2) {
            this.parent.innerNext(this.index, t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.innerError(this.index, t2);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this.index);
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }
    }

    static final class LatestCoordinator<T, R>
    extends AtomicInteger
    implements b {
        private static final long serialVersionUID = 8567835998786448817L;
        final ag<? super R> downstream;
        final io.reactivex.rxjava3.b.h<? super Object[], ? extends R> combiner;
        final CombinerObserver<T, R>[] observers;
        Object[] latest;
        final h<Object[]> queue;
        final boolean delayError;
        volatile boolean cancelled;
        volatile boolean done;
        final AtomicThrowable errors = new AtomicThrowable();
        int active;
        int complete;

        LatestCoordinator(ag<? super R> actual, io.reactivex.rxjava3.b.h<? super Object[], ? extends R> combiner, int count, int bufferSize, boolean delayError) {
            this.downstream = actual;
            this.combiner = combiner;
            this.delayError = delayError;
            this.latest = new Object[count];
            CombinerObserver[] as2 = new CombinerObserver[count];
            for (int i2 = 0; i2 < count; ++i2) {
                as2[i2] = new CombinerObserver(this, i2);
            }
            this.observers = as2;
            this.queue = new h(bufferSize);
        }

        public void subscribe(ae<? extends T>[] sources) {
            CombinerObserver<T, R>[] as2 = this.observers;
            int len = as2.length;
            this.downstream.onSubscribe(this);
            for (int i2 = 0; i2 < len; ++i2) {
                if (this.done || this.cancelled) {
                    return;
                }
                sources[i2].subscribe(as2[i2]);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelSources();
                this.drain();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void cancelSources() {
            for (CombinerObserver<T, R> observer : this.observers) {
                observer.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear(h<?> q2) {
            LatestCoordinator latestCoordinator = this;
            synchronized (latestCoordinator) {
                this.latest = null;
            }
            q2.clear();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            h<Object[]> q2 = this.queue;
            ag<R> a2 = this.downstream;
            boolean delayError = this.delayError;
            int missed = 1;
            while (true) {
                boolean empty;
                if (this.cancelled) {
                    this.clear(q2);
                    this.errors.tryTerminateAndReport();
                    return;
                }
                if (!delayError && this.errors.get() != null) {
                    this.cancelSources();
                    this.clear(q2);
                    this.errors.tryTerminateConsumer(a2);
                    return;
                }
                boolean d2 = this.done;
                Object[] s2 = q2.poll();
                boolean bl2 = empty = s2 == null;
                if (d2 && empty) {
                    this.clear(q2);
                    this.errors.tryTerminateConsumer(a2);
                    return;
                }
                if (!empty) {
                    R v2;
                    try {
                        v2 = Objects.requireNonNull(this.combiner.apply((Object[])s2), "The combiner returned a null value");
                    }
                    catch (Throwable ex) {
                        a.k(ex);
                        this.errors.tryAddThrowableOrReport(ex);
                        this.cancelSources();
                        this.clear(q2);
                        this.errors.tryTerminateConsumer(a2);
                        return;
                    }
                    a2.onNext(v2);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerNext(int index, T item) {
            boolean shouldDrain = false;
            LatestCoordinator latestCoordinator = this;
            synchronized (latestCoordinator) {
                Object[] latest = this.latest;
                if (latest == null) {
                    return;
                }
                Object o2 = latest[index];
                int a2 = this.active;
                if (o2 == null) {
                    this.active = ++a2;
                }
                latest[index] = item;
                if (a2 == latest.length) {
                    this.queue.offer((Object[])latest.clone());
                    shouldDrain = true;
                }
            }
            if (shouldDrain) {
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerError(int index, Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                boolean cancelOthers = true;
                if (this.delayError) {
                    LatestCoordinator latestCoordinator = this;
                    synchronized (latestCoordinator) {
                        Object[] latest = this.latest;
                        if (latest == null) {
                            return;
                        }
                        boolean bl2 = cancelOthers = latest[index] == null;
                        if (cancelOthers || ++this.complete == latest.length) {
                            this.done = true;
                        }
                    }
                }
                if (cancelOthers) {
                    this.cancelSources();
                }
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerComplete(int index) {
            boolean cancelOthers = false;
            LatestCoordinator latestCoordinator = this;
            synchronized (latestCoordinator) {
                Object[] latest = this.latest;
                if (latest == null) {
                    return;
                }
                boolean bl2 = cancelOthers = latest[index] == null;
                if (cancelOthers || ++this.complete == latest.length) {
                    this.done = true;
                }
            }
            if (cancelOthers) {
                this.cancelSources();
            }
            this.drain();
        }
    }
}

