/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.ObservableScalarXMap;
import io.reactivex.rxjava3.internal.operators.observable.a;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.observers.m;
import io.reactivex.rxjava3.operators.g;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableConcatMap<T, U>
extends a<T, U> {
    final h<? super T, ? extends ae<? extends U>> aja;
    final int ajb;
    final ErrorMode ajc;

    public ObservableConcatMap(ae<T> source, h<? super T, ? extends ae<? extends U>> mapper, int bufferSize, ErrorMode delayErrors) {
        super(source);
        this.aja = mapper;
        this.ajc = delayErrors;
        this.ajb = Math.max(8, bufferSize);
    }

    @Override
    public void d(ag<? super U> observer) {
        if (ObservableScalarXMap.a(this.aha, observer, this.aja)) {
            return;
        }
        if (this.ajc == ErrorMode.IMMEDIATE) {
            m<? super U> serial = new m<U>(observer);
            this.aha.subscribe(new SourceObserver<T, U>(serial, this.aja, this.ajb));
        } else {
            this.aha.subscribe(new ConcatMapDelayErrorObserver<T, U>(observer, this.aja, this.ajb, this.ajc == ErrorMode.END));
        }
    }

    static final class ConcatMapDelayErrorObserver<T, R>
    extends AtomicInteger
    implements ag<T>,
    b {
        private static final long serialVersionUID = -6951100001833242599L;
        final ag<? super R> downstream;
        final h<? super T, ? extends ae<? extends R>> mapper;
        final int bufferSize;
        final AtomicThrowable errors;
        final DelayErrorInnerObserver<R> observer;
        final boolean tillTheEnd;
        g<T> queue;
        b upstream;
        volatile boolean active;
        volatile boolean done;
        volatile boolean cancelled;
        int sourceMode;

        ConcatMapDelayErrorObserver(ag<? super R> actual, h<? super T, ? extends ae<? extends R>> mapper, int bufferSize, boolean tillTheEnd) {
            this.downstream = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.tillTheEnd = tillTheEnd;
            this.errors = new AtomicThrowable();
            this.observer = new DelayErrorInnerObserver<R>(actual, this);
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                if (d2 instanceof io.reactivex.rxjava3.operators.b) {
                    io.reactivex.rxjava3.operators.b qd = (io.reactivex.rxjava3.operators.b)d2;
                    int m2 = qd.requestFusion(3);
                    if (m2 == 1) {
                        this.sourceMode = m2;
                        this.queue = qd;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        this.drain();
                        return;
                    }
                    if (m2 == 2) {
                        this.sourceMode = m2;
                        this.queue = qd;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                }
                this.queue = new io.reactivex.rxjava3.operators.h(this.bufferSize);
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            if (this.sourceMode == 0) {
                this.queue.offer(value);
            }
            this.drain();
        }

        @Override
        public void onError(Throwable e2) {
            if (this.errors.tryAddThrowableOrReport(e2)) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.observer.dispose();
            this.errors.tryTerminateAndReport();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            ag<R> downstream = this.downstream;
            g<T> queue = this.queue;
            AtomicThrowable errors = this.errors;
            while (true) {
                if (!this.active) {
                    boolean empty;
                    T v2;
                    Throwable ex;
                    if (this.cancelled) {
                        queue.clear();
                        return;
                    }
                    if (!this.tillTheEnd && (ex = (Throwable)errors.get()) != null) {
                        queue.clear();
                        this.cancelled = true;
                        errors.tryTerminateConsumer(downstream);
                        return;
                    }
                    boolean d2 = this.done;
                    try {
                        v2 = queue.poll();
                    }
                    catch (Throwable ex2) {
                        io.reactivex.rxjava3.exceptions.a.k(ex2);
                        this.cancelled = true;
                        this.upstream.dispose();
                        errors.tryAddThrowableOrReport(ex2);
                        errors.tryTerminateConsumer(downstream);
                        return;
                    }
                    boolean bl2 = empty = v2 == null;
                    if (d2 && empty) {
                        this.cancelled = true;
                        errors.tryTerminateConsumer(downstream);
                        return;
                    }
                    if (!empty) {
                        ae<R> o2;
                        try {
                            o2 = Objects.requireNonNull(this.mapper.apply(v2), "The mapper returned a null ObservableSource");
                        }
                        catch (Throwable ex3) {
                            io.reactivex.rxjava3.exceptions.a.k(ex3);
                            this.cancelled = true;
                            this.upstream.dispose();
                            queue.clear();
                            errors.tryAddThrowableOrReport(ex3);
                            errors.tryTerminateConsumer(downstream);
                            return;
                        }
                        if (o2 instanceof s) {
                            Object w2;
                            try {
                                w2 = ((s)((Object)o2)).get();
                            }
                            catch (Throwable ex4) {
                                io.reactivex.rxjava3.exceptions.a.k(ex4);
                                errors.tryAddThrowableOrReport(ex4);
                                continue;
                            }
                            if (w2 == null || this.cancelled) continue;
                            downstream.onNext(w2);
                            continue;
                        }
                        this.active = true;
                        o2.subscribe(this.observer);
                    }
                }
                if (this.decrementAndGet() == 0) break;
            }
        }

        static final class DelayErrorInnerObserver<R>
        extends AtomicReference<b>
        implements ag<R> {
            private static final long serialVersionUID = 2620149119579502636L;
            final ag<? super R> downstream;
            final ConcatMapDelayErrorObserver<?, R> parent;

            DelayErrorInnerObserver(ag<? super R> actual, ConcatMapDelayErrorObserver<?, R> parent) {
                this.downstream = actual;
                this.parent = parent;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.replace(this, d2);
            }

            @Override
            public void onNext(R value) {
                this.downstream.onNext(value);
            }

            @Override
            public void onError(Throwable e2) {
                ConcatMapDelayErrorObserver<?, R> p2 = this.parent;
                if (p2.errors.tryAddThrowableOrReport(e2)) {
                    if (!p2.tillTheEnd) {
                        p2.upstream.dispose();
                    }
                    p2.active = false;
                    p2.drain();
                }
            }

            @Override
            public void onComplete() {
                ConcatMapDelayErrorObserver<?, R> p2 = this.parent;
                p2.active = false;
                p2.drain();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }

    static final class SourceObserver<T, U>
    extends AtomicInteger
    implements ag<T>,
    b {
        private static final long serialVersionUID = 8828587559905699186L;
        final ag<? super U> downstream;
        final h<? super T, ? extends ae<? extends U>> mapper;
        final InnerObserver<U> inner;
        final int bufferSize;
        g<T> queue;
        b upstream;
        volatile boolean active;
        volatile boolean disposed;
        volatile boolean done;
        int fusionMode;

        SourceObserver(ag<? super U> actual, h<? super T, ? extends ae<? extends U>> mapper, int bufferSize) {
            this.downstream = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.inner = new InnerObserver<U>(actual, this);
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                if (d2 instanceof io.reactivex.rxjava3.operators.b) {
                    io.reactivex.rxjava3.operators.b qd = (io.reactivex.rxjava3.operators.b)d2;
                    int m2 = qd.requestFusion(3);
                    if (m2 == 1) {
                        this.fusionMode = m2;
                        this.queue = qd;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        this.drain();
                        return;
                    }
                    if (m2 == 2) {
                        this.fusionMode = m2;
                        this.queue = qd;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                }
                this.queue = new io.reactivex.rxjava3.operators.h(this.bufferSize);
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            if (this.fusionMode == 0) {
                this.queue.offer(t2);
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
                return;
            }
            this.done = true;
            this.dispose();
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.inner.dispose();
            this.upstream.dispose();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            do {
                ae<U> o2;
                boolean empty;
                T t2;
                if (this.disposed) {
                    this.queue.clear();
                    return;
                }
                if (this.active) continue;
                boolean d2 = this.done;
                try {
                    t2 = this.queue.poll();
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    this.dispose();
                    this.queue.clear();
                    this.downstream.onError(ex);
                    return;
                }
                boolean bl2 = empty = t2 == null;
                if (d2 && empty) {
                    this.disposed = true;
                    this.downstream.onComplete();
                    return;
                }
                if (empty) continue;
                try {
                    o2 = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null ObservableSource");
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    this.dispose();
                    this.queue.clear();
                    this.downstream.onError(ex);
                    return;
                }
                this.active = true;
                o2.subscribe(this.inner);
            } while (this.decrementAndGet() != 0);
        }

        static final class InnerObserver<U>
        extends AtomicReference<b>
        implements ag<U> {
            private static final long serialVersionUID = -7449079488798789337L;
            final ag<? super U> downstream;
            final SourceObserver<?, ?> parent;

            InnerObserver(ag<? super U> actual, SourceObserver<?, ?> parent) {
                this.downstream = actual;
                this.parent = parent;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.replace(this, d2);
            }

            @Override
            public void onNext(U t2) {
                this.downstream.onNext(t2);
            }

            @Override
            public void onError(Throwable t2) {
                this.parent.dispose();
                this.downstream.onError(t2);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

