/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.f;
import io.reactivex.rxjava3.core.ab;
import io.reactivex.rxjava3.core.ac;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.CancellableDisposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.h;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableCreate<T>
extends z<T> {
    final ac<T> ajr;

    public ObservableCreate(ac<T> source) {
        this.ajr = source;
    }

    @Override
    protected void d(ag<? super T> observer) {
        CreateEmitter<T> parent = new CreateEmitter<T>(observer);
        observer.onSubscribe(parent);
        try {
            this.ajr.a(parent);
        }
        catch (Throwable ex) {
            io.reactivex.rxjava3.exceptions.a.k(ex);
            parent.onError(ex);
        }
    }

    static final class SerializedEmitter<T>
    extends AtomicInteger
    implements ab<T> {
        private static final long serialVersionUID = 4883307006032401862L;
        final ab<T> emitter;
        final AtomicThrowable errors;
        final h<T> queue;
        volatile boolean done;

        SerializedEmitter(ab<T> emitter) {
            this.emitter = emitter;
            this.errors = new AtomicThrowable();
            this.queue = new h(16);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t2) {
            if (this.done || this.emitter.isDisposed()) {
                return;
            }
            if (t2 == null) {
                this.onError(ExceptionHelper.de("onNext called with a null value."));
                return;
            }
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.emitter.onNext(t2);
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                h<T> q2;
                h<T> h2 = q2 = this.queue;
                synchronized (h2) {
                    q2.offer(t2);
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t2) {
            if (!this.tryOnError(t2)) {
                a.onError(t2);
            }
        }

        @Override
        public boolean tryOnError(Throwable t2) {
            if (this.done || this.emitter.isDisposed()) {
                return false;
            }
            if (t2 == null) {
                t2 = ExceptionHelper.de("onError called with a null Throwable.");
            }
            if (this.errors.tryAddThrowable(t2)) {
                this.done = true;
                this.drain();
                return true;
            }
            return false;
        }

        @Override
        public void onComplete() {
            if (this.done || this.emitter.isDisposed()) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            ab<T> e2 = this.emitter;
            h<T> q2 = this.queue;
            AtomicThrowable errors = this.errors;
            int missed = 1;
            while (true) {
                boolean empty;
                if (e2.isDisposed()) {
                    q2.clear();
                    return;
                }
                if (errors.get() != null) {
                    q2.clear();
                    errors.tryTerminateConsumer(e2);
                    return;
                }
                boolean d2 = this.done;
                T v2 = q2.poll();
                boolean bl2 = empty = v2 == null;
                if (d2 && empty) {
                    e2.onComplete();
                    return;
                }
                if (!empty) {
                    e2.onNext(v2);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void setDisposable(b d2) {
            this.emitter.setDisposable(d2);
        }

        @Override
        public void setCancellable(f c2) {
            this.emitter.setCancellable(c2);
        }

        @Override
        public boolean isDisposed() {
            return this.emitter.isDisposed();
        }

        @Override
        public ab<T> serialize() {
            return this;
        }

        @Override
        public String toString() {
            return this.emitter.toString();
        }
    }

    static final class CreateEmitter<T>
    extends AtomicReference<b>
    implements ab<T>,
    b {
        private static final long serialVersionUID = -3434801548987643227L;
        final ag<? super T> observer;

        CreateEmitter(ag<? super T> observer) {
            this.observer = observer;
        }

        @Override
        public void onNext(T t2) {
            if (t2 == null) {
                this.onError(ExceptionHelper.de("onNext called with a null value."));
                return;
            }
            if (!this.isDisposed()) {
                this.observer.onNext(t2);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (!this.tryOnError(t2)) {
                a.onError(t2);
            }
        }

        @Override
        public boolean tryOnError(Throwable t2) {
            if (t2 == null) {
                t2 = ExceptionHelper.de("onError called with a null Throwable.");
            }
            if (!this.isDisposed()) {
                try {
                    this.observer.onError(t2);
                }
                finally {
                    this.dispose();
                }
                return true;
            }
            return false;
        }

        @Override
        public void onComplete() {
            if (!this.isDisposed()) {
                try {
                    this.observer.onComplete();
                }
                finally {
                    this.dispose();
                }
            }
        }

        @Override
        public void setDisposable(b d2) {
            DisposableHelper.set(this, d2);
        }

        @Override
        public void setCancellable(f c2) {
            this.setDisposable(new CancellableDisposable(c2));
        }

        @Override
        public ab<T> serialize() {
            return new SerializedEmitter(this);
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }

        @Override
        public String toString() {
            return String.format("%s{%s}", this.getClass().getSimpleName(), super.toString());
        }
    }
}

