/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.ObservableScalarXMap;
import io.reactivex.rxjava3.internal.operators.observable.a;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.f;
import io.reactivex.rxjava3.operators.g;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableFlatMap<T, U>
extends a<T, U> {
    final h<? super T, ? extends ae<? extends U>> akZ;
    final boolean ala;
    final int alb;
    final int alc;

    public ObservableFlatMap(ae<T> source, h<? super T, ? extends ae<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        super(source);
        this.akZ = mapper;
        this.ala = delayErrors;
        this.alb = maxConcurrency;
        this.alc = bufferSize;
    }

    @Override
    public void d(ag<? super U> t2) {
        if (ObservableScalarXMap.a(this.aha, t2, this.akZ)) {
            return;
        }
        this.aha.subscribe(new MergeObserver<T, U>(t2, this.akZ, this.ala, this.alb, this.alc));
    }

    static final class InnerObserver<T, U>
    extends AtomicReference<b>
    implements ag<U> {
        private static final long serialVersionUID = -4606175640614850599L;
        final long id;
        final MergeObserver<T, U> parent;
        volatile boolean done;
        volatile g<U> queue;
        int fusionMode;

        InnerObserver(MergeObserver<T, U> parent, long id) {
            this.id = id;
            this.parent = parent;
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.setOnce(this, d2) && d2 instanceof io.reactivex.rxjava3.operators.b) {
                io.reactivex.rxjava3.operators.b qd = (io.reactivex.rxjava3.operators.b)d2;
                int m2 = qd.requestFusion(7);
                if (m2 == 1) {
                    this.fusionMode = m2;
                    this.queue = qd;
                    this.done = true;
                    this.parent.drain();
                    return;
                }
                if (m2 == 2) {
                    this.fusionMode = m2;
                    this.queue = qd;
                }
            }
        }

        @Override
        public void onNext(U t2) {
            if (this.fusionMode == 0) {
                this.parent.tryEmit(t2, this);
            } else {
                this.parent.drain();
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.parent.errors.tryAddThrowableOrReport(t2)) {
                if (!this.parent.delayErrors) {
                    this.parent.disposeAll();
                }
                this.done = true;
                this.parent.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }
    }

    static final class MergeObserver<T, U>
    extends AtomicInteger
    implements ag<T>,
    b {
        private static final long serialVersionUID = -2117620485640801370L;
        final ag<? super U> downstream;
        final h<? super T, ? extends ae<? extends U>> mapper;
        final boolean delayErrors;
        final int maxConcurrency;
        final int bufferSize;
        volatile f<U> queue;
        volatile boolean done;
        final AtomicThrowable errors = new AtomicThrowable();
        volatile boolean disposed;
        final AtomicReference<InnerObserver<?, ?>[]> observers;
        static final InnerObserver<?, ?>[] EMPTY = new InnerObserver[0];
        static final InnerObserver<?, ?>[] CANCELLED = new InnerObserver[0];
        b upstream;
        long uniqueId;
        int lastIndex;
        Queue<ae<? extends U>> sources;
        int wip;

        MergeObserver(ag<? super U> actual, h<? super T, ? extends ae<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
            this.downstream = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.bufferSize = bufferSize;
            if (maxConcurrency != Integer.MAX_VALUE) {
                this.sources = new ArrayDeque<ae<? extends U>>(maxConcurrency);
            }
            this.observers = new AtomicReference<InnerObserver<?, ?>[]>(EMPTY);
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t2) {
            ae<? extends U> p2;
            if (this.done) {
                return;
            }
            try {
                p2 = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null ObservableSource");
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                this.upstream.dispose();
                this.onError(e2);
                return;
            }
            if (this.maxConcurrency != Integer.MAX_VALUE) {
                MergeObserver mergeObserver = this;
                synchronized (mergeObserver) {
                    if (this.wip == this.maxConcurrency) {
                        this.sources.offer(p2);
                        return;
                    }
                    ++this.wip;
                }
            }
            this.subscribeInner(p2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void subscribeInner(ae<? extends U> p2) {
            block5: {
                InnerObserver inner;
                while (p2 instanceof s) {
                    if (!this.tryEmitScalar((s)((Object)p2)) || this.maxConcurrency == Integer.MAX_VALUE) break block5;
                    boolean empty = false;
                    MergeObserver mergeObserver = this;
                    synchronized (mergeObserver) {
                        p2 = this.sources.poll();
                        if (p2 == null) {
                            --this.wip;
                            empty = true;
                        }
                    }
                    if (!empty) continue;
                    this.drain();
                    break block5;
                }
                if (!this.addInner(inner = new InnerObserver(this, this.uniqueId++))) break block5;
                p2.subscribe(inner);
            }
        }

        boolean addInner(InnerObserver<T, U> inner) {
            InnerObserver[] b2;
            InnerObserver<?, ?>[] a2;
            do {
                if ((a2 = this.observers.get()) == CANCELLED) {
                    inner.dispose();
                    return false;
                }
                int n2 = a2.length;
                b2 = new InnerObserver[n2 + 1];
                System.arraycopy(a2, 0, b2, 0, n2);
                b2[n2] = inner;
            } while (!this.observers.compareAndSet(a2, b2));
            return true;
        }

        void removeInner(InnerObserver<T, U> inner) {
            InnerObserver<?, ?>[] b2;
            InnerObserver<?, ?>[] a2;
            do {
                a2 = this.observers.get();
                int n2 = a2.length;
                int j2 = -1;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (a2[i2] != inner) continue;
                    j2 = i2;
                    break;
                }
                if (j2 < 0) {
                    return;
                }
                if (n2 == 1) {
                    b2 = EMPTY;
                    continue;
                }
                b2 = new InnerObserver[n2 - 1];
                System.arraycopy(a2, 0, b2, 0, j2);
                System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
            } while (!this.observers.compareAndSet(a2, b2));
        }

        boolean tryEmitScalar(s<? extends U> value) {
            U u2;
            try {
                u2 = value.get();
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.errors.tryAddThrowableOrReport(ex);
                this.drain();
                return true;
            }
            if (u2 == null) {
                return true;
            }
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.downstream.onNext(u2);
                if (this.decrementAndGet() == 0) {
                    return true;
                }
            } else {
                f<U> q2 = this.queue;
                if (q2 == null) {
                    q2 = this.maxConcurrency == Integer.MAX_VALUE ? new io.reactivex.rxjava3.operators.h<U>(this.bufferSize) : new SpscArrayQueue<U>(this.maxConcurrency);
                    this.queue = q2;
                }
                q2.offer(u2);
                if (this.getAndIncrement() != 0) {
                    return false;
                }
            }
            this.drainLoop();
            return true;
        }

        void tryEmit(U value, InnerObserver<T, U> inner) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.downstream.onNext(value);
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                g q2 = inner.queue;
                if (q2 == null) {
                    q2 = new io.reactivex.rxjava3.operators.h(this.bufferSize);
                    inner.queue = q2;
                }
                q2.offer(value);
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
                return;
            }
            if (this.errors.tryAddThrowableOrReport(t2)) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            this.disposed = true;
            if (this.disposeAll()) {
                this.errors.tryTerminateAndReport();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drainLoop() {
            ag<U> child = this.downstream;
            int missed = 1;
            while (true) {
                if (this.checkTerminate()) {
                    return;
                }
                int innerCompleted = 0;
                f<U> svq = this.queue;
                if (svq != null) {
                    while (true) {
                        if (this.checkTerminate()) {
                            return;
                        }
                        U o2 = svq.poll();
                        if (o2 == null) break;
                        child.onNext(o2);
                        ++innerCompleted;
                    }
                }
                if (innerCompleted != 0) {
                    if (this.maxConcurrency == Integer.MAX_VALUE) continue;
                    this.subscribeMore(innerCompleted);
                    innerCompleted = 0;
                    continue;
                }
                boolean d2 = this.done;
                svq = this.queue;
                InnerObserver<?, ?>[] inner = this.observers.get();
                int n2 = inner.length;
                int nSources = 0;
                if (this.maxConcurrency != Integer.MAX_VALUE) {
                    MergeObserver mergeObserver = this;
                    synchronized (mergeObserver) {
                        nSources = this.sources.size();
                    }
                }
                if (d2 && (svq == null || svq.isEmpty()) && n2 == 0 && nSources == 0) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (n2 != 0) {
                    int j2 = Math.min(n2 - 1, this.lastIndex);
                    block7: for (int i2 = 0; i2 < n2; ++i2) {
                        InnerObserver<?, ?> is;
                        block21: {
                            if (this.checkTerminate()) {
                                return;
                            }
                            is = inner[j2];
                            g q2 = is.queue;
                            if (q2 != null) {
                                do {
                                    Object o3;
                                    try {
                                        o3 = q2.poll();
                                    }
                                    catch (Throwable ex) {
                                        io.reactivex.rxjava3.exceptions.a.k(ex);
                                        is.dispose();
                                        this.errors.tryAddThrowableOrReport(ex);
                                        if (this.checkTerminate()) {
                                            return;
                                        }
                                        this.removeInner(is);
                                        ++innerCompleted;
                                        if (++j2 != n2) continue block7;
                                        j2 = 0;
                                        continue block7;
                                    }
                                    if (o3 == null) break block21;
                                    child.onNext(o3);
                                } while (!this.checkTerminate());
                                return;
                            }
                        }
                        boolean innerDone = is.done;
                        g innerQueue = is.queue;
                        if (innerDone && (innerQueue == null || innerQueue.isEmpty())) {
                            this.removeInner(is);
                            ++innerCompleted;
                        }
                        if (++j2 != n2) continue;
                        j2 = 0;
                    }
                    this.lastIndex = j2;
                }
                if (innerCompleted != 0) {
                    if (this.maxConcurrency == Integer.MAX_VALUE) continue;
                    this.subscribeMore(innerCompleted);
                    innerCompleted = 0;
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void subscribeMore(int innerCompleted) {
            while (innerCompleted-- != 0) {
                ae<? extends U> p2;
                MergeObserver mergeObserver = this;
                synchronized (mergeObserver) {
                    p2 = this.sources.poll();
                    if (p2 == null) {
                        --this.wip;
                        continue;
                    }
                }
                this.subscribeInner(p2);
            }
        }

        boolean checkTerminate() {
            if (this.disposed) {
                return true;
            }
            Throwable e2 = (Throwable)this.errors.get();
            if (!this.delayErrors && e2 != null) {
                this.disposeAll();
                this.errors.tryTerminateConsumer(this.downstream);
                return true;
            }
            return false;
        }

        boolean disposeAll() {
            this.upstream.dispose();
            InnerObserver<?, ?>[] a2 = this.observers.getAndSet(CANCELLED);
            if (a2 != CANCELLED) {
                for (InnerObserver<?, ?> inner : a2) {
                    inner.dispose();
                }
                return true;
            }
            return false;
        }
    }
}

