/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.d;
import io.reactivex.rxjava3.core.g;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.observers.BasicIntQueueDisposable;
import io.reactivex.rxjava3.internal.operators.observable.a;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableFlatMapCompletable<T>
extends a<T, T> {
    final h<? super T, ? extends g> ald;
    final boolean ale;

    public ObservableFlatMapCompletable(ae<T> source, h<? super T, ? extends g> mapper, boolean delayErrors) {
        super(source);
        this.ald = mapper;
        this.ale = delayErrors;
    }

    @Override
    protected void d(ag<? super T> observer) {
        this.aha.subscribe(new FlatMapCompletableMainObserver<T>(observer, this.ald, this.ale));
    }

    static final class FlatMapCompletableMainObserver<T>
    extends BasicIntQueueDisposable<T>
    implements ag<T> {
        private static final long serialVersionUID = 8443155186132538303L;
        final ag<? super T> downstream;
        final AtomicThrowable errors;
        final h<? super T, ? extends g> mapper;
        final boolean delayErrors;
        final io.reactivex.rxjava3.disposables.a set;
        b upstream;
        volatile boolean disposed;

        FlatMapCompletableMainObserver(ag<? super T> observer, h<? super T, ? extends g> mapper, boolean delayErrors) {
            this.downstream = observer;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
            this.set = new io.reactivex.rxjava3.disposables.a();
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            g cs;
            try {
                cs = Objects.requireNonNull(this.mapper.apply(value), "The mapper returned a null CompletableSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.dispose();
                this.onError(ex);
                return;
            }
            this.getAndIncrement();
            InnerObserver inner = new InnerObserver();
            if (!this.disposed && this.set.a((b)inner)) {
                cs.c(inner);
            }
        }

        @Override
        public void onError(Throwable e2) {
            if (this.errors.tryAddThrowableOrReport(e2)) {
                if (this.delayErrors) {
                    if (this.decrementAndGet() == 0) {
                        this.errors.tryTerminateConsumer(this.downstream);
                    }
                } else {
                    this.disposed = true;
                    this.upstream.dispose();
                    this.set.dispose();
                    this.errors.tryTerminateConsumer(this.downstream);
                }
            }
        }

        @Override
        public void onComplete() {
            if (this.decrementAndGet() == 0) {
                this.errors.tryTerminateConsumer(this.downstream);
            }
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.upstream.dispose();
            this.set.dispose();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        @f
        public T poll() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
        }

        @Override
        public int requestFusion(int mode) {
            return mode & 2;
        }

        void innerComplete(InnerObserver inner) {
            this.set.c(inner);
            this.onComplete();
        }

        void innerError(InnerObserver inner, Throwable e2) {
            this.set.c(inner);
            this.onError(e2);
        }

        final class InnerObserver
        extends AtomicReference<b>
        implements d,
        b {
            private static final long serialVersionUID = 8606673141535671828L;

            InnerObserver() {
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onComplete() {
                FlatMapCompletableMainObserver.this.innerComplete(this);
            }

            @Override
            public void onError(Throwable e2) {
                FlatMapCompletableMainObserver.this.innerError(this, e2);
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((b)this.get());
            }
        }
    }
}

