/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.a;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.d;
import io.reactivex.rxjava3.core.g;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.a.e;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFlatMapCompletable;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableFlatMapCompletableCompletable<T>
extends a
implements e<T> {
    final ae<T> alf;
    final h<? super T, ? extends g> alg;
    final boolean alh;

    public ObservableFlatMapCompletableCompletable(ae<T> source, h<? super T, ? extends g> mapper, boolean delayErrors) {
        this.alf = source;
        this.alg = mapper;
        this.alh = delayErrors;
    }

    @Override
    protected void d(d observer) {
        this.alf.subscribe(new FlatMapCompletableMainObserver<T>(observer, this.alg, this.alh));
    }

    @Override
    public z<T> pD() {
        return io.reactivex.rxjava3.d.a.d(new ObservableFlatMapCompletable<T>(this.alf, this.alg, this.alh));
    }

    static final class FlatMapCompletableMainObserver<T>
    extends AtomicInteger
    implements ag<T>,
    b {
        private static final long serialVersionUID = 8443155186132538303L;
        final d downstream;
        final AtomicThrowable errors;
        final h<? super T, ? extends g> mapper;
        final boolean delayErrors;
        final io.reactivex.rxjava3.disposables.a set;
        b upstream;
        volatile boolean disposed;

        FlatMapCompletableMainObserver(d observer, h<? super T, ? extends g> mapper, boolean delayErrors) {
            this.downstream = observer;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
            this.set = new io.reactivex.rxjava3.disposables.a();
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            g cs;
            try {
                cs = Objects.requireNonNull(this.mapper.apply(value), "The mapper returned a null CompletableSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.dispose();
                this.onError(ex);
                return;
            }
            this.getAndIncrement();
            InnerObserver inner = new InnerObserver();
            if (!this.disposed && this.set.a((b)inner)) {
                cs.c(inner);
            }
        }

        @Override
        public void onError(Throwable e2) {
            if (this.errors.tryAddThrowableOrReport(e2)) {
                if (this.delayErrors) {
                    if (this.decrementAndGet() == 0) {
                        this.errors.tryTerminateConsumer(this.downstream);
                    }
                } else {
                    this.disposed = true;
                    this.upstream.dispose();
                    this.set.dispose();
                    this.errors.tryTerminateConsumer(this.downstream);
                }
            }
        }

        @Override
        public void onComplete() {
            if (this.decrementAndGet() == 0) {
                this.errors.tryTerminateConsumer(this.downstream);
            }
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.upstream.dispose();
            this.set.dispose();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        void innerComplete(InnerObserver inner) {
            this.set.c(inner);
            this.onComplete();
        }

        void innerError(InnerObserver inner, Throwable e2) {
            this.set.c(inner);
            this.onError(e2);
        }

        final class InnerObserver
        extends AtomicReference<b>
        implements d,
        b {
            private static final long serialVersionUID = 8606673141535671828L;

            InnerObserver() {
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onComplete() {
                FlatMapCompletableMainObserver.this.innerComplete(this);
            }

            @Override
            public void onError(Throwable e2) {
                FlatMapCompletableMainObserver.this.innerError(this, e2);
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((b)this.get());
            }
        }
    }
}

