/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.w;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.a;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.h;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableFlatMapMaybe<T, R>
extends a<T, R> {
    final io.reactivex.rxjava3.b.h<? super T, ? extends w<? extends R>> ali;
    final boolean alj;

    public ObservableFlatMapMaybe(ae<T> source, io.reactivex.rxjava3.b.h<? super T, ? extends w<? extends R>> mapper, boolean delayError) {
        super(source);
        this.ali = mapper;
        this.alj = delayError;
    }

    @Override
    protected void d(ag<? super R> observer) {
        this.aha.subscribe(new FlatMapMaybeObserver<T, R>(observer, this.ali, this.alj));
    }

    static final class FlatMapMaybeObserver<T, R>
    extends AtomicInteger
    implements ag<T>,
    b {
        private static final long serialVersionUID = 8600231336733376951L;
        final ag<? super R> downstream;
        final boolean delayErrors;
        final io.reactivex.rxjava3.disposables.a set;
        final AtomicInteger active;
        final AtomicThrowable errors;
        final io.reactivex.rxjava3.b.h<? super T, ? extends w<? extends R>> mapper;
        final AtomicReference<h<R>> queue;
        b upstream;
        volatile boolean cancelled;

        FlatMapMaybeObserver(ag<? super R> actual, io.reactivex.rxjava3.b.h<? super T, ? extends w<? extends R>> mapper, boolean delayErrors) {
            this.downstream = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.set = new io.reactivex.rxjava3.disposables.a();
            this.errors = new AtomicThrowable();
            this.active = new AtomicInteger(1);
            this.queue = new AtomicReference();
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            w<R> ms;
            try {
                ms = Objects.requireNonNull(this.mapper.apply(t2), "The mapper returned a null MaybeSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.dispose();
                this.onError(ex);
                return;
            }
            this.active.getAndIncrement();
            InnerObserver inner = new InnerObserver();
            if (!this.cancelled && this.set.a((b)inner)) {
                ms.c(inner);
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.active.decrementAndGet();
            if (this.errors.tryAddThrowableOrReport(t2)) {
                if (!this.delayErrors) {
                    this.set.dispose();
                }
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.active.decrementAndGet();
            this.drain();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.set.dispose();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerSuccess(InnerObserver inner, R value) {
            this.set.c(inner);
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.downstream.onNext(value);
                boolean d2 = this.active.decrementAndGet() == 0;
                h<R> q2 = this.queue.get();
                if (d2 && (q2 == null || q2.isEmpty())) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                h<R> q3;
                h<R> h2 = q3 = this.getOrCreateQueue();
                synchronized (h2) {
                    q3.offer(value);
                }
                this.active.decrementAndGet();
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        h<R> getOrCreateQueue() {
            h<Object> current = this.queue.get();
            if (current != null) {
                return current;
            }
            current = new h(z.mB());
            if (this.queue.compareAndSet(null, current)) {
                return current;
            }
            return this.queue.get();
        }

        void innerError(InnerObserver inner, Throwable e2) {
            this.set.c(inner);
            if (this.errors.tryAddThrowableOrReport(e2)) {
                if (!this.delayErrors) {
                    this.upstream.dispose();
                    this.set.dispose();
                }
                this.active.decrementAndGet();
                this.drain();
            }
        }

        void innerComplete(InnerObserver inner) {
            this.set.c(inner);
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                boolean d2 = this.active.decrementAndGet() == 0;
                h<R> q2 = this.queue.get();
                if (d2 && (q2 == null || q2.isEmpty())) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
                this.drainLoop();
            } else {
                this.active.decrementAndGet();
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void clear() {
            h<R> q2 = this.queue.get();
            if (q2 != null) {
                q2.clear();
            }
        }

        void drainLoop() {
            int missed = 1;
            ag<R> a2 = this.downstream;
            AtomicInteger n2 = this.active;
            AtomicReference<h<R>> qr = this.queue;
            while (true) {
                boolean empty;
                Throwable ex;
                if (this.cancelled) {
                    this.clear();
                    return;
                }
                if (!this.delayErrors && (ex = (Throwable)this.errors.get()) != null) {
                    this.clear();
                    this.errors.tryTerminateConsumer(a2);
                    return;
                }
                boolean d2 = n2.get() == 0;
                h<R> q2 = qr.get();
                Object v2 = q2 != null ? (Object)q2.poll() : null;
                boolean bl2 = empty = v2 == null;
                if (d2 && empty) {
                    this.errors.tryTerminateConsumer(a2);
                    return;
                }
                if (!empty) {
                    a2.onNext(v2);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        final class InnerObserver
        extends AtomicReference<b>
        implements t<R>,
        b {
            private static final long serialVersionUID = -502562646270949838L;

            InnerObserver() {
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onSuccess(R value) {
                FlatMapMaybeObserver.this.innerSuccess(this, value);
            }

            @Override
            public void onError(Throwable e2) {
                FlatMapMaybeObserver.this.innerError(this, e2);
            }

            @Override
            public void onComplete() {
                FlatMapMaybeObserver.this.innerComplete(this);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((b)this.get());
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

