/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableGroupBy<T, K, V>
extends io.reactivex.rxjava3.internal.operators.observable.a<T, io.reactivex.rxjava3.c.b<K, V>> {
    final h<? super T, ? extends K> alQ;
    final h<? super T, ? extends V> alR;
    final int alS;
    final boolean alT;

    public ObservableGroupBy(ae<T> source, h<? super T, ? extends K> keySelector, h<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError) {
        super(source);
        this.alQ = keySelector;
        this.alR = valueSelector;
        this.alS = bufferSize;
        this.alT = delayError;
    }

    @Override
    public void d(ag<? super io.reactivex.rxjava3.c.b<K, V>> t2) {
        this.aha.subscribe(new GroupByObserver<T, K, V>(t2, this.alQ, this.alR, this.alS, this.alT));
    }

    static final class State<T, K>
    extends AtomicInteger
    implements ae<T>,
    b {
        private static final long serialVersionUID = -3852313036005250360L;
        final K key;
        final io.reactivex.rxjava3.operators.h<T> queue;
        final GroupByObserver<?, K, T> parent;
        final boolean delayError;
        volatile boolean done;
        Throwable error;
        final AtomicBoolean cancelled = new AtomicBoolean();
        final AtomicReference<ag<? super T>> actual = new AtomicReference();
        final AtomicInteger once = new AtomicInteger();
        static final int FRESH = 0;
        static final int HAS_SUBSCRIBER = 1;
        static final int ABANDONED = 2;
        static final int ABANDONED_HAS_SUBSCRIBER = 3;

        State(int bufferSize, GroupByObserver<?, K, T> parent, K key, boolean delayError) {
            this.queue = new io.reactivex.rxjava3.operators.h(bufferSize);
            this.parent = parent;
            this.key = key;
            this.delayError = delayError;
        }

        @Override
        public void dispose() {
            if (this.cancelled.compareAndSet(false, true) && this.getAndIncrement() == 0) {
                this.actual.lazySet(null);
                this.cancelParent();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled.get();
        }

        @Override
        public void subscribe(ag<? super T> observer) {
            int s2;
            while (((s2 = this.once.get()) & 1) == 0) {
                int u2 = s2 | 1;
                if (!this.once.compareAndSet(s2, u2)) continue;
                observer.onSubscribe(this);
                this.actual.lazySet(observer);
                if (this.cancelled.get()) {
                    this.actual.lazySet(null);
                } else {
                    this.drain();
                }
                return;
            }
            EmptyDisposable.error((Throwable)new IllegalStateException("Only one Observer allowed!"), observer);
        }

        public void onNext(T t2) {
            this.queue.offer(t2);
            this.drain();
        }

        public void onError(Throwable e2) {
            this.error = e2;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            io.reactivex.rxjava3.operators.h<T> q2 = this.queue;
            boolean delayError = this.delayError;
            ag<T> a2 = this.actual.get();
            while (true) {
                if (a2 != null) {
                    while (true) {
                        boolean empty;
                        boolean d2 = this.done;
                        T v2 = q2.poll();
                        boolean bl2 = empty = v2 == null;
                        if (this.checkTerminated(d2, empty, a2, delayError)) {
                            return;
                        }
                        if (empty) break;
                        a2.onNext(v2);
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
                if (a2 != null) continue;
                a2 = this.actual.get();
            }
        }

        void cancelParent() {
            if ((this.once.get() & 2) == 0) {
                this.parent.cancel(this.key);
            }
        }

        boolean tryAbandon() {
            return this.once.get() == 0 && this.once.compareAndSet(0, 2);
        }

        boolean checkTerminated(boolean d2, boolean empty, ag<? super T> a2, boolean delayError) {
            if (this.cancelled.get()) {
                this.queue.clear();
                this.actual.lazySet(null);
                this.cancelParent();
                return true;
            }
            if (d2) {
                if (delayError) {
                    if (empty) {
                        Throwable e2 = this.error;
                        this.actual.lazySet(null);
                        if (e2 != null) {
                            a2.onError(e2);
                        } else {
                            a2.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e3 = this.error;
                    if (e3 != null) {
                        this.queue.clear();
                        this.actual.lazySet(null);
                        a2.onError(e3);
                        return true;
                    }
                    if (empty) {
                        this.actual.lazySet(null);
                        a2.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }
    }

    static final class a<K, T>
    extends io.reactivex.rxjava3.c.b<K, T> {
        final State<T, K> alU;

        public static <T, K> a<K, T> a(K key, int bufferSize, GroupByObserver<?, K, T> parent, boolean delayError) {
            State<T, K> state = new State<T, K>(bufferSize, parent, key, delayError);
            return new a<K, T>(key, state);
        }

        protected a(K key, State<T, K> state) {
            super(key);
            this.alU = state;
        }

        @Override
        protected void d(ag<? super T> observer) {
            this.alU.subscribe(observer);
        }

        public void onNext(T t2) {
            this.alU.onNext(t2);
        }

        public void onError(Throwable e2) {
            this.alU.onError(e2);
        }

        public void onComplete() {
            this.alU.onComplete();
        }
    }

    public static final class GroupByObserver<T, K, V>
    extends AtomicInteger
    implements ag<T>,
    b {
        private static final long serialVersionUID = -3688291656102519502L;
        final ag<? super io.reactivex.rxjava3.c.b<K, V>> downstream;
        final h<? super T, ? extends K> keySelector;
        final h<? super T, ? extends V> valueSelector;
        final int bufferSize;
        final boolean delayError;
        final Map<Object, a<K, V>> groups;
        static final Object NULL_KEY = new Object();
        b upstream;
        final AtomicBoolean cancelled = new AtomicBoolean();

        public GroupByObserver(ag<? super io.reactivex.rxjava3.c.b<K, V>> actual, h<? super T, ? extends K> keySelector, h<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError) {
            this.downstream = actual;
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
            this.bufferSize = bufferSize;
            this.delayError = delayError;
            this.groups = new ConcurrentHashMap<Object, a<K, V>>();
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            V v2;
            K key;
            try {
                key = this.keySelector.apply(t2);
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                this.upstream.dispose();
                this.onError(e2);
                return;
            }
            Object mapKey = key != null ? key : NULL_KEY;
            a<K, Object> group = this.groups.get(mapKey);
            boolean newGroup = false;
            if (group == null) {
                if (this.cancelled.get()) {
                    return;
                }
                group = a.a(key, this.bufferSize, this, this.delayError);
                this.groups.put(mapKey, group);
                this.getAndIncrement();
                newGroup = true;
            }
            try {
                v2 = Objects.requireNonNull(this.valueSelector.apply(t2), "The value supplied is null");
            }
            catch (Throwable e3) {
                io.reactivex.rxjava3.exceptions.a.k(e3);
                this.upstream.dispose();
                if (newGroup) {
                    this.downstream.onNext(group);
                }
                this.onError(e3);
                return;
            }
            group.onNext(v2);
            if (newGroup) {
                this.downstream.onNext(group);
                if (group.alU.tryAbandon()) {
                    this.cancel(key);
                    group.onComplete();
                }
            }
        }

        @Override
        public void onError(Throwable t2) {
            ArrayList<a<K, V>> list = new ArrayList<a<K, V>>(this.groups.values());
            this.groups.clear();
            for (a a2 : list) {
                a2.onError(t2);
            }
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            ArrayList<a<K, V>> list = new ArrayList<a<K, V>>(this.groups.values());
            this.groups.clear();
            for (a a2 : list) {
                a2.onComplete();
            }
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            if (this.cancelled.compareAndSet(false, true) && this.decrementAndGet() == 0) {
                this.upstream.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled.get();
        }

        public void cancel(K key) {
            Object mapKey = key != null ? key : NULL_KEY;
            this.groups.remove(mapKey);
            if (this.decrementAndGet() == 0) {
                this.upstream.dispose();
            }
        }
    }
}

