/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.c;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.subjects.UnicastSubject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableGroupJoin<TLeft, TRight, TLeftEnd, TRightEnd, R>
extends io.reactivex.rxjava3.internal.operators.observable.a<TLeft, R> {
    final ae<? extends TRight> alV;
    final h<? super TLeft, ? extends ae<TLeftEnd>> alW;
    final h<? super TRight, ? extends ae<TRightEnd>> alX;
    final c<? super TLeft, ? super z<TRight>, ? extends R> alY;

    public ObservableGroupJoin(ae<TLeft> source, ae<? extends TRight> other, h<? super TLeft, ? extends ae<TLeftEnd>> leftEnd, h<? super TRight, ? extends ae<TRightEnd>> rightEnd, c<? super TLeft, ? super z<TRight>, ? extends R> resultSelector) {
        super(source);
        this.alV = other;
        this.alW = leftEnd;
        this.alX = rightEnd;
        this.alY = resultSelector;
    }

    @Override
    protected void d(ag<? super R> observer) {
        GroupJoinDisposable parent = new GroupJoinDisposable(observer, this.alW, this.alX, this.alY);
        observer.onSubscribe(parent);
        LeftRightObserver left = new LeftRightObserver(parent, true);
        parent.disposables.a((b)left);
        LeftRightObserver right = new LeftRightObserver(parent, false);
        parent.disposables.a((b)right);
        this.aha.subscribe(left);
        this.alV.subscribe(right);
    }

    static final class LeftRightEndObserver
    extends AtomicReference<b>
    implements ag<Object>,
    b {
        private static final long serialVersionUID = 1883890389173668373L;
        final a parent;
        final boolean isLeft;
        final int index;

        LeftRightEndObserver(a parent, boolean isLeft, int index) {
            this.parent = parent;
            this.isLeft = isLeft;
            this.index = index;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this, d2);
        }

        @Override
        public void onNext(Object t2) {
            if (DisposableHelper.dispose(this)) {
                this.parent.innerClose(this.isLeft, this);
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.innerCloseError(t2);
        }

        @Override
        public void onComplete() {
            this.parent.innerClose(this.isLeft, this);
        }
    }

    static final class LeftRightObserver
    extends AtomicReference<b>
    implements ag<Object>,
    b {
        private static final long serialVersionUID = 1883890389173668373L;
        final a parent;
        final boolean isLeft;

        LeftRightObserver(a parent, boolean isLeft) {
            this.parent = parent;
            this.isLeft = isLeft;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this, d2);
        }

        @Override
        public void onNext(Object t2) {
            this.parent.innerValue(this.isLeft, t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.innerError(t2);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this);
        }
    }

    static final class GroupJoinDisposable<TLeft, TRight, TLeftEnd, TRightEnd, R>
    extends AtomicInteger
    implements b,
    a {
        private static final long serialVersionUID = -6071216598687999801L;
        final ag<? super R> downstream;
        final io.reactivex.rxjava3.operators.h<Object> queue;
        final io.reactivex.rxjava3.disposables.a disposables;
        final Map<Integer, UnicastSubject<TRight>> lefts;
        final Map<Integer, TRight> rights;
        final AtomicReference<Throwable> error;
        final h<? super TLeft, ? extends ae<TLeftEnd>> leftEnd;
        final h<? super TRight, ? extends ae<TRightEnd>> rightEnd;
        final c<? super TLeft, ? super z<TRight>, ? extends R> resultSelector;
        final AtomicInteger active;
        int leftIndex;
        int rightIndex;
        volatile boolean cancelled;
        static final Integer LEFT_VALUE = 1;
        static final Integer RIGHT_VALUE = 2;
        static final Integer LEFT_CLOSE = 3;
        static final Integer RIGHT_CLOSE = 4;

        GroupJoinDisposable(ag<? super R> actual, h<? super TLeft, ? extends ae<TLeftEnd>> leftEnd, h<? super TRight, ? extends ae<TRightEnd>> rightEnd, c<? super TLeft, ? super z<TRight>, ? extends R> resultSelector) {
            this.downstream = actual;
            this.disposables = new io.reactivex.rxjava3.disposables.a();
            this.queue = new io.reactivex.rxjava3.operators.h(z.mB());
            this.lefts = new LinkedHashMap<Integer, UnicastSubject<TRight>>();
            this.rights = new LinkedHashMap<Integer, TRight>();
            this.error = new AtomicReference();
            this.leftEnd = leftEnd;
            this.rightEnd = rightEnd;
            this.resultSelector = resultSelector;
            this.active = new AtomicInteger(2);
        }

        @Override
        public void dispose() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.cancelAll();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void cancelAll() {
            this.disposables.dispose();
        }

        void errorAll(ag<?> a2) {
            Throwable ex = ExceptionHelper.a(this.error);
            for (UnicastSubject<TRight> up : this.lefts.values()) {
                up.onError(ex);
            }
            this.lefts.clear();
            this.rights.clear();
            a2.onError(ex);
        }

        void fail(Throwable exc, ag<?> a2, io.reactivex.rxjava3.operators.h<?> q2) {
            io.reactivex.rxjava3.exceptions.a.k(exc);
            ExceptionHelper.a(this.error, exc);
            q2.clear();
            this.cancelAll();
            this.errorAll(a2);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            io.reactivex.rxjava3.operators.h<Object> q2 = this.queue;
            ag<R> a2 = this.downstream;
            block6: while (true) {
                boolean empty;
                if (this.cancelled) {
                    q2.clear();
                    return;
                }
                Throwable ex = this.error.get();
                if (ex != null) {
                    q2.clear();
                    this.cancelAll();
                    this.errorAll(a2);
                    return;
                }
                boolean d2 = this.active.get() == 0;
                Integer mode = (Integer)q2.poll();
                boolean bl2 = empty = mode == null;
                if (d2 && empty) {
                    for (UnicastSubject<TRight> up : this.lefts.values()) {
                        up.onComplete();
                    }
                    this.lefts.clear();
                    this.rights.clear();
                    this.disposables.dispose();
                    a2.onComplete();
                    return;
                }
                if (!empty) {
                    LeftRightEndObserver end;
                    Object val = q2.poll();
                    if (mode == LEFT_VALUE) {
                        R w2;
                        ae<TLeftEnd> p2;
                        int idx;
                        Object left = val;
                        UnicastSubject<TRight> up = UnicastSubject.sq();
                        ++this.leftIndex;
                        this.lefts.put(idx, up);
                        try {
                            p2 = Objects.requireNonNull(this.leftEnd.apply(left), "The leftEnd returned a null ObservableSource");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a2, q2);
                            return;
                        }
                        LeftRightEndObserver end2 = new LeftRightEndObserver(this, true, idx);
                        this.disposables.a((b)end2);
                        p2.subscribe(end2);
                        ex = this.error.get();
                        if (ex != null) {
                            q2.clear();
                            this.cancelAll();
                            this.errorAll(a2);
                            return;
                        }
                        try {
                            w2 = Objects.requireNonNull(this.resultSelector.apply(left, up), "The resultSelector returned a null value");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a2, q2);
                            return;
                        }
                        a2.onNext(w2);
                        Iterator<TRight> iterator = this.rights.values().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block6;
                            TRight right = iterator.next();
                            up.onNext(right);
                        }
                    }
                    if (mode == RIGHT_VALUE) {
                        ae<TRightEnd> p3;
                        int idx;
                        Object right = val;
                        ++this.rightIndex;
                        this.rights.put(idx, right);
                        try {
                            p3 = Objects.requireNonNull(this.rightEnd.apply(right), "The rightEnd returned a null ObservableSource");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a2, q2);
                            return;
                        }
                        LeftRightEndObserver end3 = new LeftRightEndObserver(this, false, idx);
                        this.disposables.a((b)end3);
                        p3.subscribe(end3);
                        ex = this.error.get();
                        if (ex != null) {
                            q2.clear();
                            this.cancelAll();
                            this.errorAll(a2);
                            return;
                        }
                        Iterator<UnicastSubject<TRight>> iterator = this.lefts.values().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block6;
                            UnicastSubject<TRight> up = iterator.next();
                            up.onNext(right);
                        }
                    }
                    if (mode == LEFT_CLOSE) {
                        end = (LeftRightEndObserver)val;
                        UnicastSubject<TRight> up = this.lefts.remove(end.index);
                        this.disposables.b(end);
                        if (up == null) continue;
                        up.onComplete();
                        continue;
                    }
                    end = (LeftRightEndObserver)val;
                    this.rights.remove(end.index);
                    this.disposables.b(end);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void innerError(Throwable ex) {
            if (ExceptionHelper.a(this.error, ex)) {
                this.active.decrementAndGet();
                this.drain();
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }

        @Override
        public void innerComplete(LeftRightObserver sender) {
            this.disposables.c(sender);
            this.active.decrementAndGet();
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerValue(boolean isLeft, Object o2) {
            GroupJoinDisposable groupJoinDisposable = this;
            synchronized (groupJoinDisposable) {
                this.queue.offer(isLeft ? LEFT_VALUE : RIGHT_VALUE, o2);
            }
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerClose(boolean isLeft, LeftRightEndObserver index) {
            GroupJoinDisposable groupJoinDisposable = this;
            synchronized (groupJoinDisposable) {
                this.queue.offer(isLeft ? LEFT_CLOSE : RIGHT_CLOSE, index);
            }
            this.drain();
        }

        @Override
        public void innerCloseError(Throwable ex) {
            if (ExceptionHelper.a(this.error, ex)) {
                this.drain();
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }
    }

    static interface a {
        public void innerError(Throwable var1);

        public void innerComplete(LeftRightObserver var1);

        public void innerValue(boolean var1, Object var2);

        public void innerClose(boolean var1, LeftRightEndObserver var2);

        public void innerCloseError(Throwable var1);
    }
}

