/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.c;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.operators.observable.ObservableGroupJoin;
import io.reactivex.rxjava3.internal.operators.observable.a;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableJoin<TLeft, TRight, TLeftEnd, TRightEnd, R>
extends a<TLeft, R> {
    final ae<? extends TRight> amO;
    final h<? super TLeft, ? extends ae<TLeftEnd>> amP;
    final h<? super TRight, ? extends ae<TRightEnd>> amQ;
    final c<? super TLeft, ? super TRight, ? extends R> amR;

    public ObservableJoin(ae<TLeft> source, ae<? extends TRight> other, h<? super TLeft, ? extends ae<TLeftEnd>> leftEnd, h<? super TRight, ? extends ae<TRightEnd>> rightEnd, c<? super TLeft, ? super TRight, ? extends R> resultSelector) {
        super(source);
        this.amO = other;
        this.amP = leftEnd;
        this.amQ = rightEnd;
        this.amR = resultSelector;
    }

    @Override
    protected void d(ag<? super R> observer) {
        JoinDisposable parent = new JoinDisposable(observer, this.amP, this.amQ, this.amR);
        observer.onSubscribe(parent);
        ObservableGroupJoin.LeftRightObserver left = new ObservableGroupJoin.LeftRightObserver(parent, true);
        parent.disposables.a((b)left);
        ObservableGroupJoin.LeftRightObserver right = new ObservableGroupJoin.LeftRightObserver(parent, false);
        parent.disposables.a((b)right);
        this.aha.subscribe(left);
        this.amO.subscribe(right);
    }

    static final class JoinDisposable<TLeft, TRight, TLeftEnd, TRightEnd, R>
    extends AtomicInteger
    implements b,
    ObservableGroupJoin.a {
        private static final long serialVersionUID = -6071216598687999801L;
        final ag<? super R> downstream;
        final io.reactivex.rxjava3.operators.h<Object> queue;
        final io.reactivex.rxjava3.disposables.a disposables;
        final Map<Integer, TLeft> lefts;
        final Map<Integer, TRight> rights;
        final AtomicReference<Throwable> error;
        final h<? super TLeft, ? extends ae<TLeftEnd>> leftEnd;
        final h<? super TRight, ? extends ae<TRightEnd>> rightEnd;
        final c<? super TLeft, ? super TRight, ? extends R> resultSelector;
        final AtomicInteger active;
        int leftIndex;
        int rightIndex;
        volatile boolean cancelled;
        static final Integer LEFT_VALUE = 1;
        static final Integer RIGHT_VALUE = 2;
        static final Integer LEFT_CLOSE = 3;
        static final Integer RIGHT_CLOSE = 4;

        JoinDisposable(ag<? super R> actual, h<? super TLeft, ? extends ae<TLeftEnd>> leftEnd, h<? super TRight, ? extends ae<TRightEnd>> rightEnd, c<? super TLeft, ? super TRight, ? extends R> resultSelector) {
            this.downstream = actual;
            this.disposables = new io.reactivex.rxjava3.disposables.a();
            this.queue = new io.reactivex.rxjava3.operators.h(z.mB());
            this.lefts = new LinkedHashMap<Integer, TLeft>();
            this.rights = new LinkedHashMap<Integer, TRight>();
            this.error = new AtomicReference();
            this.leftEnd = leftEnd;
            this.rightEnd = rightEnd;
            this.resultSelector = resultSelector;
            this.active = new AtomicInteger(2);
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void cancelAll() {
            this.disposables.dispose();
        }

        void errorAll(ag<?> a2) {
            Throwable ex = ExceptionHelper.a(this.error);
            this.lefts.clear();
            this.rights.clear();
            a2.onError(ex);
        }

        void fail(Throwable exc, ag<?> a2, io.reactivex.rxjava3.operators.h<?> q2) {
            io.reactivex.rxjava3.exceptions.a.k(exc);
            ExceptionHelper.a(this.error, exc);
            q2.clear();
            this.cancelAll();
            this.errorAll(a2);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            io.reactivex.rxjava3.operators.h<Object> q2 = this.queue;
            ag<R> a2 = this.downstream;
            block8: while (true) {
                boolean empty;
                if (this.cancelled) {
                    q2.clear();
                    return;
                }
                Throwable ex = this.error.get();
                if (ex != null) {
                    q2.clear();
                    this.cancelAll();
                    this.errorAll(a2);
                    return;
                }
                boolean d2 = this.active.get() == 0;
                Integer mode = (Integer)q2.poll();
                boolean bl2 = empty = mode == null;
                if (d2 && empty) {
                    this.lefts.clear();
                    this.rights.clear();
                    this.disposables.dispose();
                    a2.onComplete();
                    return;
                }
                if (!empty) {
                    ObservableGroupJoin.LeftRightEndObserver end;
                    R w2;
                    Iterator<Object> iterator;
                    ObservableGroupJoin.LeftRightEndObserver end2;
                    ae<Object> p2;
                    int idx;
                    Object val = q2.poll();
                    if (mode == LEFT_VALUE) {
                        Object left = val;
                        ++this.leftIndex;
                        this.lefts.put(idx, left);
                        try {
                            p2 = Objects.requireNonNull(this.leftEnd.apply(left), "The leftEnd returned a null ObservableSource");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a2, q2);
                            return;
                        }
                        end2 = new ObservableGroupJoin.LeftRightEndObserver(this, true, idx);
                        this.disposables.a((b)end2);
                        p2.subscribe(end2);
                        ex = this.error.get();
                        if (ex != null) {
                            q2.clear();
                            this.cancelAll();
                            this.errorAll(a2);
                            return;
                        }
                        iterator = this.rights.values().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block8;
                            Object right = iterator.next();
                            try {
                                w2 = Objects.requireNonNull(this.resultSelector.apply(left, right), "The resultSelector returned a null value");
                            }
                            catch (Throwable exc) {
                                this.fail(exc, a2, q2);
                                return;
                            }
                            a2.onNext(w2);
                        }
                    }
                    if (mode == RIGHT_VALUE) {
                        Object right = val;
                        ++this.rightIndex;
                        this.rights.put(idx, right);
                        try {
                            p2 = Objects.requireNonNull(this.rightEnd.apply(right), "The rightEnd returned a null ObservableSource");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a2, q2);
                            return;
                        }
                        end2 = new ObservableGroupJoin.LeftRightEndObserver(this, false, idx);
                        this.disposables.a((b)end2);
                        p2.subscribe(end2);
                        ex = this.error.get();
                        if (ex != null) {
                            q2.clear();
                            this.cancelAll();
                            this.errorAll(a2);
                            return;
                        }
                        iterator = this.lefts.values().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block8;
                            Object left = iterator.next();
                            try {
                                w2 = Objects.requireNonNull(this.resultSelector.apply(left, right), "The resultSelector returned a null value");
                            }
                            catch (Throwable exc) {
                                this.fail(exc, a2, q2);
                                return;
                            }
                            a2.onNext(w2);
                        }
                    }
                    if (mode == LEFT_CLOSE) {
                        end = (ObservableGroupJoin.LeftRightEndObserver)val;
                        this.lefts.remove(end.index);
                        this.disposables.b(end);
                        continue;
                    }
                    end = (ObservableGroupJoin.LeftRightEndObserver)val;
                    this.rights.remove(end.index);
                    this.disposables.b(end);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void innerError(Throwable ex) {
            if (ExceptionHelper.a(this.error, ex)) {
                this.active.decrementAndGet();
                this.drain();
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }

        @Override
        public void innerComplete(ObservableGroupJoin.LeftRightObserver sender) {
            this.disposables.c(sender);
            this.active.decrementAndGet();
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerValue(boolean isLeft, Object o2) {
            JoinDisposable joinDisposable = this;
            synchronized (joinDisposable) {
                this.queue.offer(isLeft ? LEFT_VALUE : RIGHT_VALUE, o2);
            }
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerClose(boolean isLeft, ObservableGroupJoin.LeftRightEndObserver index) {
            JoinDisposable joinDisposable = this;
            synchronized (joinDisposable) {
                this.queue.offer(isLeft ? LEFT_CLOSE : RIGHT_CLOSE, index);
            }
            this.drain();
        }

        @Override
        public void innerCloseError(Throwable ex) {
            if (ExceptionHelper.a(this.error, ex)) {
                this.drain();
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }
    }
}

