/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.g;
import io.reactivex.rxjava3.c.a;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.a.h;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservablePublish<T>
extends a<T>
implements h<T> {
    final ae<T> anB;
    final AtomicReference<PublishConnection<T>> anC;

    public ObservablePublish(ae<T> source) {
        this.anB = source;
        this.anC = new AtomicReference();
    }

    @Override
    public void L(g<? super b> connection) {
        PublishConnection<T> conn;
        boolean doConnect = false;
        while ((conn = this.anC.get()) == null || conn.isDisposed()) {
            PublishConnection<T> fresh = new PublishConnection<T>(this.anC);
            if (!this.anC.compareAndSet(conn, fresh)) continue;
            conn = fresh;
            break;
        }
        doConnect = !conn.connect.get() && conn.connect.compareAndSet(false, true);
        try {
            connection.accept(conn);
        }
        catch (Throwable ex) {
            io.reactivex.rxjava3.exceptions.a.k(ex);
            throw ExceptionHelper.r(ex);
        }
        if (doConnect) {
            this.anB.subscribe(conn);
        }
    }

    @Override
    protected void d(ag<? super T> observer) {
        PublishConnection<Object> conn;
        while ((conn = this.anC.get()) == null) {
            PublishConnection<T> fresh = new PublishConnection<T>(this.anC);
            if (!this.anC.compareAndSet(conn, fresh)) continue;
            conn = fresh;
            break;
        }
        InnerDisposable<T> inner = new InnerDisposable<T>(observer, conn);
        observer.onSubscribe(inner);
        if (conn.add(inner)) {
            if (inner.isDisposed()) {
                conn.remove(inner);
            }
            return;
        }
        Throwable error = conn.error;
        if (error != null) {
            observer.onError(error);
        } else {
            observer.onComplete();
        }
    }

    @Override
    public void reset() {
        PublishConnection<T> conn = this.anC.get();
        if (conn != null && conn.isDisposed()) {
            this.anC.compareAndSet(conn, null);
        }
    }

    @Override
    public ae<T> pG() {
        return this.anB;
    }

    static final class InnerDisposable<T>
    extends AtomicReference<PublishConnection<T>>
    implements b {
        private static final long serialVersionUID = 7463222674719692880L;
        final ag<? super T> downstream;

        InnerDisposable(ag<? super T> downstream, PublishConnection<T> parent) {
            this.downstream = downstream;
            this.lazySet(parent);
        }

        @Override
        public void dispose() {
            PublishConnection p2 = this.getAndSet(null);
            if (p2 != null) {
                p2.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get() == null;
        }
    }

    static final class PublishConnection<T>
    extends AtomicReference<InnerDisposable<T>[]>
    implements ag<T>,
    b {
        private static final long serialVersionUID = -3251430252873581268L;
        final AtomicBoolean connect = new AtomicBoolean();
        final AtomicReference<PublishConnection<T>> current;
        final AtomicReference<b> upstream;
        static final InnerDisposable[] EMPTY = new InnerDisposable[0];
        static final InnerDisposable[] TERMINATED = new InnerDisposable[0];
        Throwable error;

        PublishConnection(AtomicReference<PublishConnection<T>> current) {
            this.current = current;
            this.upstream = new AtomicReference();
            this.lazySet(EMPTY);
        }

        @Override
        public void dispose() {
            this.getAndSet(TERMINATED);
            this.current.compareAndSet(this, null);
            DisposableHelper.dispose(this.upstream);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == TERMINATED;
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this.upstream, d2);
        }

        @Override
        public void onNext(T t2) {
            for (InnerDisposable inner : (InnerDisposable[])this.get()) {
                inner.downstream.onNext(t2);
            }
        }

        @Override
        public void onError(Throwable e2) {
            if (this.upstream.get() != DisposableHelper.DISPOSED) {
                this.error = e2;
                this.upstream.lazySet(DisposableHelper.DISPOSED);
                for (InnerDisposable inner : this.getAndSet(TERMINATED)) {
                    inner.downstream.onError(e2);
                }
            } else {
                io.reactivex.rxjava3.d.a.onError(e2);
            }
        }

        @Override
        public void onComplete() {
            this.upstream.lazySet(DisposableHelper.DISPOSED);
            for (InnerDisposable inner : this.getAndSet(TERMINATED)) {
                inner.downstream.onComplete();
            }
        }

        public boolean add(InnerDisposable<T> inner) {
            InnerDisposable[] b2;
            InnerDisposable[] a2;
            do {
                if ((a2 = (InnerDisposable[])this.get()) == TERMINATED) {
                    return false;
                }
                int n2 = a2.length;
                b2 = new InnerDisposable[n2 + 1];
                System.arraycopy(a2, 0, b2, 0, n2);
                b2[n2] = inner;
            } while (!this.compareAndSet(a2, b2));
            return true;
        }

        public void remove(InnerDisposable<T> inner) {
            InnerDisposable[] b2;
            InnerDisposable[] a2;
            do {
                int n2;
                if ((n2 = (a2 = (InnerDisposable[])this.get()).length) == 0) {
                    return;
                }
                int j2 = -1;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (a2[i2] != inner) continue;
                    j2 = i2;
                    break;
                }
                if (j2 < 0) {
                    return;
                }
                b2 = EMPTY;
                if (n2 == 1) continue;
                b2 = new InnerDisposable[n2 - 1];
                System.arraycopy(a2, 0, b2, 0, j2);
                System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
            } while (!this.compareAndSet(a2, b2));
        }
    }
}

