/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservablePublishSelector<T, R>
extends io.reactivex.rxjava3.internal.operators.observable.a<T, R> {
    final h<? super z<T>, ? extends ae<R>> anD;

    public ObservablePublishSelector(ae<T> source, h<? super z<T>, ? extends ae<R>> selector) {
        super(source);
        this.anD = selector;
    }

    @Override
    protected void d(ag<? super R> observer) {
        ae<R> target;
        PublishSubject subject = PublishSubject.sl();
        try {
            target = Objects.requireNonNull(this.anD.apply(subject), "The selector returned a null ObservableSource");
        }
        catch (Throwable ex) {
            io.reactivex.rxjava3.exceptions.a.k(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        TargetObserver<? super R> o2 = new TargetObserver<R>(observer);
        target.subscribe(o2);
        this.aha.subscribe(new a(subject, o2));
    }

    static final class TargetObserver<R>
    extends AtomicReference<b>
    implements ag<R>,
    b {
        private static final long serialVersionUID = 854110278590336484L;
        final ag<? super R> downstream;
        b upstream;

        TargetObserver(ag<? super R> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(R value) {
            this.downstream.onNext(value);
        }

        @Override
        public void onError(Throwable e2) {
            DisposableHelper.dispose(this);
            this.downstream.onError(e2);
        }

        @Override
        public void onComplete() {
            DisposableHelper.dispose(this);
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }

    static final class a<T>
    implements ag<T> {
        final PublishSubject<T> anE;
        final AtomicReference<b> anF;

        a(PublishSubject<T> subject, AtomicReference<b> target) {
            this.anE = subject;
            this.anF = target;
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this.anF, d2);
        }

        @Override
        public void onNext(T value) {
            this.anE.onNext(value);
        }

        @Override
        public void onError(Throwable e2) {
            this.anE.onError(e2);
        }

        @Override
        public void onComplete() {
            this.anE.onComplete();
        }
    }
}

