/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.internal.observers.BasicIntQueueDisposable;

public final class ObservableRange
extends z<Integer> {
    private final int anG;
    private final long anH;

    public ObservableRange(int start, int count) {
        this.anG = start;
        this.anH = (long)start + (long)count;
    }

    @Override
    protected void d(ag<? super Integer> o2) {
        RangeDisposable parent = new RangeDisposable(o2, this.anG, this.anH);
        o2.onSubscribe(parent);
        parent.run();
    }

    static final class RangeDisposable
    extends BasicIntQueueDisposable<Integer> {
        private static final long serialVersionUID = 396518478098735504L;
        final ag<? super Integer> downstream;
        final long end;
        long index;
        boolean fused;

        RangeDisposable(ag<? super Integer> actual, long start, long end) {
            this.downstream = actual;
            this.index = start;
            this.end = end;
        }

        void run() {
            if (this.fused) {
                return;
            }
            ag<? super Integer> actual = this.downstream;
            long e2 = this.end;
            for (long i2 = this.index; i2 != e2 && this.get() == 0; ++i2) {
                actual.onNext((Integer)((int)i2));
            }
            if (this.get() == 0) {
                this.lazySet(1);
                actual.onComplete();
            }
        }

        @Override
        @f
        public Integer poll() {
            long i2 = this.index;
            if (i2 != this.end) {
                this.index = i2 + 1L;
                return (int)i2;
            }
            this.lazySet(1);
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.index == this.end;
        }

        @Override
        public void clear() {
            this.index = this.end;
            this.lazySet(1);
        }

        @Override
        public void dispose() {
            this.set(1);
        }

        @Override
        public boolean isDisposed() {
            return this.get() != 0;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 1) != 0) {
                this.fused = true;
                return 1;
            }
            return 0;
        }
    }
}

