/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.operators.observable.ObserverResourceWrapper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableReplay<T>
extends io.reactivex.rxjava3.c.a<T>
implements io.reactivex.rxjava3.internal.a.h<T> {
    final ae<T> aof;
    final AtomicReference<ReplayObserver<T>> aog;
    final a<T> aoh;
    final ae<T> aoi;
    static final a aoj = new h();

    public static <U, R> z<R> b(s<? extends io.reactivex.rxjava3.c.a<U>> connectableFactory, io.reactivex.rxjava3.b.h<? super z<U>, ? extends ae<R>> selector) {
        return io.reactivex.rxjava3.d.a.d(new c(connectableFactory, selector));
    }

    public static <T> io.reactivex.rxjava3.c.a<T> F(ae<? extends T> source) {
        return ObservableReplay.a(source, aoj);
    }

    public static <T> io.reactivex.rxjava3.c.a<T> b(ae<T> source, int bufferSize, boolean eagerTruncate) {
        if (bufferSize == Integer.MAX_VALUE) {
            return ObservableReplay.F(source);
        }
        return ObservableReplay.a(source, new e(bufferSize, eagerTruncate));
    }

    public static <T> io.reactivex.rxjava3.c.a<T> a(ae<T> source, long maxAge, TimeUnit unit, ah scheduler, boolean eagerTruncate) {
        return ObservableReplay.a(source, maxAge, unit, scheduler, Integer.MAX_VALUE, eagerTruncate);
    }

    public static <T> io.reactivex.rxjava3.c.a<T> a(ae<T> source, long maxAge, TimeUnit unit, ah scheduler, int bufferSize, boolean eagerTruncate) {
        return ObservableReplay.a(source, new g(bufferSize, maxAge, unit, scheduler, eagerTruncate));
    }

    static <T> io.reactivex.rxjava3.c.a<T> a(ae<T> source, a<T> bufferFactory) {
        AtomicReference curr = new AtomicReference();
        f onSubscribe = new f(curr, bufferFactory);
        return io.reactivex.rxjava3.d.a.a(new ObservableReplay(onSubscribe, source, curr, bufferFactory));
    }

    private ObservableReplay(ae<T> onSubscribe, ae<T> source, AtomicReference<ReplayObserver<T>> current, a<T> bufferFactory) {
        this.aoi = onSubscribe;
        this.aof = source;
        this.aog = current;
        this.aoh = bufferFactory;
    }

    @Override
    public ae<T> pG() {
        return this.aof;
    }

    @Override
    public void reset() {
        ReplayObserver<T> conn = this.aog.get();
        if (conn != null && conn.isDisposed()) {
            this.aog.compareAndSet(conn, null);
        }
    }

    @Override
    protected void d(ag<? super T> observer) {
        this.aoi.subscribe(observer);
    }

    @Override
    public void L(io.reactivex.rxjava3.b.g<? super io.reactivex.rxjava3.disposables.b> connection) {
        ReplayObserver<T> ps;
        while ((ps = this.aog.get()) == null || ps.isDisposed()) {
            d<T> buf = this.aoh.qn();
            ReplayObserver<T> u2 = new ReplayObserver<T>(buf, this.aog);
            if (!this.aog.compareAndSet(ps, u2)) continue;
            ps = u2;
            break;
        }
        boolean doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        try {
            connection.accept(ps);
        }
        catch (Throwable ex) {
            io.reactivex.rxjava3.exceptions.a.k(ex);
            if (doConnect) {
                ps.shouldConnect.compareAndSet(true, false);
            }
            io.reactivex.rxjava3.exceptions.a.k(ex);
            throw ExceptionHelper.r(ex);
        }
        if (doConnect) {
            this.aof.subscribe(ps);
        }
    }

    static final class c<R, U>
    extends z<R> {
        private final s<? extends io.reactivex.rxjava3.c.a<U>> aol;
        private final io.reactivex.rxjava3.b.h<? super z<U>, ? extends ae<R>> aom;

        c(s<? extends io.reactivex.rxjava3.c.a<U>> connectableFactory, io.reactivex.rxjava3.b.h<? super z<U>, ? extends ae<R>> selector) {
            this.aol = connectableFactory;
            this.aom = selector;
        }

        @Override
        protected void d(ag<? super R> child) {
            ae<R> observable;
            io.reactivex.rxjava3.c.a<U> co;
            try {
                co = Objects.requireNonNull(this.aol.get(), "The connectableFactory returned a null ConnectableObservable");
                observable = Objects.requireNonNull(this.aom.apply(co), "The selector returned a null ObservableSource");
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                EmptyDisposable.error(e2, child);
                return;
            }
            ObserverResourceWrapper<? super R> srw = new ObserverResourceWrapper<R>(child);
            observable.subscribe(srw);
            co.L(new b<R>(srw));
        }
    }

    static final class f<T>
    implements ae<T> {
        private final AtomicReference<ReplayObserver<T>> aop;
        private final a<T> aoq;

        f(AtomicReference<ReplayObserver<T>> curr, a<T> bufferFactory) {
            this.aop = curr;
            this.aoq = bufferFactory;
        }

        @Override
        public void subscribe(ag<? super T> child) {
            ReplayObserver<Object> r2;
            while ((r2 = this.aop.get()) == null) {
                d<T> buf = this.aoq.qn();
                ReplayObserver<T> u2 = new ReplayObserver<T>(buf, this.aop);
                if (!this.aop.compareAndSet(null, u2)) continue;
                r2 = u2;
                break;
            }
            InnerDisposable<T> inner = new InnerDisposable<T>(r2, child);
            child.onSubscribe(inner);
            r2.add(inner);
            if (inner.isDisposed()) {
                r2.remove(inner);
                return;
            }
            r2.buffer.replay(inner);
        }
    }

    static final class g<T>
    implements a<T> {
        private final int aor;
        private final long aos;
        private final TimeUnit aot;
        private final ah aou;
        final boolean aov;

        g(int bufferSize, long maxAge, TimeUnit unit, ah scheduler, boolean eagerTruncate) {
            this.aor = bufferSize;
            this.aos = maxAge;
            this.aot = unit;
            this.aou = scheduler;
            this.aov = eagerTruncate;
        }

        @Override
        public d<T> qn() {
            return new SizeAndTimeBoundReplayBuffer(this.aor, this.aos, this.aot, this.aou, this.aov);
        }
    }

    static final class e<T>
    implements a<T> {
        final int aon;
        final boolean aoo;

        e(int bufferSize, boolean eagerTruncate) {
            this.aon = bufferSize;
            this.aoo = eagerTruncate;
        }

        @Override
        public d<T> qn() {
            return new SizeBoundReplayBuffer(this.aon, this.aoo);
        }
    }

    static final class b<R>
    implements io.reactivex.rxjava3.b.g<io.reactivex.rxjava3.disposables.b> {
        private final ObserverResourceWrapper<R> aok;

        b(ObserverResourceWrapper<R> srw) {
            this.aok = srw;
        }

        @Override
        public void accept(io.reactivex.rxjava3.disposables.b r2) {
            this.aok.setResource(r2);
        }
    }

    static final class h
    implements a<Object> {
        h() {
        }

        @Override
        public d<Object> qn() {
            return new UnboundedReplayBuffer<Object>(16);
        }
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = 3457957419649567404L;
        final ah scheduler;
        final long maxAge;
        final TimeUnit unit;
        final int limit;

        SizeAndTimeBoundReplayBuffer(int limit, long maxAge, TimeUnit unit, ah scheduler, boolean eagerTruncate) {
            super(eagerTruncate);
            this.scheduler = scheduler;
            this.limit = limit;
            this.maxAge = maxAge;
            this.unit = unit;
        }

        @Override
        Object enterTransform(Object value) {
            return new io.reactivex.rxjava3.schedulers.c<Object>(value, this.scheduler.h(this.unit), this.unit);
        }

        @Override
        Object leaveTransform(Object value) {
            return ((io.reactivex.rxjava3.schedulers.c)value).sd();
        }

        @Override
        void truncate() {
            long timeLimit = this.scheduler.h(this.unit) - this.maxAge;
            Node prev = (Node)this.get();
            Node next = (Node)prev.get();
            int e2 = 0;
            while (this.size > 1) {
                if (this.size > this.limit) {
                    ++e2;
                    --this.size;
                    prev = next;
                    next = (Node)next.get();
                    continue;
                }
                io.reactivex.rxjava3.schedulers.c v2 = (io.reactivex.rxjava3.schedulers.c)next.value;
                if (v2.sf() > timeLimit) break;
                ++e2;
                --this.size;
                prev = next;
                next = (Node)next.get();
            }
            if (e2 != 0) {
                this.setFirst(prev);
            }
        }

        @Override
        void truncateFinal() {
            io.reactivex.rxjava3.schedulers.c v2;
            long timeLimit = this.scheduler.h(this.unit) - this.maxAge;
            Node prev = (Node)this.get();
            Node next = (Node)prev.get();
            int e2 = 0;
            while (this.size > 1 && (v2 = (io.reactivex.rxjava3.schedulers.c)next.value).sf() <= timeLimit) {
                ++e2;
                --this.size;
                prev = next;
                next = (Node)next.get();
            }
            if (e2 != 0) {
                this.setFirst(prev);
            }
        }

        @Override
        Node getHead() {
            io.reactivex.rxjava3.schedulers.c v2;
            long timeLimit = this.scheduler.h(this.unit) - this.maxAge;
            Node prev = (Node)this.get();
            for (Node next = (Node)prev.get(); next != null && !NotificationLite.isComplete((v2 = (io.reactivex.rxjava3.schedulers.c)next.value).sd()) && !NotificationLite.isError(v2.sd()) && v2.sf() <= timeLimit; next = (Node)next.get()) {
                prev = next;
            }
            return prev;
        }
    }

    static final class SizeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = -5898283885385201806L;
        final int limit;

        SizeBoundReplayBuffer(int limit, boolean eagerTruncate) {
            super(eagerTruncate);
            this.limit = limit;
        }

        @Override
        void truncate() {
            if (this.size > this.limit) {
                this.removeFirst();
            }
        }
    }

    static abstract class BoundedReplayBuffer<T>
    extends AtomicReference<Node>
    implements d<T> {
        private static final long serialVersionUID = 2346567790059478686L;
        Node tail;
        int size;
        final boolean eagerTruncate;

        BoundedReplayBuffer(boolean eagerTruncate) {
            Node n2;
            this.eagerTruncate = eagerTruncate;
            this.tail = n2 = new Node((Object)null);
            this.set(n2);
        }

        final void addLast(Node n2) {
            this.tail.set(n2);
            this.tail = n2;
            ++this.size;
        }

        final void removeFirst() {
            Node head = (Node)this.get();
            Node next = (Node)head.get();
            --this.size;
            this.setFirst(next);
        }

        final void trimHead() {
            Node head = (Node)this.get();
            if (head.value != null) {
                Node n2 = new Node((Object)null);
                n2.lazySet(head.get());
                this.set(n2);
            }
        }

        final void removeSome(int n2) {
            Node head = (Node)this.get();
            while (n2 > 0) {
                head = (Node)head.get();
                --n2;
                --this.size;
            }
            this.setFirst(head);
            head = (Node)this.get();
            if (head.get() == null) {
                this.tail = head;
            }
        }

        final void setFirst(Node n2) {
            if (this.eagerTruncate) {
                Node m2 = new Node((Object)null);
                m2.lazySet(n2.get());
                n2 = m2;
            }
            this.set(n2);
        }

        @Override
        public final void next(T value) {
            Object o2 = this.enterTransform(NotificationLite.next(value));
            Node n2 = new Node(o2);
            this.addLast(n2);
            this.truncate();
        }

        @Override
        public final void error(Throwable e2) {
            Object o2 = this.enterTransform(NotificationLite.error(e2));
            Node n2 = new Node(o2);
            this.addLast(n2);
            this.truncateFinal();
        }

        @Override
        public final void complete() {
            Object o2 = this.enterTransform(NotificationLite.complete());
            Node n2 = new Node(o2);
            this.addLast(n2);
            this.truncateFinal();
        }

        @Override
        public final void replay(InnerDisposable<T> output) {
            if (output.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            do {
                Node node;
                if ((node = (Node)output.index()) == null) {
                    node = this.getHead();
                    output.index = node;
                }
                while (true) {
                    if (output.isDisposed()) {
                        output.index = null;
                        return;
                    }
                    Node v2 = (Node)node.get();
                    if (v2 == null) break;
                    Object o2 = this.leaveTransform(v2.value);
                    if (NotificationLite.accept(o2, output.child)) {
                        output.index = null;
                        return;
                    }
                    node = v2;
                }
                output.index = node;
            } while ((missed = output.addAndGet(-missed)) != 0);
        }

        Object enterTransform(Object value) {
            return value;
        }

        Object leaveTransform(Object value) {
            return value;
        }

        abstract void truncate();

        void truncateFinal() {
            this.trimHead();
        }

        final void collect(Collection<? super T> output) {
            Object o2;
            Object v2;
            Node next;
            Node n2 = this.getHead();
            while ((next = (Node)n2.get()) != null && !NotificationLite.isComplete(v2 = this.leaveTransform(o2 = next.value)) && !NotificationLite.isError(v2)) {
                output.add(NotificationLite.getValue(v2));
                n2 = next;
            }
        }

        boolean hasError() {
            return this.tail.value != null && NotificationLite.isError(this.leaveTransform(this.tail.value));
        }

        boolean hasCompleted() {
            return this.tail.value != null && NotificationLite.isComplete(this.leaveTransform(this.tail.value));
        }

        Node getHead() {
            return (Node)this.get();
        }
    }

    static final class Node
    extends AtomicReference<Node> {
        private static final long serialVersionUID = 245354315435971818L;
        final Object value;

        Node(Object value) {
            this.value = value;
        }
    }

    static final class UnboundedReplayBuffer<T>
    extends ArrayList<Object>
    implements d<T> {
        private static final long serialVersionUID = 7063189396499112664L;
        volatile int size;

        UnboundedReplayBuffer(int capacityHint) {
            super(capacityHint);
        }

        @Override
        public void next(T value) {
            this.add(NotificationLite.next(value));
            ++this.size;
        }

        @Override
        public void error(Throwable e2) {
            this.add(NotificationLite.error(e2));
            ++this.size;
        }

        @Override
        public void complete() {
            this.add(NotificationLite.complete());
            ++this.size;
        }

        @Override
        public void replay(InnerDisposable<T> output) {
            if (output.getAndIncrement() != 0) {
                return;
            }
            ag child = output.child;
            int missed = 1;
            do {
                int destinationIndex;
                if (output.isDisposed()) {
                    return;
                }
                int sourceIndex = this.size;
                Integer destinationIndexObject = (Integer)output.index();
                int n2 = destinationIndex = destinationIndexObject != null ? destinationIndexObject : 0;
                while (destinationIndex < sourceIndex) {
                    Object o2 = this.get(destinationIndex);
                    if (NotificationLite.accept(o2, child)) {
                        return;
                    }
                    if (output.isDisposed()) {
                        return;
                    }
                    ++destinationIndex;
                }
                output.index = destinationIndex;
            } while ((missed = output.addAndGet(-missed)) != 0);
        }
    }

    static interface d<T> {
        public void next(T var1);

        public void error(Throwable var1);

        public void complete();

        public void replay(InnerDisposable<T> var1);
    }

    static final class InnerDisposable<T>
    extends AtomicInteger
    implements io.reactivex.rxjava3.disposables.b {
        private static final long serialVersionUID = 2728361546769921047L;
        final ReplayObserver<T> parent;
        final ag<? super T> child;
        Object index;
        volatile boolean cancelled;

        InnerDisposable(ReplayObserver<T> parent, ag<? super T> child) {
            this.parent = parent;
            this.child = child;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.parent.remove(this);
                this.index = null;
            }
        }

        <U> U index() {
            return (U)this.index;
        }
    }

    static final class ReplayObserver<T>
    extends AtomicReference<io.reactivex.rxjava3.disposables.b>
    implements ag<T>,
    io.reactivex.rxjava3.disposables.b {
        private static final long serialVersionUID = -533785617179540163L;
        final d<T> buffer;
        boolean done;
        static final InnerDisposable[] EMPTY = new InnerDisposable[0];
        static final InnerDisposable[] TERMINATED = new InnerDisposable[0];
        final AtomicReference<InnerDisposable[]> observers;
        final AtomicBoolean shouldConnect;
        final AtomicReference<ReplayObserver<T>> current;

        ReplayObserver(d<T> buffer, AtomicReference<ReplayObserver<T>> current) {
            this.buffer = buffer;
            this.current = current;
            this.observers = new AtomicReference<InnerDisposable[]>(EMPTY);
            this.shouldConnect = new AtomicBoolean();
        }

        @Override
        public boolean isDisposed() {
            return this.observers.get() == TERMINATED;
        }

        @Override
        public void dispose() {
            this.observers.set(TERMINATED);
            this.current.compareAndSet(this, null);
            DisposableHelper.dispose(this);
        }

        boolean add(InnerDisposable<T> producer) {
            InnerDisposable[] u2;
            InnerDisposable[] c2;
            do {
                if ((c2 = this.observers.get()) == TERMINATED) {
                    return false;
                }
                int len = c2.length;
                u2 = new InnerDisposable[len + 1];
                System.arraycopy(c2, 0, u2, 0, len);
                u2[len] = producer;
            } while (!this.observers.compareAndSet(c2, u2));
            return true;
        }

        void remove(InnerDisposable<T> producer) {
            InnerDisposable[] u2;
            InnerDisposable[] c2;
            do {
                int len;
                if ((len = (c2 = this.observers.get()).length) == 0) {
                    return;
                }
                int j2 = -1;
                for (int i2 = 0; i2 < len; ++i2) {
                    if (!c2[i2].equals(producer)) continue;
                    j2 = i2;
                    break;
                }
                if (j2 < 0) {
                    return;
                }
                if (len == 1) {
                    u2 = EMPTY;
                    continue;
                }
                u2 = new InnerDisposable[len - 1];
                System.arraycopy(c2, 0, u2, 0, j2);
                System.arraycopy(c2, j2 + 1, u2, j2, len - j2 - 1);
            } while (!this.observers.compareAndSet(c2, u2));
        }

        @Override
        public void onSubscribe(io.reactivex.rxjava3.disposables.b p2) {
            if (DisposableHelper.setOnce(this, p2)) {
                this.replay();
            }
        }

        @Override
        public void onNext(T t2) {
            if (!this.done) {
                this.buffer.next(t2);
                this.replay();
            }
        }

        @Override
        public void onError(Throwable e2) {
            if (!this.done) {
                this.done = true;
                this.buffer.error(e2);
                this.replayFinal();
            } else {
                io.reactivex.rxjava3.d.a.onError(e2);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.buffer.complete();
                this.replayFinal();
            }
        }

        void replay() {
            InnerDisposable[] a2;
            for (InnerDisposable rp : a2 = this.observers.get()) {
                this.buffer.replay(rp);
            }
        }

        void replayFinal() {
            InnerDisposable[] a2;
            for (InnerDisposable rp : a2 = this.observers.getAndSet(TERMINATED)) {
                this.buffer.replay(rp);
            }
        }
    }

    static interface a<T> {
        public d<T> qn();
    }
}

