/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.r;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.operators.observable.a;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableRetryPredicate<T>
extends a<T, T> {
    final r<? super Throwable> aox;
    final long aoy;

    public ObservableRetryPredicate(z<T> source, long count, r<? super Throwable> predicate) {
        super(source);
        this.aox = predicate;
        this.aoy = count;
    }

    @Override
    public void d(ag<? super T> observer) {
        SequentialDisposable sa = new SequentialDisposable();
        observer.onSubscribe(sa);
        RepeatObserver<T> rs = new RepeatObserver<T>(observer, this.aoy, this.aox, sa, this.aha);
        rs.subscribeNext();
    }

    static final class RepeatObserver<T>
    extends AtomicInteger
    implements ag<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final ag<? super T> downstream;
        final SequentialDisposable upstream;
        final ae<? extends T> source;
        final r<? super Throwable> predicate;
        long remaining;

        RepeatObserver(ag<? super T> actual, long count, r<? super Throwable> predicate, SequentialDisposable sa, ae<? extends T> source) {
            this.downstream = actual;
            this.upstream = sa;
            this.source = source;
            this.predicate = predicate;
            this.remaining = count;
        }

        @Override
        public void onSubscribe(b d2) {
            this.upstream.replace(d2);
        }

        @Override
        public void onNext(T t2) {
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            long r2 = this.remaining;
            if (r2 != Long.MAX_VALUE) {
                this.remaining = r2 - 1L;
            }
            if (r2 == 0L) {
                this.downstream.onError(t2);
            } else {
                boolean b2;
                try {
                    b2 = this.predicate.test(t2);
                }
                catch (Throwable e2) {
                    io.reactivex.rxjava3.exceptions.a.k(e2);
                    this.downstream.onError(new CompositeException(t2, e2));
                    return;
                }
                if (!b2) {
                    this.downstream.onError(t2);
                    return;
                }
                this.subscribeNext();
            }
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        void subscribeNext() {
            block2: {
                if (this.getAndIncrement() != 0) break block2;
                int missed = 1;
                do {
                    if (this.upstream.isDisposed()) {
                        return;
                    }
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

