/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.operators.observable.a;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.g;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.c;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableRetryWhen<T>
extends a<T, T> {
    final h<? super z<Throwable>, ? extends ae<?>> aoz;

    public ObservableRetryWhen(ae<T> source, h<? super z<Throwable>, ? extends ae<?>> handler) {
        super(source);
        this.aoz = handler;
    }

    @Override
    protected void d(ag<? super T> observer) {
        ae<?> other;
        c<Throwable> signaller = PublishSubject.sl().sp();
        try {
            other = Objects.requireNonNull(this.aoz.apply(signaller), "The handler returned a null ObservableSource");
        }
        catch (Throwable ex) {
            io.reactivex.rxjava3.exceptions.a.k(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        RepeatWhenObserver<T> parent = new RepeatWhenObserver<T>(observer, signaller, this.aha);
        observer.onSubscribe(parent);
        other.subscribe(parent.inner);
        parent.subscribeNext();
    }

    static final class RepeatWhenObserver<T>
    extends AtomicInteger
    implements ag<T>,
    b {
        private static final long serialVersionUID = 802743776666017014L;
        final ag<? super T> downstream;
        final AtomicInteger wip;
        final AtomicThrowable error;
        final c<Throwable> signaller;
        final InnerRepeatObserver inner;
        final AtomicReference<b> upstream;
        final ae<T> source;
        volatile boolean active;

        RepeatWhenObserver(ag<? super T> actual, c<Throwable> signaller, ae<T> source) {
            this.downstream = actual;
            this.signaller = signaller;
            this.source = source;
            this.wip = new AtomicInteger();
            this.error = new AtomicThrowable();
            this.inner = new InnerRepeatObserver();
            this.upstream = new AtomicReference();
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.replace(this.upstream, d2);
        }

        @Override
        public void onNext(T t2) {
            g.a(this.downstream, t2, (AtomicInteger)this, this.error);
        }

        @Override
        public void onError(Throwable e2) {
            DisposableHelper.replace(this.upstream, null);
            this.active = false;
            this.signaller.onNext(e2);
        }

        @Override
        public void onComplete() {
            DisposableHelper.dispose(this.inner);
            g.a(this.downstream, (AtomicInteger)this, this.error);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.upstream.get());
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.upstream);
            DisposableHelper.dispose(this.inner);
        }

        void innerNext() {
            this.subscribeNext();
        }

        void innerError(Throwable ex) {
            DisposableHelper.dispose(this.upstream);
            g.a(this.downstream, ex, (AtomicInteger)this, this.error);
        }

        void innerComplete() {
            DisposableHelper.dispose(this.upstream);
            g.a(this.downstream, (AtomicInteger)this, this.error);
        }

        void subscribeNext() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    if (this.isDisposed()) {
                        return;
                    }
                    if (this.active) continue;
                    this.active = true;
                    this.source.subscribe(this);
                } while (this.wip.decrementAndGet() != 0);
            }
        }

        final class InnerRepeatObserver
        extends AtomicReference<b>
        implements ag<Object> {
            private static final long serialVersionUID = 3254781284376480842L;

            InnerRepeatObserver() {
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onNext(Object t2) {
                RepeatWhenObserver.this.innerNext();
            }

            @Override
            public void onError(Throwable e2) {
                RepeatWhenObserver.this.innerError(e2);
            }

            @Override
            public void onComplete() {
                RepeatWhenObserver.this.innerComplete();
            }
        }
    }
}

