/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.a;
import io.reactivex.rxjava3.operators.h;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableSkipLastTimed<T>
extends a<T, T> {
    final long apo;
    final TimeUnit app;
    final ah apq;
    final int apr;
    final boolean aps;

    public ObservableSkipLastTimed(ae<T> source, long time, TimeUnit unit, ah scheduler, int bufferSize, boolean delayError) {
        super(source);
        this.apo = time;
        this.app = unit;
        this.apq = scheduler;
        this.apr = bufferSize;
        this.aps = delayError;
    }

    @Override
    public void d(ag<? super T> t2) {
        this.aha.subscribe(new SkipLastTimedObserver<T>(t2, this.apo, this.app, this.apq, this.apr, this.aps));
    }

    static final class SkipLastTimedObserver<T>
    extends AtomicInteger
    implements ag<T>,
    b {
        private static final long serialVersionUID = -5677354903406201275L;
        final ag<? super T> downstream;
        final long time;
        final TimeUnit unit;
        final ah scheduler;
        final h<Object> queue;
        final boolean delayError;
        b upstream;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;

        SkipLastTimedObserver(ag<? super T> actual, long time, TimeUnit unit, ah scheduler, int bufferSize, boolean delayError) {
            this.downstream = actual;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
            this.queue = new h(bufferSize);
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            h<Object> q2 = this.queue;
            long now = this.scheduler.h(this.unit);
            q2.offer(now, t2);
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            this.error = t2;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.dispose();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            ag<Object> a2 = this.downstream;
            h<Object> q2 = this.queue;
            boolean delayError = this.delayError;
            TimeUnit unit = this.unit;
            ah scheduler = this.scheduler;
            long time = this.time;
            while (true) {
                if (this.cancelled) {
                    this.queue.clear();
                    return;
                }
                boolean d2 = this.done;
                Long ts = (Long)q2.peek();
                boolean empty = ts == null;
                long now = scheduler.h(unit);
                if (!empty && ts > now - time) {
                    empty = true;
                }
                if (d2) {
                    Throwable e2;
                    if (delayError) {
                        if (empty) {
                            e2 = this.error;
                            if (e2 != null) {
                                a2.onError(e2);
                            } else {
                                a2.onComplete();
                            }
                            return;
                        }
                    } else {
                        e2 = this.error;
                        if (e2 != null) {
                            this.queue.clear();
                            a2.onError(e2);
                            return;
                        }
                        if (empty) {
                            a2.onComplete();
                            return;
                        }
                    }
                }
                if (!empty) {
                    q2.poll();
                    Object v2 = q2.poll();
                    a2.onNext(v2);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

