/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.ObservableScalarXMap;
import io.reactivex.rxjava3.internal.operators.observable.a;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.g;
import io.reactivex.rxjava3.operators.h;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableSwitchMap<T, R>
extends a<T, R> {
    final io.reactivex.rxjava3.b.h<? super T, ? extends ae<? extends R>> apL;
    final int apM;
    final boolean apN;

    public ObservableSwitchMap(ae<T> source, io.reactivex.rxjava3.b.h<? super T, ? extends ae<? extends R>> mapper, int bufferSize, boolean delayErrors) {
        super(source);
        this.apL = mapper;
        this.apM = bufferSize;
        this.apN = delayErrors;
    }

    @Override
    public void d(ag<? super R> t2) {
        if (ObservableScalarXMap.a(this.aha, t2, this.apL)) {
            return;
        }
        this.aha.subscribe(new SwitchMapObserver<T, R>(t2, this.apL, this.apM, this.apN));
    }

    static final class SwitchMapInnerObserver<T, R>
    extends AtomicReference<b>
    implements ag<R> {
        private static final long serialVersionUID = 3837284832786408377L;
        final SwitchMapObserver<T, R> parent;
        final long index;
        final int bufferSize;
        volatile g<R> queue;
        volatile boolean done;

        SwitchMapInnerObserver(SwitchMapObserver<T, R> parent, long index, int bufferSize) {
            this.parent = parent;
            this.index = index;
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.setOnce(this, d2)) {
                if (d2 instanceof io.reactivex.rxjava3.operators.b) {
                    io.reactivex.rxjava3.operators.b qd = (io.reactivex.rxjava3.operators.b)d2;
                    int m2 = qd.requestFusion(7);
                    if (m2 == 1) {
                        this.queue = qd;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m2 == 2) {
                        this.queue = qd;
                        return;
                    }
                }
                this.queue = new h<R>(this.bufferSize);
            }
        }

        @Override
        public void onNext(R t2) {
            g<R> q2 = this.queue;
            if (this.index == this.parent.unique && q2 != null) {
                if (t2 != null) {
                    q2.offer(t2);
                }
                this.parent.drain();
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.innerError(this, t2);
        }

        @Override
        public void onComplete() {
            if (this.index == this.parent.unique) {
                this.done = true;
                this.parent.drain();
            }
        }

        public void cancel() {
            DisposableHelper.dispose(this);
        }
    }

    static final class SwitchMapObserver<T, R>
    extends AtomicInteger
    implements ag<T>,
    b {
        private static final long serialVersionUID = -3491074160481096299L;
        final ag<? super R> downstream;
        final io.reactivex.rxjava3.b.h<? super T, ? extends ae<? extends R>> mapper;
        final int bufferSize;
        final boolean delayErrors;
        final AtomicThrowable errors;
        volatile boolean done;
        volatile boolean cancelled;
        b upstream;
        final AtomicReference<SwitchMapInnerObserver<T, R>> active = new AtomicReference();
        static final SwitchMapInnerObserver<Object, Object> CANCELLED = new SwitchMapInnerObserver(null, -1L, 1);
        volatile long unique;

        SwitchMapObserver(ag<? super R> actual, io.reactivex.rxjava3.b.h<? super T, ? extends ae<? extends R>> mapper, int bufferSize, boolean delayErrors) {
            this.downstream = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            ae<R> p2;
            long c2;
            this.unique = c2 = this.unique + 1L;
            SwitchMapInnerObserver<T, R> inner = this.active.get();
            if (inner != null) {
                inner.cancel();
            }
            try {
                p2 = Objects.requireNonNull(this.mapper.apply(t2), "The ObservableSource returned is null");
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                this.upstream.dispose();
                this.onError(e2);
                return;
            }
            SwitchMapInnerObserver nextInner = new SwitchMapInnerObserver(this, c2, this.bufferSize);
            while ((inner = this.active.get()) != CANCELLED) {
                if (!this.active.compareAndSet(inner, nextInner)) continue;
                p2.subscribe(nextInner);
                break;
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (!this.done && this.errors.tryAddThrowable(t2)) {
                if (!this.delayErrors) {
                    this.disposeInner();
                }
                this.done = true;
                this.drain();
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.dispose();
                this.disposeInner();
                this.errors.tryTerminateAndReport();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void disposeInner() {
            SwitchMapInnerObserver<Object, Object> a2 = this.active.getAndSet(CANCELLED);
            if (a2 != null) {
                a2.cancel();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            ag<R> a2 = this.downstream;
            AtomicReference<SwitchMapInnerObserver<T, R>> active = this.active;
            boolean delayErrors = this.delayErrors;
            int missing = 1;
            while (true) {
                g q2;
                SwitchMapInnerObserver<T, R> inner;
                if (this.cancelled) {
                    return;
                }
                if (this.done) {
                    Throwable ex;
                    boolean empty;
                    boolean bl2 = empty = active.get() == null;
                    if (delayErrors) {
                        if (empty) {
                            ex = (Throwable)this.errors.get();
                            if (ex != null) {
                                a2.onError(ex);
                            } else {
                                a2.onComplete();
                            }
                            return;
                        }
                    } else {
                        ex = (Throwable)this.errors.get();
                        if (ex != null) {
                            this.errors.tryTerminateConsumer(a2);
                            return;
                        }
                        if (empty) {
                            a2.onComplete();
                            return;
                        }
                    }
                }
                if ((inner = active.get()) != null && (q2 = inner.queue) != null) {
                    boolean retry = false;
                    while (true) {
                        boolean empty;
                        Object v2;
                        Throwable ex;
                        if (this.cancelled) {
                            return;
                        }
                        if (inner != active.get()) {
                            retry = true;
                            break;
                        }
                        if (!delayErrors && (ex = (Throwable)this.errors.get()) != null) {
                            this.errors.tryTerminateConsumer(a2);
                            return;
                        }
                        boolean d2 = inner.done;
                        try {
                            v2 = q2.poll();
                        }
                        catch (Throwable ex2) {
                            io.reactivex.rxjava3.exceptions.a.k(ex2);
                            this.errors.tryAddThrowableOrReport(ex2);
                            active.compareAndSet(inner, null);
                            if (!delayErrors) {
                                this.disposeInner();
                                this.upstream.dispose();
                                this.done = true;
                            } else {
                                inner.cancel();
                            }
                            v2 = null;
                            retry = true;
                        }
                        boolean bl3 = empty = v2 == null;
                        if (d2 && empty) {
                            active.compareAndSet(inner, null);
                            retry = true;
                            break;
                        }
                        if (empty) break;
                        a2.onNext(v2);
                    }
                    if (retry) continue;
                }
                if ((missing = this.addAndGet(-missing)) == 0) break;
            }
        }

        void innerError(SwitchMapInnerObserver<T, R> inner, Throwable ex) {
            if (inner.index == this.unique && this.errors.tryAddThrowable(ex)) {
                if (!this.delayErrors) {
                    this.upstream.dispose();
                    this.done = true;
                }
                inner.done = true;
                this.drain();
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }

        static {
            CANCELLED.cancel();
        }
    }
}

