/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.a;
import io.reactivex.rxjava3.operators.h;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObservableTakeLastTimed<T>
extends a<T, T> {
    final long apS;
    final long apT;
    final TimeUnit apU;
    final ah apV;
    final int apW;
    final boolean apX;

    public ObservableTakeLastTimed(ae<T> source, long count, long time, TimeUnit unit, ah scheduler, int bufferSize, boolean delayError) {
        super(source);
        this.apS = count;
        this.apT = time;
        this.apU = unit;
        this.apV = scheduler;
        this.apW = bufferSize;
        this.apX = delayError;
    }

    @Override
    public void d(ag<? super T> t2) {
        this.aha.subscribe(new TakeLastTimedObserver<T>(t2, this.apS, this.apT, this.apU, this.apV, this.apW, this.apX));
    }

    static final class TakeLastTimedObserver<T>
    extends AtomicBoolean
    implements ag<T>,
    b {
        private static final long serialVersionUID = -5677354903406201275L;
        final ag<? super T> downstream;
        final long count;
        final long time;
        final TimeUnit unit;
        final ah scheduler;
        final h<Object> queue;
        final boolean delayError;
        b upstream;
        volatile boolean cancelled;
        Throwable error;

        TakeLastTimedObserver(ag<? super T> actual, long count, long time, TimeUnit unit, ah scheduler, int bufferSize, boolean delayError) {
            this.downstream = actual;
            this.count = count;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
            this.queue = new h(bufferSize);
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            long ts;
            h<Object> q2 = this.queue;
            long now = this.scheduler.h(this.unit);
            long time = this.time;
            long c2 = this.count;
            boolean unbounded = c2 == Long.MAX_VALUE;
            q2.offer(now, t2);
            while (!q2.isEmpty() && ((ts = ((Long)q2.peek()).longValue()) <= now - time || !unbounded && (long)(q2.size() >> 1) > c2)) {
                q2.poll();
                q2.poll();
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.error = t2;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.drain();
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.dispose();
                if (this.compareAndSet(false, true)) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void drain() {
            if (!this.compareAndSet(false, true)) {
                return;
            }
            ag<Object> a2 = this.downstream;
            h<Object> q2 = this.queue;
            boolean delayError = this.delayError;
            long timestampLimit = this.scheduler.h(this.unit) - this.time;
            while (true) {
                boolean empty;
                Throwable ex;
                if (this.cancelled) {
                    q2.clear();
                    return;
                }
                if (!delayError && (ex = this.error) != null) {
                    q2.clear();
                    a2.onError(ex);
                    return;
                }
                Object ts = q2.poll();
                boolean bl2 = empty = ts == null;
                if (empty) {
                    Throwable ex2 = this.error;
                    if (ex2 != null) {
                        a2.onError(ex2);
                    } else {
                        a2.onComplete();
                    }
                    return;
                }
                Object o2 = q2.poll();
                if ((Long)ts < timestampLimit) continue;
                a2.onNext(o2);
            }
        }
    }
}

