/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.g;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.a;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableThrottleLatest<T>
extends a<T, T> {
    final long aqj;
    final TimeUnit aqk;
    final ah aql;
    final boolean aqm;
    final g<? super T> aqn;

    public ObservableThrottleLatest(z<T> source, long timeout, TimeUnit unit, ah scheduler, boolean emitLast, g<? super T> onDropped) {
        super(source);
        this.aqj = timeout;
        this.aqk = unit;
        this.aql = scheduler;
        this.aqm = emitLast;
        this.aqn = onDropped;
    }

    @Override
    protected void d(ag<? super T> observer) {
        this.aha.subscribe(new ThrottleLatestObserver<T>(observer, this.aqj, this.aqk, this.aql.oS(), this.aqm, this.aqn));
    }

    static final class ThrottleLatestObserver<T>
    extends AtomicInteger
    implements ag<T>,
    b,
    Runnable {
        private static final long serialVersionUID = -8296689127439125014L;
        final ag<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final ah.c worker;
        final boolean emitLast;
        final AtomicReference<T> latest;
        final g<? super T> onDropped;
        b upstream;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;
        volatile boolean timerFired;
        boolean timerRunning;

        ThrottleLatestObserver(ag<? super T> downstream, long timeout, TimeUnit unit, ah.c worker, boolean emitLast, g<? super T> onDropped) {
            this.downstream = downstream;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.emitLast = emitLast;
            this.latest = new AtomicReference();
            this.onDropped = onDropped;
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            T old = this.latest.getAndSet(t2);
            if (this.onDropped != null && old != null) {
                try {
                    this.onDropped.accept(old);
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    this.upstream.dispose();
                    this.error = ex;
                    this.done = true;
                }
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            this.error = t2;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.worker.dispose();
            if (this.getAndIncrement() == 0) {
                this.clear();
            }
        }

        void clear() {
            if (this.onDropped != null) {
                Object v2 = this.latest.getAndSet(null);
                if (v2 != null) {
                    try {
                        this.onDropped.accept(v2);
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        io.reactivex.rxjava3.d.a.onError(ex);
                    }
                }
            } else {
                this.latest.lazySet(null);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void run() {
            this.timerFired = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            AtomicReference<T> latest = this.latest;
            ag<T> downstream = this.downstream;
            while (true) {
                boolean empty;
                T v2;
                if (this.cancelled) {
                    this.clear();
                    return;
                }
                boolean d2 = this.done;
                Throwable error = this.error;
                if (d2 && error != null) {
                    if (this.onDropped != null) {
                        v2 = latest.getAndSet(null);
                        if (v2 != null) {
                            try {
                                this.onDropped.accept(v2);
                            }
                            catch (Throwable ex) {
                                io.reactivex.rxjava3.exceptions.a.k(ex);
                                error = new CompositeException(error, ex);
                            }
                        }
                    } else {
                        latest.lazySet(null);
                    }
                    downstream.onError(error);
                    this.worker.dispose();
                    return;
                }
                v2 = latest.get();
                boolean bl2 = empty = v2 == null;
                if (d2) {
                    if (!empty) {
                        v2 = latest.getAndSet(null);
                        if (this.emitLast) {
                            downstream.onNext(v2);
                        } else if (this.onDropped != null) {
                            try {
                                this.onDropped.accept(v2);
                            }
                            catch (Throwable ex) {
                                io.reactivex.rxjava3.exceptions.a.k(ex);
                                downstream.onError(ex);
                                this.worker.dispose();
                                return;
                            }
                        }
                    }
                    downstream.onComplete();
                    this.worker.dispose();
                    return;
                }
                if (empty) {
                    if (this.timerFired) {
                        this.timerRunning = false;
                        this.timerFired = false;
                    }
                } else if (!this.timerRunning || this.timerFired) {
                    v2 = latest.getAndSet(null);
                    downstream.onNext(v2);
                    this.timerFired = false;
                    this.timerRunning = true;
                    this.worker.b(this, this.timeout, this.unit);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

