/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableTimeoutTimed;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableTimeout<T, U, V>
extends io.reactivex.rxjava3.internal.operators.observable.a<T, T> {
    final ae<U> aqt;
    final h<? super T, ? extends ae<V>> aqu;
    final ae<? extends T> aqv;

    public ObservableTimeout(z<T> source, ae<U> firstTimeoutIndicator, h<? super T, ? extends ae<V>> itemTimeoutIndicator, ae<? extends T> other) {
        super(source);
        this.aqt = firstTimeoutIndicator;
        this.aqu = itemTimeoutIndicator;
        this.aqv = other;
    }

    @Override
    protected void d(ag<? super T> observer) {
        if (this.aqv == null) {
            TimeoutObserver<T> parent = new TimeoutObserver<T>(observer, this.aqu);
            observer.onSubscribe(parent);
            parent.startFirstTimeout(this.aqt);
            this.aha.subscribe(parent);
        } else {
            TimeoutFallbackObserver<T> parent = new TimeoutFallbackObserver<T>(observer, this.aqu, this.aqv);
            observer.onSubscribe(parent);
            parent.startFirstTimeout(this.aqt);
            this.aha.subscribe(parent);
        }
    }

    static final class TimeoutConsumer
    extends AtomicReference<b>
    implements ag<Object>,
    b {
        private static final long serialVersionUID = 8708641127342403073L;
        final a parent;
        final long idx;

        TimeoutConsumer(long idx, a parent) {
            this.idx = idx;
            this.parent = parent;
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this, d2);
        }

        @Override
        public void onNext(Object t2) {
            b upstream = (b)this.get();
            if (upstream != DisposableHelper.DISPOSED) {
                upstream.dispose();
                this.lazySet(DisposableHelper.DISPOSED);
                this.parent.onTimeout(this.idx);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.get() != DisposableHelper.DISPOSED) {
                this.lazySet(DisposableHelper.DISPOSED);
                this.parent.onTimeoutError(this.idx, t2);
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.get() != DisposableHelper.DISPOSED) {
                this.lazySet(DisposableHelper.DISPOSED);
                this.parent.onTimeout(this.idx);
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }
    }

    static final class TimeoutFallbackObserver<T>
    extends AtomicReference<b>
    implements ag<T>,
    b,
    a {
        private static final long serialVersionUID = -7508389464265974549L;
        final ag<? super T> downstream;
        final h<? super T, ? extends ae<?>> itemTimeoutIndicator;
        final SequentialDisposable task;
        final AtomicLong index;
        final AtomicReference<b> upstream;
        ae<? extends T> fallback;

        TimeoutFallbackObserver(ag<? super T> actual, h<? super T, ? extends ae<?>> itemTimeoutIndicator, ae<? extends T> fallback) {
            this.downstream = actual;
            this.itemTimeoutIndicator = itemTimeoutIndicator;
            this.task = new SequentialDisposable();
            this.fallback = fallback;
            this.index = new AtomicLong();
            this.upstream = new AtomicReference();
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this.upstream, d2);
        }

        @Override
        public void onNext(T t2) {
            ae<?> itemTimeoutObservableSource;
            long idx = this.index.get();
            if (idx == Long.MAX_VALUE || !this.index.compareAndSet(idx, idx + 1L)) {
                return;
            }
            b d2 = (b)this.task.get();
            if (d2 != null) {
                d2.dispose();
            }
            this.downstream.onNext(t2);
            try {
                itemTimeoutObservableSource = Objects.requireNonNull(this.itemTimeoutIndicator.apply(t2), "The itemTimeoutIndicator returned a null ObservableSource.");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.get().dispose();
                this.index.getAndSet(Long.MAX_VALUE);
                this.downstream.onError(ex);
                return;
            }
            TimeoutConsumer consumer = new TimeoutConsumer(idx + 1L, this);
            if (this.task.replace(consumer)) {
                itemTimeoutObservableSource.subscribe(consumer);
            }
        }

        void startFirstTimeout(ae<?> firstTimeoutIndicator) {
            TimeoutConsumer consumer;
            if (firstTimeoutIndicator != null && this.task.replace(consumer = new TimeoutConsumer(0L, this))) {
                firstTimeoutIndicator.subscribe(consumer);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onError(t2);
                this.task.dispose();
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onComplete();
                this.task.dispose();
            }
        }

        @Override
        public void onTimeout(long idx) {
            if (this.index.compareAndSet(idx, Long.MAX_VALUE)) {
                DisposableHelper.dispose(this.upstream);
                ae<? super T> f2 = this.fallback;
                this.fallback = null;
                f2.subscribe(new ObservableTimeoutTimed.a<T>(this.downstream, this));
            }
        }

        @Override
        public void onTimeoutError(long idx, Throwable ex) {
            if (this.index.compareAndSet(idx, Long.MAX_VALUE)) {
                DisposableHelper.dispose(this);
                this.downstream.onError(ex);
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.upstream);
            DisposableHelper.dispose(this);
            this.task.dispose();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }
    }

    static final class TimeoutObserver<T>
    extends AtomicLong
    implements ag<T>,
    b,
    a {
        private static final long serialVersionUID = 3764492702657003550L;
        final ag<? super T> downstream;
        final h<? super T, ? extends ae<?>> itemTimeoutIndicator;
        final SequentialDisposable task;
        final AtomicReference<b> upstream;

        TimeoutObserver(ag<? super T> actual, h<? super T, ? extends ae<?>> itemTimeoutIndicator) {
            this.downstream = actual;
            this.itemTimeoutIndicator = itemTimeoutIndicator;
            this.task = new SequentialDisposable();
            this.upstream = new AtomicReference();
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this.upstream, d2);
        }

        @Override
        public void onNext(T t2) {
            ae<?> itemTimeoutObservableSource;
            long idx = this.get();
            if (idx == Long.MAX_VALUE || !this.compareAndSet(idx, idx + 1L)) {
                return;
            }
            b d2 = (b)this.task.get();
            if (d2 != null) {
                d2.dispose();
            }
            this.downstream.onNext(t2);
            try {
                itemTimeoutObservableSource = Objects.requireNonNull(this.itemTimeoutIndicator.apply(t2), "The itemTimeoutIndicator returned a null ObservableSource.");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.upstream.get().dispose();
                this.getAndSet(Long.MAX_VALUE);
                this.downstream.onError(ex);
                return;
            }
            TimeoutConsumer consumer = new TimeoutConsumer(idx + 1L, this);
            if (this.task.replace(consumer)) {
                itemTimeoutObservableSource.subscribe(consumer);
            }
        }

        void startFirstTimeout(ae<?> firstTimeoutIndicator) {
            TimeoutConsumer consumer;
            if (firstTimeoutIndicator != null && this.task.replace(consumer = new TimeoutConsumer(0L, this))) {
                firstTimeoutIndicator.subscribe(consumer);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onError(t2);
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onComplete();
            }
        }

        @Override
        public void onTimeout(long idx) {
            if (this.compareAndSet(idx, Long.MAX_VALUE)) {
                DisposableHelper.dispose(this.upstream);
                this.downstream.onError(new TimeoutException());
            }
        }

        @Override
        public void onTimeoutError(long idx, Throwable ex) {
            if (this.compareAndSet(idx, Long.MAX_VALUE)) {
                DisposableHelper.dispose(this.upstream);
                this.downstream.onError(ex);
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.upstream);
            this.task.dispose();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.upstream.get());
        }
    }

    static interface a
    extends ObservableTimeoutTimed.b {
        public void onTimeoutError(long var1, Throwable var3);
    }
}

