/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableTimeoutTimed<T>
extends io.reactivex.rxjava3.internal.operators.observable.a<T, T> {
    final long aqw;
    final TimeUnit aqx;
    final ah aqy;
    final ae<? extends T> aqz;

    public ObservableTimeoutTimed(z<T> source, long timeout, TimeUnit unit, ah scheduler, ae<? extends T> other) {
        super(source);
        this.aqw = timeout;
        this.aqx = unit;
        this.aqy = scheduler;
        this.aqz = other;
    }

    @Override
    protected void d(ag<? super T> observer) {
        if (this.aqz == null) {
            TimeoutObserver<T> parent = new TimeoutObserver<T>(observer, this.aqw, this.aqx, this.aqy.oS());
            observer.onSubscribe(parent);
            parent.startTimeout(0L);
            this.aha.subscribe(parent);
        } else {
            TimeoutFallbackObserver<T> parent = new TimeoutFallbackObserver<T>(observer, this.aqw, this.aqx, this.aqy.oS(), this.aqz);
            observer.onSubscribe(parent);
            parent.startTimeout(0L);
            this.aha.subscribe(parent);
        }
    }

    static interface b {
        public void onTimeout(long var1);
    }

    static final class a<T>
    implements ag<T> {
        final ag<? super T> aqA;
        final AtomicReference<io.reactivex.rxjava3.disposables.b> aqB;

        a(ag<? super T> actual, AtomicReference<io.reactivex.rxjava3.disposables.b> arbiter) {
            this.aqA = actual;
            this.aqB = arbiter;
        }

        @Override
        public void onSubscribe(io.reactivex.rxjava3.disposables.b d2) {
            DisposableHelper.replace(this.aqB, d2);
        }

        @Override
        public void onNext(T t2) {
            this.aqA.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.aqA.onError(t2);
        }

        @Override
        public void onComplete() {
            this.aqA.onComplete();
        }
    }

    static final class TimeoutFallbackObserver<T>
    extends AtomicReference<io.reactivex.rxjava3.disposables.b>
    implements ag<T>,
    io.reactivex.rxjava3.disposables.b,
    b {
        private static final long serialVersionUID = 3764492702657003550L;
        final ag<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final ah.c worker;
        final SequentialDisposable task;
        final AtomicLong index;
        final AtomicReference<io.reactivex.rxjava3.disposables.b> upstream;
        ae<? extends T> fallback;

        TimeoutFallbackObserver(ag<? super T> actual, long timeout, TimeUnit unit, ah.c worker, ae<? extends T> fallback) {
            this.downstream = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.fallback = fallback;
            this.task = new SequentialDisposable();
            this.index = new AtomicLong();
            this.upstream = new AtomicReference();
        }

        @Override
        public void onSubscribe(io.reactivex.rxjava3.disposables.b d2) {
            DisposableHelper.setOnce(this.upstream, d2);
        }

        @Override
        public void onNext(T t2) {
            long idx = this.index.get();
            if (idx == Long.MAX_VALUE || !this.index.compareAndSet(idx, idx + 1L)) {
                return;
            }
            ((io.reactivex.rxjava3.disposables.b)this.task.get()).dispose();
            this.downstream.onNext(t2);
            this.startTimeout(idx + 1L);
        }

        void startTimeout(long nextIndex) {
            this.task.replace(this.worker.b(new c(nextIndex, this), this.timeout, this.unit));
        }

        @Override
        public void onError(Throwable t2) {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onError(t2);
                this.worker.dispose();
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onComplete();
                this.worker.dispose();
            }
        }

        @Override
        public void onTimeout(long idx) {
            if (this.index.compareAndSet(idx, Long.MAX_VALUE)) {
                DisposableHelper.dispose(this.upstream);
                ae<? super T> f2 = this.fallback;
                this.fallback = null;
                f2.subscribe(new a<T>(this.downstream, this));
                this.worker.dispose();
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.upstream);
            DisposableHelper.dispose(this);
            this.worker.dispose();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((io.reactivex.rxjava3.disposables.b)this.get());
        }
    }

    static final class c
    implements Runnable {
        final b aqC;
        final long aqD;

        c(long idx, b parent) {
            this.aqD = idx;
            this.aqC = parent;
        }

        @Override
        public void run() {
            this.aqC.onTimeout(this.aqD);
        }
    }

    static final class TimeoutObserver<T>
    extends AtomicLong
    implements ag<T>,
    io.reactivex.rxjava3.disposables.b,
    b {
        private static final long serialVersionUID = 3764492702657003550L;
        final ag<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final ah.c worker;
        final SequentialDisposable task;
        final AtomicReference<io.reactivex.rxjava3.disposables.b> upstream;

        TimeoutObserver(ag<? super T> actual, long timeout, TimeUnit unit, ah.c worker) {
            this.downstream = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.task = new SequentialDisposable();
            this.upstream = new AtomicReference();
        }

        @Override
        public void onSubscribe(io.reactivex.rxjava3.disposables.b d2) {
            DisposableHelper.setOnce(this.upstream, d2);
        }

        @Override
        public void onNext(T t2) {
            long idx = this.get();
            if (idx == Long.MAX_VALUE || !this.compareAndSet(idx, idx + 1L)) {
                return;
            }
            ((io.reactivex.rxjava3.disposables.b)this.task.get()).dispose();
            this.downstream.onNext(t2);
            this.startTimeout(idx + 1L);
        }

        void startTimeout(long nextIndex) {
            this.task.replace(this.worker.b(new c(nextIndex, this), this.timeout, this.unit));
        }

        @Override
        public void onError(Throwable t2) {
            if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onError(t2);
                this.worker.dispose();
            } else {
                io.reactivex.rxjava3.d.a.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.dispose();
                this.downstream.onComplete();
                this.worker.dispose();
            }
        }

        @Override
        public void onTimeout(long idx) {
            if (this.compareAndSet(idx, Long.MAX_VALUE)) {
                DisposableHelper.dispose(this.upstream);
                this.downstream.onError(new TimeoutException(ExceptionHelper.Y(this.timeout, this.unit)));
                this.worker.dispose();
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.upstream);
            this.worker.dispose();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.upstream.get());
        }
    }
}

