/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.g;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObservableUsing<T, D>
extends z<T> {
    final s<? extends D> aqO;
    final h<? super D, ? extends ae<? extends T>> aqP;
    final g<? super D> aqQ;
    final boolean aqR;

    public ObservableUsing(s<? extends D> resourceSupplier, h<? super D, ? extends ae<? extends T>> sourceSupplier, g<? super D> disposer, boolean eager) {
        this.aqO = resourceSupplier;
        this.aqP = sourceSupplier;
        this.aqQ = disposer;
        this.aqR = eager;
    }

    @Override
    public void d(ag<? super T> observer) {
        ae<T> source;
        D resource;
        try {
            resource = this.aqO.get();
        }
        catch (Throwable e2) {
            io.reactivex.rxjava3.exceptions.a.k(e2);
            EmptyDisposable.error(e2, observer);
            return;
        }
        try {
            source = Objects.requireNonNull(this.aqP.apply(resource), "The sourceSupplier returned a null ObservableSource");
        }
        catch (Throwable e3) {
            io.reactivex.rxjava3.exceptions.a.k(e3);
            try {
                this.aqQ.accept(resource);
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                EmptyDisposable.error((Throwable)new CompositeException(e3, ex), observer);
                return;
            }
            EmptyDisposable.error(e3, observer);
            return;
        }
        UsingObserver<? super T, ? super D> us = new UsingObserver<T, D>(observer, resource, this.aqQ, this.aqR);
        source.subscribe(us);
    }

    static final class UsingObserver<T, D>
    extends AtomicBoolean
    implements ag<T>,
    b {
        private static final long serialVersionUID = 5904473792286235046L;
        final ag<? super T> downstream;
        final D resource;
        final g<? super D> disposer;
        final boolean eager;
        b upstream;

        UsingObserver(ag<? super T> actual, D resource, g<? super D> disposer, boolean eager) {
            this.downstream = actual;
            this.resource = resource;
            this.disposer = disposer;
            this.eager = eager;
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            this.downstream.onNext(t2);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.eager) {
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e2) {
                        io.reactivex.rxjava3.exceptions.a.k(e2);
                        t2 = new CompositeException(t2, e2);
                    }
                }
                this.downstream.onError(t2);
            } else {
                this.downstream.onError(t2);
                this.disposeResource();
            }
        }

        @Override
        public void onComplete() {
            if (this.eager) {
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e2) {
                        io.reactivex.rxjava3.exceptions.a.k(e2);
                        this.downstream.onError(e2);
                        return;
                    }
                }
                this.downstream.onComplete();
            } else {
                this.downstream.onComplete();
                this.disposeResource();
            }
        }

        @Override
        public void dispose() {
            if (this.eager) {
                this.disposeResource();
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
            } else {
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
                this.disposeResource();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }

        void disposeResource() {
            if (this.compareAndSet(false, true)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable e2) {
                    io.reactivex.rxjava3.exceptions.a.k(e2);
                    a.onError(e2);
                }
            }
        }
    }
}

