/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.a;
import io.reactivex.rxjava3.internal.operators.observable.ca;
import io.reactivex.rxjava3.subjects.UnicastSubject;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableWindow<T>
extends a<T, z<T>> {
    final long aqS;
    final long aqT;
    final int aqU;

    public ObservableWindow(ae<T> source, long count, long skip, int capacityHint) {
        super(source);
        this.aqS = count;
        this.aqT = skip;
        this.aqU = capacityHint;
    }

    @Override
    public void d(ag<? super z<T>> t2) {
        if (this.aqS == this.aqT) {
            this.aha.subscribe(new WindowExactObserver(t2, this.aqS, this.aqU));
        } else {
            this.aha.subscribe(new WindowSkipObserver(t2, this.aqS, this.aqT, this.aqU));
        }
    }

    static final class WindowSkipObserver<T>
    extends AtomicInteger
    implements ag<T>,
    b,
    Runnable {
        private static final long serialVersionUID = 3366976432059579510L;
        final ag<? super z<T>> downstream;
        final long count;
        final long skip;
        final int capacityHint;
        final ArrayDeque<UnicastSubject<T>> windows;
        final AtomicBoolean cancelled;
        long index;
        long firstEmission;
        b upstream;

        WindowSkipObserver(ag<? super z<T>> actual, long count, long skip, int capacityHint) {
            this.downstream = actual;
            this.count = count;
            this.skip = skip;
            this.capacityHint = capacityHint;
            this.windows = new ArrayDeque();
            this.cancelled = new AtomicBoolean();
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            ArrayDeque<UnicastSubject<T>> ws = this.windows;
            long i2 = this.index;
            long s2 = this.skip;
            ca intercept = null;
            if (i2 % s2 == 0L && !this.cancelled.get()) {
                this.getAndIncrement();
                UnicastSubject w2 = UnicastSubject.b(this.capacityHint, this);
                intercept = new ca(w2);
                ws.offer(w2);
                this.downstream.onNext(intercept);
            }
            long c2 = this.firstEmission + 1L;
            for (UnicastSubject<T> w3 : ws) {
                w3.onNext(t2);
            }
            if (c2 >= this.count) {
                ws.poll().onComplete();
                if (ws.isEmpty() && this.cancelled.get()) {
                    return;
                }
                this.firstEmission = c2 - s2;
            } else {
                this.firstEmission = c2;
            }
            this.index = i2 + 1L;
            if (intercept != null && intercept.tryAbandon()) {
                intercept.arh.onComplete();
            }
        }

        @Override
        public void onError(Throwable t2) {
            ArrayDeque<UnicastSubject<T>> ws = this.windows;
            while (!ws.isEmpty()) {
                ws.poll().onError(t2);
            }
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            ArrayDeque<UnicastSubject<T>> ws = this.windows;
            while (!ws.isEmpty()) {
                ws.poll().onComplete();
            }
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled.get();
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.dispose();
            }
        }
    }

    static final class WindowExactObserver<T>
    extends AtomicInteger
    implements ag<T>,
    b,
    Runnable {
        private static final long serialVersionUID = -7481782523886138128L;
        final ag<? super z<T>> downstream;
        final long count;
        final int capacityHint;
        final AtomicBoolean cancelled;
        long size;
        b upstream;
        UnicastSubject<T> window;

        WindowExactObserver(ag<? super z<T>> actual, long count, int capacityHint) {
            this.downstream = actual;
            this.count = count;
            this.capacityHint = capacityHint;
            this.cancelled = new AtomicBoolean();
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            UnicastSubject<T> w2 = this.window;
            ca<T> intercept = null;
            if (w2 == null && !this.cancelled.get()) {
                this.getAndIncrement();
                w2 = UnicastSubject.b(this.capacityHint, this);
                this.window = w2;
                intercept = new ca<T>(w2);
                this.downstream.onNext(intercept);
            }
            if (w2 != null) {
                w2.onNext(t2);
                if (++this.size >= this.count) {
                    this.size = 0L;
                    this.window = null;
                    w2.onComplete();
                }
                if (intercept != null && intercept.tryAbandon()) {
                    this.window = null;
                    w2.onComplete();
                    w2 = null;
                }
            }
        }

        @Override
        public void onError(Throwable t2) {
            UnicastSubject<T> w2 = this.window;
            if (w2 != null) {
                this.window = null;
                w2.onError(t2);
            }
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            UnicastSubject<T> w2 = this.window;
            if (w2 != null) {
                this.window = null;
                w2.onComplete();
            }
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled.get();
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.dispose();
            }
        }
    }
}

