/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.ca;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.observers.e;
import io.reactivex.rxjava3.subjects.UnicastSubject;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableWindowBoundary<T, B>
extends io.reactivex.rxjava3.internal.operators.observable.a<T, z<T>> {
    final ae<B> aqV;
    final int aqW;

    public ObservableWindowBoundary(ae<T> source, ae<B> other, int capacityHint) {
        super(source);
        this.aqV = other;
        this.aqW = capacityHint;
    }

    @Override
    public void d(ag<? super z<T>> observer) {
        WindowBoundaryMainObserver parent = new WindowBoundaryMainObserver(observer, this.aqW);
        observer.onSubscribe(parent);
        this.aqV.subscribe(parent.boundaryObserver);
        this.aha.subscribe(parent);
    }

    static final class a<T, B>
    extends e<B> {
        final WindowBoundaryMainObserver<T, B> aqX;
        boolean done;

        a(WindowBoundaryMainObserver<T, B> parent) {
            this.aqX = parent;
        }

        @Override
        public void onNext(B t2) {
            if (this.done) {
                return;
            }
            this.aqX.innerNext();
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
                return;
            }
            this.done = true;
            this.aqX.innerError(t2);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.aqX.innerComplete();
        }
    }

    static final class WindowBoundaryMainObserver<T, B>
    extends AtomicInteger
    implements ag<T>,
    b,
    Runnable {
        private static final long serialVersionUID = 2233020065421370272L;
        final ag<? super z<T>> downstream;
        final int capacityHint;
        final a<T, B> boundaryObserver;
        final AtomicReference<b> upstream;
        final AtomicInteger windows;
        final MpscLinkedQueue<Object> queue;
        final AtomicThrowable errors;
        final AtomicBoolean stopWindows;
        static final Object NEXT_WINDOW = new Object();
        volatile boolean done;
        UnicastSubject<T> window;

        WindowBoundaryMainObserver(ag<? super z<T>> downstream, int capacityHint) {
            this.downstream = downstream;
            this.capacityHint = capacityHint;
            this.boundaryObserver = new a(this);
            this.upstream = new AtomicReference();
            this.windows = new AtomicInteger(1);
            this.queue = new MpscLinkedQueue();
            this.errors = new AtomicThrowable();
            this.stopWindows = new AtomicBoolean();
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.setOnce(this.upstream, d2)) {
                this.innerNext();
            }
        }

        @Override
        public void onNext(T t2) {
            this.queue.offer(t2);
            this.drain();
        }

        @Override
        public void onError(Throwable e2) {
            this.boundaryObserver.dispose();
            if (this.errors.tryAddThrowableOrReport(e2)) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.boundaryObserver.dispose();
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            if (this.stopWindows.compareAndSet(false, true)) {
                this.boundaryObserver.dispose();
                if (this.windows.decrementAndGet() == 0) {
                    DisposableHelper.dispose(this.upstream);
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.stopWindows.get();
        }

        @Override
        public void run() {
            if (this.windows.decrementAndGet() == 0) {
                DisposableHelper.dispose(this.upstream);
            }
        }

        void innerNext() {
            this.queue.offer(NEXT_WINDOW);
            this.drain();
        }

        void innerError(Throwable e2) {
            DisposableHelper.dispose(this.upstream);
            if (this.errors.tryAddThrowableOrReport(e2)) {
                this.done = true;
                this.drain();
            }
        }

        void innerComplete() {
            DisposableHelper.dispose(this.upstream);
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            ag<z<ca<T>>> downstream = this.downstream;
            MpscLinkedQueue<Object> queue = this.queue;
            AtomicThrowable errors = this.errors;
            while (true) {
                boolean empty;
                if (this.windows.get() == 0) {
                    queue.clear();
                    this.window = null;
                    return;
                }
                UnicastSubject<Object> w2 = this.window;
                boolean d2 = this.done;
                if (d2 && errors.get() != null) {
                    queue.clear();
                    Throwable ex = errors.terminate();
                    if (w2 != null) {
                        this.window = null;
                        w2.onError(ex);
                    }
                    downstream.onError(ex);
                    return;
                }
                Object v2 = queue.poll();
                boolean bl2 = empty = v2 == null;
                if (d2 && empty) {
                    Throwable ex = errors.terminate();
                    if (ex == null) {
                        if (w2 != null) {
                            this.window = null;
                            w2.onComplete();
                        }
                        downstream.onComplete();
                    } else {
                        if (w2 != null) {
                            this.window = null;
                            w2.onError(ex);
                        }
                        downstream.onError(ex);
                    }
                    return;
                }
                if (!empty) {
                    if (v2 != NEXT_WINDOW) {
                        w2.onNext(v2);
                        continue;
                    }
                    if (w2 != null) {
                        this.window = null;
                        w2.onComplete();
                    }
                    if (this.stopWindows.get()) continue;
                    w2 = UnicastSubject.b(this.capacityHint, this);
                    this.window = w2;
                    this.windows.getAndIncrement();
                    ca<T> intercept = new ca<T>(w2);
                    downstream.onNext(intercept);
                    if (!intercept.tryAbandon()) continue;
                    w2.onComplete();
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

