/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.a;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.f;
import io.reactivex.rxjava3.subjects.UnicastSubject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableWindowBoundarySelector<T, B, V>
extends a<T, z<T>> {
    final ae<B> aqY;
    final h<? super B, ? extends ae<V>> aqZ;
    final int ara;

    public ObservableWindowBoundarySelector(ae<T> source, ae<B> open, h<? super B, ? extends ae<V>> closingIndicator, int bufferSize) {
        super(source);
        this.aqY = open;
        this.aqZ = closingIndicator;
        this.ara = bufferSize;
    }

    @Override
    public void d(ag<? super z<T>> t2) {
        this.aha.subscribe(new WindowBoundaryMainObserver(t2, this.aqY, this.aqZ, this.ara));
    }

    static final class WindowBoundaryMainObserver<T, B, V>
    extends AtomicInteger
    implements ag<T>,
    io.reactivex.rxjava3.disposables.b,
    Runnable {
        private static final long serialVersionUID = 8646217640096099753L;
        final ag<? super z<T>> downstream;
        final ae<B> open;
        final h<? super B, ? extends ae<V>> closingIndicator;
        final int bufferSize;
        final io.reactivex.rxjava3.disposables.a resources;
        final WindowStartObserver<B> startObserver;
        final List<UnicastSubject<T>> windows;
        final f<Object> queue;
        final AtomicLong windowCount;
        final AtomicBoolean downstreamDisposed;
        final AtomicLong requested;
        long emitted;
        volatile boolean upstreamCanceled;
        volatile boolean upstreamDone;
        volatile boolean openDone;
        final AtomicThrowable error;
        io.reactivex.rxjava3.disposables.b upstream;

        WindowBoundaryMainObserver(ag<? super z<T>> downstream, ae<B> open, h<? super B, ? extends ae<V>> closingIndicator, int bufferSize) {
            this.downstream = downstream;
            this.queue = new MpscLinkedQueue<Object>();
            this.open = open;
            this.closingIndicator = closingIndicator;
            this.bufferSize = bufferSize;
            this.resources = new io.reactivex.rxjava3.disposables.a();
            this.windows = new ArrayList<UnicastSubject<T>>();
            this.windowCount = new AtomicLong(1L);
            this.downstreamDisposed = new AtomicBoolean();
            this.error = new AtomicThrowable();
            this.startObserver = new WindowStartObserver(this);
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(io.reactivex.rxjava3.disposables.b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
                this.open.subscribe(this.startObserver);
            }
        }

        @Override
        public void onNext(T t2) {
            this.queue.offer(t2);
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            this.startObserver.dispose();
            this.resources.dispose();
            if (this.error.tryAddThrowableOrReport(t2)) {
                this.upstreamDone = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.startObserver.dispose();
            this.resources.dispose();
            this.upstreamDone = true;
            this.drain();
        }

        @Override
        public void dispose() {
            if (this.downstreamDisposed.compareAndSet(false, true)) {
                if (this.windowCount.decrementAndGet() == 0L) {
                    this.upstream.dispose();
                    this.startObserver.dispose();
                    this.resources.dispose();
                    this.error.tryTerminateAndReport();
                    this.upstreamCanceled = true;
                    this.drain();
                } else {
                    this.startObserver.dispose();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.downstreamDisposed.get();
        }

        @Override
        public void run() {
            if (this.windowCount.decrementAndGet() == 0L) {
                this.upstream.dispose();
                this.startObserver.dispose();
                this.resources.dispose();
                this.error.tryTerminateAndReport();
                this.upstreamCanceled = true;
                this.drain();
            }
        }

        void open(B startValue) {
            this.queue.offer(new b<B>(startValue));
            this.drain();
        }

        void openError(Throwable t2) {
            this.upstream.dispose();
            this.resources.dispose();
            if (this.error.tryAddThrowableOrReport(t2)) {
                this.upstreamDone = true;
                this.drain();
            }
        }

        void openComplete() {
            this.openDone = true;
            this.drain();
        }

        void close(a<T, V> what) {
            this.queue.offer(what);
            this.drain();
        }

        void closeError(Throwable t2) {
            this.upstream.dispose();
            this.startObserver.dispose();
            this.resources.dispose();
            if (this.error.tryAddThrowableOrReport(t2)) {
                this.upstreamDone = true;
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            ag downstream = this.downstream;
            f<Object> queue = this.queue;
            List<UnicastSubject<T>> windows = this.windows;
            block2: while (true) {
                if (this.upstreamCanceled) {
                    queue.clear();
                    windows.clear();
                } else {
                    boolean isEmpty;
                    boolean isDone = this.upstreamDone;
                    Object o2 = queue.poll();
                    boolean bl2 = isEmpty = o2 == null;
                    if (isDone && (isEmpty || this.error.get() != null)) {
                        this.terminateDownstream(downstream);
                        this.upstreamCanceled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        if (o2 instanceof b) {
                            ae<V> endSource;
                            if (this.downstreamDisposed.get()) continue;
                            Object startItem = ((b)o2).arg;
                            try {
                                endSource = Objects.requireNonNull(this.closingIndicator.apply(startItem), "The closingIndicator returned a null ObservableSource");
                            }
                            catch (Throwable ex) {
                                io.reactivex.rxjava3.exceptions.a.k(ex);
                                this.upstream.dispose();
                                this.startObserver.dispose();
                                this.resources.dispose();
                                io.reactivex.rxjava3.exceptions.a.k(ex);
                                this.error.tryAddThrowableOrReport(ex);
                                this.upstreamDone = true;
                                continue;
                            }
                            this.windowCount.getAndIncrement();
                            UnicastSubject newWindow = UnicastSubject.b(this.bufferSize, this);
                            a endObserver = new a(this, newWindow);
                            downstream.onNext(endObserver);
                            if (endObserver.tryAbandon()) {
                                newWindow.onComplete();
                                continue;
                            }
                            windows.add(newWindow);
                            this.resources.a((io.reactivex.rxjava3.disposables.b)endObserver);
                            endSource.subscribe(endObserver);
                            continue;
                        }
                        if (o2 instanceof a) {
                            UnicastSubject w2 = ((a)o2).ard;
                            windows.remove(w2);
                            this.resources.c((io.reactivex.rxjava3.disposables.b)o2);
                            w2.onComplete();
                            continue;
                        }
                        Object item = o2;
                        Iterator<UnicastSubject<T>> iterator = windows.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block2;
                            UnicastSubject<Object> w3 = iterator.next();
                            w3.onNext(item);
                        }
                    }
                    if (this.openDone && windows.size() == 0) {
                        this.upstream.dispose();
                        this.startObserver.dispose();
                        this.resources.dispose();
                        this.terminateDownstream(downstream);
                        this.upstreamCanceled = true;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void terminateDownstream(ag<?> downstream) {
            Throwable ex = this.error.terminate();
            if (ex == null) {
                for (UnicastSubject<T> w2 : this.windows) {
                    w2.onComplete();
                }
                downstream.onComplete();
            } else if (ex != ExceptionHelper.azB) {
                for (UnicastSubject<T> w3 : this.windows) {
                    w3.onError(ex);
                }
                downstream.onError(ex);
            }
        }

        static final class a<T, V>
        extends z<T>
        implements ag<V>,
        io.reactivex.rxjava3.disposables.b {
            final WindowBoundaryMainObserver<T, ?, V> arb;
            final UnicastSubject<T> ard;
            final AtomicReference<io.reactivex.rxjava3.disposables.b> are;
            final AtomicBoolean arf;

            a(WindowBoundaryMainObserver<T, ?, V> parent, UnicastSubject<T> window) {
                this.arb = parent;
                this.ard = window;
                this.are = new AtomicReference();
                this.arf = new AtomicBoolean();
            }

            @Override
            public void onSubscribe(io.reactivex.rxjava3.disposables.b d2) {
                DisposableHelper.setOnce(this.are, d2);
            }

            @Override
            public void onNext(V t2) {
                if (DisposableHelper.dispose(this.are)) {
                    this.arb.close(this);
                }
            }

            @Override
            public void onError(Throwable t2) {
                if (this.isDisposed()) {
                    io.reactivex.rxjava3.d.a.onError(t2);
                } else {
                    this.arb.closeError(t2);
                }
            }

            @Override
            public void onComplete() {
                this.arb.close(this);
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this.are);
            }

            @Override
            public boolean isDisposed() {
                return this.are.get() == DisposableHelper.DISPOSED;
            }

            @Override
            protected void d(ag<? super T> o2) {
                this.ard.subscribe(o2);
                this.arf.set(true);
            }

            boolean tryAbandon() {
                return !this.arf.get() && this.arf.compareAndSet(false, true);
            }
        }

        static final class WindowStartObserver<B>
        extends AtomicReference<io.reactivex.rxjava3.disposables.b>
        implements ag<B> {
            private static final long serialVersionUID = -3326496781427702834L;
            final WindowBoundaryMainObserver<?, B, ?> parent;

            WindowStartObserver(WindowBoundaryMainObserver<?, B, ?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(io.reactivex.rxjava3.disposables.b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onNext(B t2) {
                this.parent.open(t2);
            }

            @Override
            public void onError(Throwable t2) {
                this.parent.openError(t2);
            }

            @Override
            public void onComplete() {
                this.parent.openComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }

        static final class b<B> {
            final B arg;

            b(B item) {
                this.arg = item;
            }
        }
    }
}

