/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.operators.observable.a;
import io.reactivex.rxjava3.internal.operators.observable.ca;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.operators.f;
import io.reactivex.rxjava3.subjects.UnicastSubject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableWindowTimed<T>
extends a<T, z<T>> {
    final long arj;
    final long ark;
    final TimeUnit arl;
    final ah arm;
    final long arn;
    final int aro;
    final boolean arp;

    public ObservableWindowTimed(z<T> source, long timespan, long timeskip, TimeUnit unit, ah scheduler, long maxSize, int bufferSize, boolean restartTimerOnMaxSize) {
        super(source);
        this.arj = timespan;
        this.ark = timeskip;
        this.arl = unit;
        this.arm = scheduler;
        this.arn = maxSize;
        this.aro = bufferSize;
        this.arp = restartTimerOnMaxSize;
    }

    @Override
    protected void d(ag<? super z<T>> downstream) {
        if (this.arj == this.ark) {
            if (this.arn == Long.MAX_VALUE) {
                this.aha.subscribe(new WindowExactUnboundedObserver(downstream, this.arj, this.arl, this.arm, this.aro));
                return;
            }
            this.aha.subscribe(new WindowExactBoundedObserver(downstream, this.arj, this.arl, this.arm, this.aro, this.arn, this.arp));
            return;
        }
        this.aha.subscribe(new WindowSkipObserver(downstream, this.arj, this.ark, this.arl, this.arm.oS(), this.aro));
    }

    static final class WindowSkipObserver<T>
    extends AbstractWindowObserver<T>
    implements Runnable {
        private static final long serialVersionUID = -7852870764194095894L;
        final long timeskip;
        final ah.c worker;
        final List<UnicastSubject<T>> windows;
        static final Object WINDOW_OPEN = new Object();
        static final Object WINDOW_CLOSE = new Object();

        WindowSkipObserver(ag<? super z<T>> actual, long timespan, long timeskip, TimeUnit unit, ah.c worker, int bufferSize) {
            super(actual, timespan, unit, bufferSize);
            this.timeskip = timeskip;
            this.worker = worker;
            this.windows = new LinkedList<UnicastSubject<T>>();
        }

        @Override
        void createFirstWindow() {
            if (!this.downstreamCancelled.get()) {
                this.emitted = 1L;
                this.windowCount.getAndIncrement();
                UnicastSubject window = UnicastSubject.b(this.bufferSize, this);
                this.windows.add(window);
                ca intercept = new ca(window);
                this.downstream.onNext(intercept);
                this.worker.b(new a(this, false), this.timespan, this.unit);
                this.worker.b(new a(this, true), this.timeskip, this.timeskip, this.unit);
                if (intercept.tryAbandon()) {
                    window.onComplete();
                    this.windows.remove(window);
                }
            }
        }

        @Override
        void cleanupResources() {
            this.worker.dispose();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            f queue = this.queue;
            ag downstream = this.downstream;
            List<UnicastSubject<T>> windows = this.windows;
            block0: while (true) {
                if (this.upstreamCancelled) {
                    queue.clear();
                    windows.clear();
                } else {
                    boolean isEmpty;
                    boolean isDone = this.done;
                    Object o2 = queue.poll();
                    boolean bl2 = isEmpty = o2 == null;
                    if (isDone && isEmpty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            for (UnicastSubject window : windows) {
                                window.onError(ex);
                            }
                            downstream.onError(ex);
                        } else {
                            for (UnicastSubject window : windows) {
                                window.onComplete();
                            }
                            downstream.onComplete();
                        }
                        this.cleanupResources();
                        this.upstreamCancelled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        UnicastSubject window;
                        if (o2 == WINDOW_OPEN) {
                            if (this.downstreamCancelled.get()) continue;
                            long emitted = this.emitted;
                            this.emitted = ++emitted;
                            this.windowCount.getAndIncrement();
                            window = UnicastSubject.b(this.bufferSize, this);
                            windows.add(window);
                            ca<T> intercept = new ca<T>(window);
                            downstream.onNext(intercept);
                            this.worker.b(new a(this, false), this.timespan, this.unit);
                            if (!intercept.tryAbandon()) continue;
                            window.onComplete();
                            continue;
                        }
                        if (o2 == WINDOW_CLOSE) {
                            if (windows.isEmpty()) continue;
                            windows.remove(0).onComplete();
                            continue;
                        }
                        Object item = o2;
                        Iterator<UnicastSubject<T>> iterator = windows.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block0;
                            window = iterator.next();
                            window.onNext(item);
                        }
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void run() {
            this.windowDone();
        }

        void boundary(boolean isOpen) {
            this.queue.offer(isOpen ? WINDOW_OPEN : WINDOW_CLOSE);
            this.drain();
        }

        static final class a
        implements Runnable {
            final WindowSkipObserver<?> art;
            final boolean aru;

            a(WindowSkipObserver<?> parent, boolean isOpen) {
                this.art = parent;
                this.aru = isOpen;
            }

            @Override
            public void run() {
                this.art.boundary(this.aru);
            }
        }
    }

    static final class WindowExactBoundedObserver<T>
    extends AbstractWindowObserver<T>
    implements Runnable {
        private static final long serialVersionUID = -6130475889925953722L;
        final ah scheduler;
        final boolean restartTimerOnMaxSize;
        final long maxSize;
        final ah.c worker;
        long count;
        UnicastSubject<T> window;
        final SequentialDisposable timer;

        WindowExactBoundedObserver(ag<? super z<T>> actual, long timespan, TimeUnit unit, ah scheduler, int bufferSize, long maxSize, boolean restartTimerOnMaxSize) {
            super(actual, timespan, unit, bufferSize);
            this.scheduler = scheduler;
            this.maxSize = maxSize;
            this.restartTimerOnMaxSize = restartTimerOnMaxSize;
            this.worker = restartTimerOnMaxSize ? scheduler.oS() : null;
            this.timer = new SequentialDisposable();
        }

        @Override
        void createFirstWindow() {
            if (!this.downstreamCancelled.get()) {
                this.emitted = 1L;
                this.windowCount.getAndIncrement();
                this.window = UnicastSubject.b(this.bufferSize, this);
                ca<T> intercept = new ca<T>(this.window);
                this.downstream.onNext(intercept);
                a boundaryTask = new a(this, 1L);
                if (this.restartTimerOnMaxSize) {
                    this.timer.replace(this.worker.b(boundaryTask, this.timespan, this.timespan, this.unit));
                } else {
                    this.timer.replace(this.scheduler.a(boundaryTask, this.timespan, this.timespan, this.unit));
                }
                if (intercept.tryAbandon()) {
                    this.window.onComplete();
                }
            }
        }

        @Override
        public void run() {
            this.windowDone();
        }

        @Override
        void cleanupResources() {
            this.timer.dispose();
            ah.c w2 = this.worker;
            if (w2 != null) {
                w2.dispose();
            }
        }

        void boundary(a sender) {
            this.queue.offer(sender);
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            f queue = this.queue;
            ag downstream = this.downstream;
            UnicastSubject window = this.window;
            while (true) {
                if (this.upstreamCancelled) {
                    queue.clear();
                    window = null;
                    this.window = null;
                } else {
                    boolean isEmpty;
                    boolean isDone = this.done;
                    Object o2 = queue.poll();
                    boolean bl2 = isEmpty = o2 == null;
                    if (isDone && isEmpty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            if (window != null) {
                                window.onError(ex);
                            }
                            downstream.onError(ex);
                        } else {
                            if (window != null) {
                                window.onComplete();
                            }
                            downstream.onComplete();
                        }
                        this.cleanupResources();
                        this.upstreamCancelled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        if (o2 instanceof a) {
                            a boundary = (a)o2;
                            if (boundary.arr != this.emitted && this.restartTimerOnMaxSize) continue;
                            this.count = 0L;
                            window = this.createNewWindow(window);
                            continue;
                        }
                        if (window == null) continue;
                        Object item = o2;
                        window.onNext(item);
                        long count = this.count + 1L;
                        if (count == this.maxSize) {
                            this.count = 0L;
                            window = this.createNewWindow(window);
                            continue;
                        }
                        this.count = count;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        UnicastSubject<T> createNewWindow(UnicastSubject<T> window) {
            if (window != null) {
                window.onComplete();
                window = null;
            }
            if (this.downstreamCancelled.get()) {
                this.cleanupResources();
            } else {
                long emitted = this.emitted;
                this.emitted = ++emitted;
                this.windowCount.getAndIncrement();
                window = UnicastSubject.b(this.bufferSize, this);
                this.window = window;
                ca<T> intercept = new ca<T>(window);
                this.downstream.onNext(intercept);
                if (this.restartTimerOnMaxSize) {
                    this.timer.update(this.worker.b(new a(this, emitted), this.timespan, this.timespan, this.unit));
                }
                if (intercept.tryAbandon()) {
                    window.onComplete();
                }
            }
            return window;
        }

        static final class a
        implements Runnable {
            final WindowExactBoundedObserver<?> arq;
            final long arr;

            a(WindowExactBoundedObserver<?> parent, long index) {
                this.arq = parent;
                this.arr = index;
            }

            @Override
            public void run() {
                this.arq.boundary(this);
            }
        }
    }

    static final class WindowExactUnboundedObserver<T>
    extends AbstractWindowObserver<T>
    implements Runnable {
        private static final long serialVersionUID = 1155822639622580836L;
        final ah scheduler;
        UnicastSubject<T> window;
        final SequentialDisposable timer;
        static final Object NEXT_WINDOW = new Object();
        final Runnable windowRunnable;

        WindowExactUnboundedObserver(ag<? super z<T>> actual, long timespan, TimeUnit unit, ah scheduler, int bufferSize) {
            super(actual, timespan, unit, bufferSize);
            this.scheduler = scheduler;
            this.timer = new SequentialDisposable();
            this.windowRunnable = new a();
        }

        @Override
        void createFirstWindow() {
            if (!this.downstreamCancelled.get()) {
                this.windowCount.getAndIncrement();
                this.window = UnicastSubject.b(this.bufferSize, this.windowRunnable);
                this.emitted = 1L;
                ca<T> intercept = new ca<T>(this.window);
                this.downstream.onNext(intercept);
                this.timer.replace(this.scheduler.a(this, this.timespan, this.timespan, this.unit));
                if (intercept.tryAbandon()) {
                    this.window.onComplete();
                }
            }
        }

        @Override
        public void run() {
            this.queue.offer(NEXT_WINDOW);
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            f queue = this.queue;
            ag downstream = this.downstream;
            UnicastSubject window = this.window;
            int missed = 1;
            while (true) {
                if (this.upstreamCancelled) {
                    queue.clear();
                    window = null;
                    this.window = null;
                } else {
                    boolean isEmpty;
                    boolean isDone = this.done;
                    Object o2 = queue.poll();
                    boolean bl2 = isEmpty = o2 == null;
                    if (isDone && isEmpty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            if (window != null) {
                                window.onError(ex);
                            }
                            downstream.onError(ex);
                        } else {
                            if (window != null) {
                                window.onComplete();
                            }
                            downstream.onComplete();
                        }
                        this.cleanupResources();
                        this.upstreamCancelled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        if (o2 == NEXT_WINDOW) {
                            if (window != null) {
                                window.onComplete();
                                window = null;
                                this.window = null;
                            }
                            if (this.downstreamCancelled.get()) {
                                this.timer.dispose();
                                continue;
                            }
                            ++this.emitted;
                            this.windowCount.getAndIncrement();
                            window = UnicastSubject.b(this.bufferSize, this.windowRunnable);
                            this.window = window;
                            ca<T> intercept = new ca<T>(window);
                            downstream.onNext(intercept);
                            if (!intercept.tryAbandon()) continue;
                            window.onComplete();
                            continue;
                        }
                        if (window == null) continue;
                        Object item = o2;
                        window.onNext(item);
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        void cleanupResources() {
            this.timer.dispose();
        }

        final class a
        implements Runnable {
            a() {
            }

            @Override
            public void run() {
                WindowExactUnboundedObserver.this.windowDone();
            }
        }
    }

    static abstract class AbstractWindowObserver<T>
    extends AtomicInteger
    implements ag<T>,
    b {
        private static final long serialVersionUID = 5724293814035355511L;
        final ag<? super z<T>> downstream;
        final f<Object> queue;
        final long timespan;
        final TimeUnit unit;
        final int bufferSize;
        long emitted;
        volatile boolean done;
        Throwable error;
        b upstream;
        final AtomicBoolean downstreamCancelled;
        volatile boolean upstreamCancelled;
        final AtomicInteger windowCount;

        AbstractWindowObserver(ag<? super z<T>> downstream, long timespan, TimeUnit unit, int bufferSize) {
            this.downstream = downstream;
            this.queue = new MpscLinkedQueue<Object>();
            this.timespan = timespan;
            this.unit = unit;
            this.bufferSize = bufferSize;
            this.downstreamCancelled = new AtomicBoolean();
            this.windowCount = new AtomicInteger(1);
        }

        @Override
        public final void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
                this.createFirstWindow();
            }
        }

        abstract void createFirstWindow();

        @Override
        public final void onNext(T t2) {
            this.queue.offer(t2);
            this.drain();
        }

        @Override
        public final void onError(Throwable t2) {
            this.error = t2;
            this.done = true;
            this.drain();
        }

        @Override
        public final void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public final void dispose() {
            if (this.downstreamCancelled.compareAndSet(false, true)) {
                this.windowDone();
            }
        }

        @Override
        public final boolean isDisposed() {
            return this.downstreamCancelled.get();
        }

        final void windowDone() {
            if (this.windowCount.decrementAndGet() == 0) {
                this.cleanupResources();
                this.upstream.dispose();
                this.upstreamCancelled = true;
                this.drain();
            }
        }

        abstract void cleanupResources();

        abstract void drain();
    }
}

