/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.b.c;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.observers.m;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableWithLatestFrom<T, U, R>
extends io.reactivex.rxjava3.internal.operators.observable.a<T, R> {
    final c<? super T, ? super U, ? extends R> arv;
    final ae<? extends U> arw;

    public ObservableWithLatestFrom(ae<T> source, c<? super T, ? super U, ? extends R> combiner, ae<? extends U> other) {
        super(source);
        this.arv = combiner;
        this.arw = other;
    }

    @Override
    public void d(ag<? super R> t2) {
        m<R> serial = new m<R>(t2);
        WithLatestFromObserver<? super T, ? super U, ? extends R> wlf = new WithLatestFromObserver<T, U, R>(serial, this.arv);
        serial.onSubscribe(wlf);
        this.arw.subscribe(new a(wlf));
        this.aha.subscribe(wlf);
    }

    final class a
    implements ag<U> {
        private final WithLatestFromObserver<T, U, R> arx;

        a(WithLatestFromObserver<T, U, R> parent) {
            this.arx = parent;
        }

        @Override
        public void onSubscribe(b d2) {
            this.arx.setOther(d2);
        }

        @Override
        public void onNext(U t2) {
            this.arx.lazySet(t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.arx.otherError(t2);
        }

        @Override
        public void onComplete() {
        }
    }

    static final class WithLatestFromObserver<T, U, R>
    extends AtomicReference<U>
    implements ag<T>,
    b {
        private static final long serialVersionUID = -312246233408980075L;
        final ag<? super R> downstream;
        final c<? super T, ? super U, ? extends R> combiner;
        final AtomicReference<b> upstream = new AtomicReference();
        final AtomicReference<b> other = new AtomicReference();

        WithLatestFromObserver(ag<? super R> actual, c<? super T, ? super U, ? extends R> combiner) {
            this.downstream = actual;
            this.combiner = combiner;
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this.upstream, d2);
        }

        @Override
        public void onNext(T t2) {
            Object u2 = this.get();
            if (u2 != null) {
                R r2;
                try {
                    r2 = Objects.requireNonNull(this.combiner.apply(t2, u2), "The combiner returned a null value");
                }
                catch (Throwable e2) {
                    io.reactivex.rxjava3.exceptions.a.k(e2);
                    this.dispose();
                    this.downstream.onError(e2);
                    return;
                }
                this.downstream.onNext(r2);
            }
        }

        @Override
        public void onError(Throwable t2) {
            DisposableHelper.dispose(this.other);
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            DisposableHelper.dispose(this.other);
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.upstream);
            DisposableHelper.dispose(this.other);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.upstream.get());
        }

        public boolean setOther(b o2) {
            return DisposableHelper.setOnce(this.other, o2);
        }

        public void otherError(Throwable e2) {
            DisposableHelper.dispose(this.upstream);
            this.downstream.onError(e2);
        }
    }
}

