/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.operators.observable.ba;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.g;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class ObservableWithLatestFromMany<T, R>
extends io.reactivex.rxjava3.internal.operators.observable.a<T, R> {
    @f
    final ae<?>[] arz;
    @f
    final Iterable<? extends ae<?>> arA;
    @e
    final h<? super Object[], R> arB;

    public ObservableWithLatestFromMany(@e ae<T> source, @e ae<?>[] otherArray, @e h<? super Object[], R> combiner) {
        super(source);
        this.arz = otherArray;
        this.arA = null;
        this.arB = combiner;
    }

    public ObservableWithLatestFromMany(@e ae<T> source, @e Iterable<? extends ae<?>> otherIterable, @e h<? super Object[], R> combiner) {
        super(source);
        this.arz = null;
        this.arA = otherIterable;
        this.arB = combiner;
    }

    @Override
    protected void d(ag<? super R> observer) {
        ae<?>[] others = this.arz;
        int n2 = 0;
        if (others == null) {
            others = new ae[8];
            try {
                for (ae<?> p2 : this.arA) {
                    if (n2 == others.length) {
                        others = Arrays.copyOf(others, n2 + (n2 >> 1));
                    }
                    others[n2++] = p2;
                }
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                EmptyDisposable.error(ex, observer);
                return;
            }
        } else {
            n2 = others.length;
        }
        if (n2 == 0) {
            new ba(this.aha, new a()).d(observer);
            return;
        }
        WithLatestFromObserver parent = new WithLatestFromObserver(observer, this.arB, n2);
        observer.onSubscribe(parent);
        parent.subscribe(others, n2);
        this.aha.subscribe(parent);
    }

    final class a
    implements h<T, R> {
        a() {
        }

        @Override
        public R apply(T t2) throws Throwable {
            return Objects.requireNonNull(ObservableWithLatestFromMany.this.arB.apply((Object[])new Object[]{t2}), "The combiner returned a null value");
        }
    }

    static final class WithLatestInnerObserver
    extends AtomicReference<b>
    implements ag<Object> {
        private static final long serialVersionUID = 3256684027868224024L;
        final WithLatestFromObserver<?, ?> parent;
        final int index;
        boolean hasValue;

        WithLatestInnerObserver(WithLatestFromObserver<?, ?> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this, d2);
        }

        @Override
        public void onNext(Object t2) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.parent.innerNext(this.index, t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.innerError(this.index, t2);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this.index, this.hasValue);
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }
    }

    static final class WithLatestFromObserver<T, R>
    extends AtomicInteger
    implements ag<T>,
    b {
        private static final long serialVersionUID = 1577321883966341961L;
        final ag<? super R> downstream;
        final h<? super Object[], R> combiner;
        final WithLatestInnerObserver[] observers;
        final AtomicReferenceArray<Object> values;
        final AtomicReference<b> upstream;
        final AtomicThrowable error;
        volatile boolean done;

        WithLatestFromObserver(ag<? super R> actual, h<? super Object[], R> combiner, int n2) {
            this.downstream = actual;
            this.combiner = combiner;
            WithLatestInnerObserver[] s2 = new WithLatestInnerObserver[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                s2[i2] = new WithLatestInnerObserver(this, i2);
            }
            this.observers = s2;
            this.values = new AtomicReferenceArray(n2);
            this.upstream = new AtomicReference();
            this.error = new AtomicThrowable();
        }

        void subscribe(ae<?>[] others, int n2) {
            WithLatestInnerObserver[] observers = this.observers;
            AtomicReference<b> upstream = this.upstream;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (DisposableHelper.isDisposed(upstream.get()) || this.done) {
                    return;
                }
                others[i2].subscribe(observers[i2]);
            }
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this.upstream, d2);
        }

        @Override
        public void onNext(T t2) {
            R v2;
            if (this.done) {
                return;
            }
            AtomicReferenceArray<Object> ara = this.values;
            int n2 = ara.length();
            Object[] objects = new Object[n2 + 1];
            objects[0] = t2;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object o2 = ara.get(i2);
                if (o2 == null) {
                    return;
                }
                objects[i2 + 1] = o2;
            }
            try {
                v2 = Objects.requireNonNull(this.combiner.apply((Object[])objects), "combiner returned a null value");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.dispose();
                this.onError(ex);
                return;
            }
            g.a(this.downstream, v2, (AtomicInteger)this, this.error);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
                return;
            }
            this.done = true;
            this.cancelAllBut(-1);
            g.a(this.downstream, t2, (AtomicInteger)this, this.error);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.cancelAllBut(-1);
                g.a(this.downstream, (AtomicInteger)this, this.error);
            }
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.upstream.get());
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.upstream);
            for (WithLatestInnerObserver observer : this.observers) {
                observer.dispose();
            }
        }

        void innerNext(int index, Object o2) {
            this.values.set(index, o2);
        }

        void innerError(int index, Throwable t2) {
            this.done = true;
            DisposableHelper.dispose(this.upstream);
            this.cancelAllBut(index);
            g.a(this.downstream, t2, (AtomicInteger)this, this.error);
        }

        void innerComplete(int index, boolean nonEmpty) {
            if (!nonEmpty) {
                this.done = true;
                this.cancelAllBut(index);
                g.a(this.downstream, (AtomicInteger)this, this.error);
            }
        }

        void cancelAllBut(int index) {
            WithLatestInnerObserver[] observers = this.observers;
            for (int i2 = 0; i2 < observers.length; ++i2) {
                if (i2 == index) continue;
                observers[i2].dispose();
            }
        }
    }
}

