/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ae;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.operators.h;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableZip<T, R>
extends z<R> {
    final ae<? extends T>[] arD;
    final Iterable<? extends ae<? extends T>> arE;
    final io.reactivex.rxjava3.b.h<? super Object[], ? extends R> arF;
    final int arG;
    final boolean arH;

    public ObservableZip(ae<? extends T>[] sources, Iterable<? extends ae<? extends T>> sourcesIterable, io.reactivex.rxjava3.b.h<? super Object[], ? extends R> zipper, int bufferSize, boolean delayError) {
        this.arD = sources;
        this.arE = sourcesIterable;
        this.arF = zipper;
        this.arG = bufferSize;
        this.arH = delayError;
    }

    @Override
    public void d(ag<? super R> observer) {
        ae<? extends T>[] sources = this.arD;
        int count = 0;
        if (sources == null) {
            sources = new ae[8];
            for (ae<? extends T> ae2 : this.arE) {
                if (count == sources.length) {
                    ae[] b2 = new ae[count + (count >> 2)];
                    System.arraycopy(sources, 0, b2, 0, count);
                    sources = b2;
                }
                sources[count++] = ae2;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptyDisposable.complete(observer);
            return;
        }
        ZipCoordinator<? extends T, R> zc = new ZipCoordinator<T, R>(observer, this.arF, count, this.arH);
        zc.subscribe(sources, this.arG);
    }

    static final class a<T, R>
    implements ag<T> {
        final ZipCoordinator<T, R> arI;
        final h<T> arJ;
        volatile boolean done;
        Throwable error;
        final AtomicReference<b> arK = new AtomicReference();

        a(ZipCoordinator<T, R> parent, int bufferSize) {
            this.arI = parent;
            this.arJ = new h(bufferSize);
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this.arK, d2);
        }

        @Override
        public void onNext(T t2) {
            this.arJ.offer(t2);
            this.arI.drain();
        }

        @Override
        public void onError(Throwable t2) {
            this.error = t2;
            this.done = true;
            this.arI.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.arI.drain();
        }

        public void dispose() {
            DisposableHelper.dispose(this.arK);
        }
    }

    static final class ZipCoordinator<T, R>
    extends AtomicInteger
    implements b {
        private static final long serialVersionUID = 2983708048395377667L;
        final ag<? super R> downstream;
        final io.reactivex.rxjava3.b.h<? super Object[], ? extends R> zipper;
        final a<T, R>[] observers;
        final T[] row;
        final boolean delayError;
        volatile boolean cancelled;

        ZipCoordinator(ag<? super R> actual, io.reactivex.rxjava3.b.h<? super Object[], ? extends R> zipper, int count, boolean delayError) {
            this.downstream = actual;
            this.zipper = zipper;
            this.observers = new a[count];
            this.row = new Object[count];
            this.delayError = delayError;
        }

        public void subscribe(ae<? extends T>[] sources, int bufferSize) {
            int i2;
            a<T, R>[] s2 = this.observers;
            int len = s2.length;
            for (i2 = 0; i2 < len; ++i2) {
                s2[i2] = new a(this, bufferSize);
            }
            this.lazySet(0);
            this.downstream.onSubscribe(this);
            for (i2 = 0; i2 < len; ++i2) {
                if (this.cancelled) {
                    return;
                }
                sources[i2].subscribe(s2[i2]);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelSources();
                if (this.getAndIncrement() == 0) {
                    this.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void cancel() {
            this.clear();
            this.cancelSources();
        }

        void cancelSources() {
            for (a<T, R> zs : this.observers) {
                zs.dispose();
            }
        }

        void clear() {
            for (a<T, R> zs : this.observers) {
                zs.arJ.clear();
            }
        }

        public void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missing = 1;
            a<T, R>[] zs = this.observers;
            ag<R> a2 = this.downstream;
            Object[] os = this.row;
            boolean delayError = this.delayError;
            while (true) {
                int i2 = 0;
                int emptyCount = 0;
                for (a<T, R> z2 : zs) {
                    Throwable ex;
                    if (os[i2] == null) {
                        boolean empty;
                        boolean d2 = z2.done;
                        Object v2 = z2.arJ.poll();
                        boolean bl2 = empty = v2 == null;
                        if (this.checkTerminated(d2, empty, a2, delayError, z2)) {
                            return;
                        }
                        if (!empty) {
                            os[i2] = v2;
                        } else {
                            ++emptyCount;
                        }
                    } else if (z2.done && !delayError && (ex = z2.error) != null) {
                        this.cancelled = true;
                        this.cancel();
                        a2.onError(ex);
                        return;
                    }
                    ++i2;
                }
                if (emptyCount == 0) {
                    R v3;
                    try {
                        v3 = Objects.requireNonNull(this.zipper.apply((Object[])os.clone()), "The zipper returned a null value");
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        this.cancel();
                        a2.onError(ex);
                        return;
                    }
                    a2.onNext(v3);
                    Arrays.fill(os, null);
                    continue;
                }
                if ((missing = this.addAndGet(-missing)) == 0) break;
            }
        }

        boolean checkTerminated(boolean d2, boolean empty, ag<? super R> a2, boolean delayError, a<?, ?> source) {
            if (this.cancelled) {
                this.cancel();
                return true;
            }
            if (d2) {
                if (delayError) {
                    if (empty) {
                        Throwable e2 = source.error;
                        this.cancelled = true;
                        this.cancel();
                        if (e2 != null) {
                            a2.onError(e2);
                        } else {
                            a2.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e3 = source.error;
                    if (e3 != null) {
                        this.cancelled = true;
                        this.cancel();
                        a2.onError(e3);
                        return true;
                    }
                    if (empty) {
                        this.cancelled = true;
                        this.cancel();
                        a2.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

