/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.b.b;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.internal.subscribers.DeferredScalarSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.Objects;
import org.a.d;
import org.a.e;

public final class ParallelCollect<T, C>
extends io.reactivex.rxjava3.parallel.a<C> {
    final io.reactivex.rxjava3.parallel.a<? extends T> arR;
    final s<? extends C> arS;
    final b<? super C, ? super T> arT;

    public ParallelCollect(io.reactivex.rxjava3.parallel.a<? extends T> source, s<? extends C> initialCollection, b<? super C, ? super T> collector) {
        this.arR = source;
        this.arS = initialCollection;
        this.arT = collector;
    }

    @Override
    public void a(d<? super C>[] subscribers) {
        if (!this.b(subscribers = a.a(this, subscribers))) {
            return;
        }
        int n2 = subscribers.length;
        d[] parents = new d[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            C initialValue;
            try {
                initialValue = Objects.requireNonNull(this.arS.get(), "The initialSupplier returned a null value");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.a(subscribers, ex);
                return;
            }
            parents[i2] = new ParallelCollectSubscriber<T, C>(subscribers[i2], initialValue, this.arT);
        }
        this.arR.a(parents);
    }

    void a(d<?>[] subscribers, Throwable ex) {
        for (d<?> s2 : subscribers) {
            EmptySubscription.error(ex, s2);
        }
    }

    @Override
    public int pO() {
        return this.arR.pO();
    }

    static final class ParallelCollectSubscriber<T, C>
    extends DeferredScalarSubscriber<T, C> {
        private static final long serialVersionUID = -4767392946044436228L;
        final b<? super C, ? super T> collector;
        C collection;
        boolean done;

        ParallelCollectSubscriber(d<? super C> subscriber, C initialValue, b<? super C, ? super T> collector) {
            super(subscriber);
            this.collection = initialValue;
            this.collector = collector;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            try {
                this.collector.accept(this.collection, t2);
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.cancel();
                this.onError(ex);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                a.onError(t2);
                return;
            }
            this.done = true;
            this.collection = null;
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            C c2 = this.collection;
            this.collection = null;
            this.complete(c2);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
        }
    }
}

