/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.g;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import org.a.c;
import org.a.d;
import org.a.e;

public final class ParallelFromPublisher<T>
extends io.reactivex.rxjava3.parallel.a<T> {
    final c<? extends T> asE;
    final int asF;
    final int asG;

    public ParallelFromPublisher(c<? extends T> source, int parallelism, int prefetch) {
        this.asE = source;
        this.asF = parallelism;
        this.asG = prefetch;
    }

    @Override
    public int pO() {
        return this.asF;
    }

    @Override
    public void a(d<? super T>[] subscribers) {
        if (!this.b(subscribers = a.a(this, subscribers))) {
            return;
        }
        this.asE.subscribe(new ParallelDispatcher<T>(subscribers, this.asG));
    }

    static final class ParallelDispatcher<T>
    extends AtomicInteger
    implements o<T> {
        private static final long serialVersionUID = -4470634016609963609L;
        final d<? super T>[] subscribers;
        final AtomicLongArray requests;
        final long[] emissions;
        final int prefetch;
        final int limit;
        e upstream;
        g<T> queue;
        Throwable error;
        volatile boolean done;
        int index;
        volatile boolean cancelled;
        final AtomicInteger subscriberCount = new AtomicInteger();
        int produced;
        int sourceMode;

        ParallelDispatcher(d<? super T>[] subscribers, int prefetch) {
            this.subscribers = subscribers;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            int m2 = subscribers.length;
            this.requests = new AtomicLongArray(m2 + m2 + 1);
            this.requests.lazySet(m2 + m2, m2);
            this.emissions = new long[m2];
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                if (s2 instanceof io.reactivex.rxjava3.operators.d) {
                    io.reactivex.rxjava3.operators.d qs = (io.reactivex.rxjava3.operators.d)s2;
                    int m2 = qs.requestFusion(7);
                    if (m2 == 1) {
                        this.sourceMode = m2;
                        this.queue = qs;
                        this.done = true;
                        this.setupSubscribers();
                        this.drain();
                        return;
                    }
                    if (m2 == 2) {
                        this.sourceMode = m2;
                        this.queue = qs;
                        this.setupSubscribers();
                        s2.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.setupSubscribers();
                s2.request(this.prefetch);
            }
        }

        void setupSubscribers() {
            d<? super T>[] subs = this.subscribers;
            int m2 = subs.length;
            for (int i2 = 0; i2 < m2; ++i2) {
                this.subscriberCount.lazySet(i2 + 1);
                subs[i2].onSubscribe(new a(i2, m2));
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.sourceMode == 0 && !this.queue.offer(t2)) {
                this.upstream.cancel();
                this.onError(new QueueOverflowException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t2) {
            this.error = t2;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void cancel(int m2) {
            if (this.requests.decrementAndGet(m2) == 0L) {
                this.cancelled = true;
                this.upstream.cancel();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        void drainAsync() {
            int missed = 1;
            g<T> q2 = this.queue;
            d<? super T>[] a2 = this.subscribers;
            AtomicLongArray r2 = this.requests;
            long[] e2 = this.emissions;
            int n2 = e2.length;
            int idx = this.index;
            int consumed = this.produced;
            while (true) {
                int w2;
                int notReady = 0;
                do {
                    long emissionAtIndex;
                    Throwable ex;
                    if (this.cancelled) {
                        q2.clear();
                        return;
                    }
                    boolean d2 = this.done;
                    if (d2 && (ex = this.error) != null) {
                        q2.clear();
                        for (d<T> d3 : a2) {
                            d3.onError(ex);
                        }
                        return;
                    }
                    boolean empty = q2.isEmpty();
                    if (d2 && empty) {
                        for (d<T> d4 : a2) {
                            d4.onComplete();
                        }
                        return;
                    }
                    if (empty) break;
                    long requestAtIndex = r2.get(idx);
                    if (requestAtIndex != (emissionAtIndex = e2[idx]) && r2.get(n2 + idx) == 0L) {
                        void v2;
                        try {
                            T v22 = q2.poll();
                        }
                        catch (Throwable ex2) {
                            io.reactivex.rxjava3.exceptions.a.k(ex2);
                            this.upstream.cancel();
                            for (d<T> d5 : a2) {
                                d5.onError(ex2);
                            }
                            return;
                        }
                        if (v2 == null) break;
                        a2[idx].onNext(v2);
                        e2[idx] = emissionAtIndex + 1L;
                        int c2 = ++consumed;
                        if (c2 == this.limit) {
                            consumed = 0;
                            this.upstream.request(c2);
                        }
                        notReady = 0;
                    } else {
                        ++notReady;
                    }
                    if (++idx != n2) continue;
                    idx = 0;
                } while (notReady != n2);
                if ((w2 = this.get()) == missed) {
                    this.index = idx;
                    this.produced = consumed;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w2;
            }
        }

        /*
         * WARNING - void declaration
         */
        void drainSync() {
            int missed = 1;
            g<T> q2 = this.queue;
            d<? super T>[] a2 = this.subscribers;
            AtomicLongArray r2 = this.requests;
            long[] e2 = this.emissions;
            int n2 = e2.length;
            int idx = this.index;
            while (true) {
                int notReady = 0;
                do {
                    long emissionAtIndex;
                    if (this.cancelled) {
                        q2.clear();
                        return;
                    }
                    boolean empty = q2.isEmpty();
                    if (empty) {
                        for (d<T> d2 : a2) {
                            d2.onComplete();
                        }
                        return;
                    }
                    long requestAtIndex = r2.get(idx);
                    if (requestAtIndex != (emissionAtIndex = e2[idx]) && r2.get(n2 + idx) == 0L) {
                        void v2;
                        try {
                            T v22 = q2.poll();
                        }
                        catch (Throwable ex) {
                            void var18_24;
                            io.reactivex.rxjava3.exceptions.a.k(ex);
                            this.upstream.cancel();
                            d<? super T>[] dArray = a2;
                            int n3 = dArray.length;
                            boolean bl2 = false;
                            while (var18_24 < n3) {
                                d<T> d3 = dArray[var18_24];
                                d3.onError(ex);
                                ++var18_24;
                            }
                            return;
                        }
                        if (v2 == null) {
                            for (d<T> d4 : a2) {
                                d4.onComplete();
                            }
                            return;
                        }
                        a2[idx].onNext(v2);
                        e2[idx] = emissionAtIndex + 1L;
                        notReady = 0;
                    } else {
                        ++notReady;
                    }
                    if (++idx != n2) continue;
                    idx = 0;
                } while (notReady != n2);
                int w2 = this.get();
                if (w2 == missed) {
                    this.index = idx;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w2;
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            if (this.sourceMode == 1) {
                this.drainSync();
            } else {
                this.drainAsync();
            }
        }

        final class a
        implements e {
            final int j;
            final int m;

            a(int j2, int m2) {
                this.j = j2;
                this.m = m2;
            }

            @Override
            public void request(long n2) {
                if (SubscriptionHelper.validate(n2)) {
                    long u2;
                    long r2;
                    AtomicLongArray ra = ParallelDispatcher.this.requests;
                    do {
                        if ((r2 = ra.get(this.j)) != Long.MAX_VALUE) continue;
                        return;
                    } while (!ra.compareAndSet(this.j, r2, u2 = b.g(r2, n2)));
                    if (ParallelDispatcher.this.subscriberCount.get() == this.m) {
                        ParallelDispatcher.this.drain();
                    }
                }
            }

            @Override
            public void cancel() {
                if (ParallelDispatcher.this.requests.compareAndSet(this.m + this.j, 0L, 1L)) {
                    ParallelDispatcher.this.cancel(this.m + this.m);
                }
            }
        }
    }
}

