/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.f;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class ParallelJoin<T>
extends j<T> {
    final io.reactivex.rxjava3.parallel.a<? extends T> asI;
    final int asJ;
    final boolean asK;

    public ParallelJoin(io.reactivex.rxjava3.parallel.a<? extends T> source, int prefetch, boolean delayErrors) {
        this.asI = source;
        this.asJ = prefetch;
        this.asK = delayErrors;
    }

    @Override
    protected void d(d<? super T> s2) {
        JoinSubscriptionBase parent = this.asK ? new JoinSubscriptionDelayError<T>(s2, this.asI.pO(), this.asJ) : new JoinSubscription<T>(s2, this.asI.pO(), this.asJ);
        s2.onSubscribe(parent);
        this.asI.a(parent.subscribers);
    }

    static final class JoinInnerSubscriber<T>
    extends AtomicReference<e>
    implements o<T> {
        private static final long serialVersionUID = 8410034718427740355L;
        final JoinSubscriptionBase<T> parent;
        final int prefetch;
        final int limit;
        long produced;
        volatile f<T> queue;

        JoinInnerSubscriber(JoinSubscriptionBase<T> parent, int prefetch) {
            this.parent = parent;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public void onSubscribe(e s2) {
            SubscriptionHelper.setOnce(this, s2, this.prefetch);
        }

        @Override
        public void onNext(T t2) {
            this.parent.onNext(this, t2);
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.onError(t2);
        }

        @Override
        public void onComplete() {
            this.parent.onComplete();
        }

        public void requestOne() {
            long p2 = this.produced + 1L;
            if (p2 == (long)this.limit) {
                this.produced = 0L;
                ((e)this.get()).request(p2);
            } else {
                this.produced = p2;
            }
        }

        public void request(long n2) {
            long p2 = this.produced + n2;
            if (p2 >= (long)this.limit) {
                this.produced = 0L;
                ((e)this.get()).request(p2);
            } else {
                this.produced = p2;
            }
        }

        public boolean cancel() {
            return SubscriptionHelper.cancel(this);
        }

        f<T> getQueue() {
            f<T> q2 = this.queue;
            if (q2 == null) {
                this.queue = q2 = new SpscArrayQueue<T>(this.prefetch);
            }
            return q2;
        }
    }

    static final class JoinSubscriptionDelayError<T>
    extends JoinSubscriptionBase<T> {
        private static final long serialVersionUID = -5737965195918321883L;

        JoinSubscriptionDelayError(d<? super T> actual, int n2, int prefetch) {
            super(actual, n2, prefetch);
        }

        @Override
        void onNext(JoinInnerSubscriber<T> inner, T value) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                if (this.requested.get() != 0L) {
                    this.downstream.onNext(value);
                    if (this.requested.get() != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    inner.request(1L);
                } else {
                    f<T> q2 = inner.getQueue();
                    if (!q2.offer(value)) {
                        inner.cancel();
                        this.errors.tryAddThrowableOrReport(new QueueOverflowException());
                        this.done.decrementAndGet();
                        this.drainLoop();
                        return;
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                f<T> q3 = inner.getQueue();
                if (!q3.offer(value)) {
                    inner.cancel();
                    this.errors.tryAddThrowableOrReport(new QueueOverflowException());
                    this.done.decrementAndGet();
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        void onError(Throwable e2) {
            if (this.errors.tryAddThrowableOrReport(e2)) {
                this.done.decrementAndGet();
                this.drain();
            }
        }

        @Override
        void onComplete() {
            this.done.decrementAndGet();
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            this.drainLoop();
        }

        void drainLoop() {
            int missed = 1;
            JoinInnerSubscriber[] s2 = this.subscribers;
            int n2 = s2.length;
            d a2 = this.downstream;
            do {
                f q2;
                JoinInnerSubscriber inner;
                int i2;
                boolean empty;
                boolean d2;
                long r2 = this.requested.get();
                long e2 = 0L;
                block1: while (e2 != r2) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    d2 = this.done.get() == 0;
                    empty = true;
                    for (i2 = 0; i2 < n2; ++i2) {
                        Object v2;
                        inner = s2[i2];
                        q2 = inner.queue;
                        if (q2 == null || (v2 = q2.poll()) == null) continue;
                        empty = false;
                        a2.onNext(v2);
                        inner.requestOne();
                        if (++e2 == r2) break block1;
                    }
                    if (d2 && empty) {
                        this.errors.tryTerminateConsumer(a2);
                        return;
                    }
                    if (!empty) continue;
                    break;
                }
                if (e2 == r2) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    d2 = this.done.get() == 0;
                    empty = true;
                    for (i2 = 0; i2 < n2; ++i2) {
                        inner = s2[i2];
                        q2 = inner.queue;
                        if (q2 == null || q2.isEmpty()) continue;
                        empty = false;
                        break;
                    }
                    if (d2 && empty) {
                        this.errors.tryTerminateConsumer(a2);
                        return;
                    }
                }
                if (e2 == 0L) continue;
                b.c(this.requested, e2);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }

    static final class JoinSubscription<T>
    extends JoinSubscriptionBase<T> {
        private static final long serialVersionUID = 6312374661811000451L;

        JoinSubscription(d<? super T> actual, int n2, int prefetch) {
            super(actual, n2, prefetch);
        }

        @Override
        public void onNext(JoinInnerSubscriber<T> inner, T value) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                if (this.requested.get() != 0L) {
                    this.downstream.onNext(value);
                    if (this.requested.get() != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    inner.request(1L);
                } else {
                    f<T> q2 = inner.getQueue();
                    if (!q2.offer(value)) {
                        this.cancelAll();
                        QueueOverflowException mbe = new QueueOverflowException();
                        if (this.errors.compareAndSet(null, mbe)) {
                            this.downstream.onError(mbe);
                        } else {
                            a.onError(mbe);
                        }
                        return;
                    }
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                f<T> q3 = inner.getQueue();
                if (!q3.offer(value)) {
                    this.cancelAll();
                    this.onError(new QueueOverflowException());
                    return;
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable e2) {
            if (this.errors.compareAndSet(null, e2)) {
                this.cancelAll();
                this.drain();
            } else if (e2 != this.errors.get()) {
                a.onError(e2);
            }
        }

        @Override
        public void onComplete() {
            this.done.decrementAndGet();
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            this.drainLoop();
        }

        void drainLoop() {
            int missed = 1;
            JoinInnerSubscriber[] s2 = this.subscribers;
            int n2 = s2.length;
            d a2 = this.downstream;
            do {
                f q2;
                JoinInnerSubscriber inner;
                int i2;
                boolean empty;
                boolean d2;
                Throwable ex;
                long r2 = this.requested.get();
                long e2 = 0L;
                block1: while (e2 != r2) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    ex = (Throwable)this.errors.get();
                    if (ex != null) {
                        this.cleanup();
                        a2.onError(ex);
                        return;
                    }
                    d2 = this.done.get() == 0;
                    empty = true;
                    for (i2 = 0; i2 < s2.length; ++i2) {
                        Object v2;
                        inner = s2[i2];
                        q2 = inner.queue;
                        if (q2 == null || (v2 = q2.poll()) == null) continue;
                        empty = false;
                        a2.onNext(v2);
                        inner.requestOne();
                        if (++e2 == r2) break block1;
                    }
                    if (d2 && empty) {
                        a2.onComplete();
                        return;
                    }
                    if (!empty) continue;
                    break;
                }
                if (e2 == r2) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    ex = (Throwable)this.errors.get();
                    if (ex != null) {
                        this.cleanup();
                        a2.onError(ex);
                        return;
                    }
                    d2 = this.done.get() == 0;
                    empty = true;
                    for (i2 = 0; i2 < n2; ++i2) {
                        inner = s2[i2];
                        q2 = inner.queue;
                        if (q2 == null || q2.isEmpty()) continue;
                        empty = false;
                        break;
                    }
                    if (d2 && empty) {
                        a2.onComplete();
                        return;
                    }
                }
                if (e2 == 0L) continue;
                b.c(this.requested, e2);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }

    static abstract class JoinSubscriptionBase<T>
    extends AtomicInteger
    implements e {
        private static final long serialVersionUID = 3100232009247827843L;
        final d<? super T> downstream;
        final JoinInnerSubscriber<T>[] subscribers;
        final AtomicThrowable errors = new AtomicThrowable();
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        final AtomicInteger done = new AtomicInteger();

        JoinSubscriptionBase(d<? super T> actual, int n2, int prefetch) {
            this.downstream = actual;
            JoinInnerSubscriber[] a2 = new JoinInnerSubscriber[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                a2[i2] = new JoinInnerSubscriber(this, prefetch);
            }
            this.subscribers = a2;
            this.done.lazySet(n2);
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
                if (this.getAndIncrement() == 0) {
                    this.cleanup();
                }
            }
        }

        void cancelAll() {
            for (JoinInnerSubscriber<T> s2 : this.subscribers) {
                s2.cancel();
            }
        }

        void cleanup() {
            for (JoinInnerSubscriber<T> s2 : this.subscribers) {
                s2.queue = null;
            }
        }

        abstract void onNext(JoinInnerSubscriber<T> var1, T var2);

        abstract void onError(Throwable var1);

        abstract void onComplete();

        abstract void drain();
    }
}

