/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.b.c;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.internal.subscribers.DeferredScalarSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.Objects;
import org.a.d;
import org.a.e;

public final class ParallelReduce<T, R>
extends io.reactivex.rxjava3.parallel.a<R> {
    final io.reactivex.rxjava3.parallel.a<? extends T> atm;
    final s<R> atn;
    final c<R, ? super T, R> ato;

    public ParallelReduce(io.reactivex.rxjava3.parallel.a<? extends T> source, s<R> initialSupplier, c<R, ? super T, R> reducer) {
        this.atm = source;
        this.atn = initialSupplier;
        this.ato = reducer;
    }

    @Override
    public void a(d<? super R>[] subscribers) {
        if (!this.b(subscribers = a.a(this, subscribers))) {
            return;
        }
        int n2 = subscribers.length;
        d[] parents = new d[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            R initialValue;
            try {
                initialValue = Objects.requireNonNull(this.atn.get(), "The initialSupplier returned a null value");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.a(subscribers, ex);
                return;
            }
            parents[i2] = new ParallelReduceSubscriber<T, R>(subscribers[i2], initialValue, this.ato);
        }
        this.atm.a(parents);
    }

    void a(d<?>[] subscribers, Throwable ex) {
        for (d<?> s2 : subscribers) {
            EmptySubscription.error(ex, s2);
        }
    }

    @Override
    public int pO() {
        return this.atm.pO();
    }

    static final class ParallelReduceSubscriber<T, R>
    extends DeferredScalarSubscriber<T, R> {
        private static final long serialVersionUID = 8200530050639449080L;
        final c<R, ? super T, R> reducer;
        R accumulator;
        boolean done;

        ParallelReduceSubscriber(d<? super R> subscriber, R initialValue, c<R, ? super T, R> reducer) {
            super(subscriber);
            this.accumulator = initialValue;
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t2) {
            if (!this.done) {
                R v2;
                try {
                    v2 = Objects.requireNonNull(this.reducer.apply(this.accumulator, t2), "The reducer returned a null value");
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    this.cancel();
                    this.onError(ex);
                    return;
                }
                this.accumulator = v2;
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                a.onError(t2);
                return;
            }
            this.done = true;
            this.accumulator = null;
            this.downstream.onError(t2);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                R a2 = this.accumulator;
                this.accumulator = null;
                this.complete(a2);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
        }
    }
}

