/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.b.c;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class ParallelReduceFull<T>
extends j<T> {
    final io.reactivex.rxjava3.parallel.a<? extends T> atp;
    final c<T, T, T> atq;

    public ParallelReduceFull(io.reactivex.rxjava3.parallel.a<? extends T> source, c<T, T, T> reducer) {
        this.atp = source;
        this.atq = reducer;
    }

    @Override
    protected void d(d<? super T> s2) {
        ParallelReduceFullMainSubscriber<? super T> parent = new ParallelReduceFullMainSubscriber<T>(s2, this.atp.pO(), this.atq);
        s2.onSubscribe(parent);
        this.atp.a(parent.subscribers);
    }

    static final class SlotPair<T>
    extends AtomicInteger {
        private static final long serialVersionUID = 473971317683868662L;
        T first;
        T second;
        final AtomicInteger releaseIndex = new AtomicInteger();

        SlotPair() {
        }

        int tryAcquireSlot() {
            int acquired;
            do {
                if ((acquired = this.get()) < 2) continue;
                return -1;
            } while (!this.compareAndSet(acquired, acquired + 1));
            return acquired;
        }

        boolean releaseSlot() {
            return this.releaseIndex.incrementAndGet() == 2;
        }
    }

    static final class ParallelReduceFullInnerSubscriber<T>
    extends AtomicReference<e>
    implements o<T> {
        private static final long serialVersionUID = -7954444275102466525L;
        final ParallelReduceFullMainSubscriber<T> parent;
        final c<T, T, T> reducer;
        T value;
        boolean done;

        ParallelReduceFullInnerSubscriber(ParallelReduceFullMainSubscriber<T> parent, c<T, T, T> reducer) {
            this.parent = parent;
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(e s2) {
            SubscriptionHelper.setOnce(this, s2, Long.MAX_VALUE);
        }

        @Override
        public void onNext(T t2) {
            if (!this.done) {
                T v2 = this.value;
                if (v2 == null) {
                    this.value = t2;
                } else {
                    try {
                        v2 = Objects.requireNonNull(this.reducer.apply(v2, t2), "The reducer returned a null value");
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        ((e)this.get()).cancel();
                        this.onError(ex);
                        return;
                    }
                    this.value = v2;
                }
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                a.onError(t2);
                return;
            }
            this.done = true;
            this.parent.innerError(t2);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.parent.innerComplete(this.value);
            }
        }

        void cancel() {
            SubscriptionHelper.cancel(this);
        }
    }

    static final class ParallelReduceFullMainSubscriber<T>
    extends DeferredScalarSubscription<T> {
        private static final long serialVersionUID = -5370107872170712765L;
        final ParallelReduceFullInnerSubscriber<T>[] subscribers;
        final c<T, T, T> reducer;
        final AtomicReference<SlotPair<T>> current = new AtomicReference();
        final AtomicInteger remaining = new AtomicInteger();
        final AtomicThrowable error = new AtomicThrowable();

        ParallelReduceFullMainSubscriber(d<? super T> subscriber, int n2, c<T, T, T> reducer) {
            super(subscriber);
            ParallelReduceFullInnerSubscriber[] a2 = new ParallelReduceFullInnerSubscriber[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                a2[i2] = new ParallelReduceFullInnerSubscriber<T>(this, reducer);
            }
            this.subscribers = a2;
            this.reducer = reducer;
            this.remaining.lazySet(n2);
        }

        SlotPair<T> addValue(T value) {
            int c2;
            SlotPair<T> curr;
            while (true) {
                if ((curr = this.current.get()) == null && !this.current.compareAndSet(null, curr = new SlotPair())) {
                    continue;
                }
                c2 = curr.tryAcquireSlot();
                if (c2 >= 0) break;
                this.current.compareAndSet(curr, null);
            }
            if (c2 == 0) {
                curr.first = value;
            } else {
                curr.second = value;
            }
            if (curr.releaseSlot()) {
                this.current.compareAndSet(curr, null);
                return curr;
            }
            return null;
        }

        @Override
        public void cancel() {
            for (ParallelReduceFullInnerSubscriber<T> inner : this.subscribers) {
                inner.cancel();
            }
        }

        void innerError(Throwable ex) {
            if (this.error.compareAndSet(null, ex)) {
                this.cancel();
                this.downstream.onError(ex);
            } else if (ex != this.error.get()) {
                a.onError(ex);
            }
        }

        void innerComplete(T value) {
            SlotPair<T> sp;
            if (value != null) {
                while ((sp = this.addValue(value)) != null) {
                    try {
                        value = Objects.requireNonNull(this.reducer.apply(sp.first, sp.second), "The reducer returned a null value");
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        this.innerError(ex);
                        return;
                    }
                }
            }
            if (this.remaining.decrementAndGet() == 0) {
                sp = this.current.get();
                this.current.lazySet(null);
                if (sp != null) {
                    this.complete(sp.first);
                } else {
                    this.downstream.onComplete();
                }
            }
        }
    }
}

