/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.schedulers.i;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.a.d;
import org.a.e;

public final class ParallelRunOn<T>
extends io.reactivex.rxjava3.parallel.a<T> {
    final io.reactivex.rxjava3.parallel.a<? extends T> atr;
    final ah ats;
    final int att;

    public ParallelRunOn(io.reactivex.rxjava3.parallel.a<? extends T> parent, ah scheduler, int prefetch) {
        this.atr = parent;
        this.ats = scheduler;
        this.att = prefetch;
    }

    @Override
    public void a(d<? super T>[] subscribers) {
        if (!this.b(subscribers = io.reactivex.rxjava3.d.a.a(this, subscribers))) {
            return;
        }
        int n2 = subscribers.length;
        d[] parents = new d[n2];
        if (this.ats instanceof i) {
            i multiworker = (i)((Object)this.ats);
            multiworker.a(n2, new a(subscribers, parents));
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.a(i2, subscribers, parents, this.ats.oS());
            }
        }
        this.atr.a(parents);
    }

    void a(int i2, d<? super T>[] subscribers, d<T>[] parents, ah.c worker) {
        d<? super T> a2 = subscribers[i2];
        SpscArrayQueue q2 = new SpscArrayQueue(this.att);
        parents[i2] = a2 instanceof io.reactivex.rxjava3.operators.a ? new RunOnConditionalSubscriber((io.reactivex.rxjava3.operators.a)a2, this.att, q2, worker) : new RunOnSubscriber<T>(a2, this.att, q2, worker);
    }

    @Override
    public int pO() {
        return this.atr.pO();
    }

    static final class RunOnConditionalSubscriber<T>
    extends BaseRunOnSubscriber<T> {
        private static final long serialVersionUID = 1075119423897941642L;
        final io.reactivex.rxjava3.operators.a<? super T> downstream;

        RunOnConditionalSubscriber(io.reactivex.rxjava3.operators.a<? super T> actual, int prefetch, SpscArrayQueue<T> queue, ah.c worker) {
            super(prefetch, queue, worker);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(this.prefetch);
            }
        }

        @Override
        public void run() {
            int missed = 1;
            int c2 = this.consumed;
            SpscArrayQueue q2 = this.queue;
            io.reactivex.rxjava3.operators.a a2 = this.downstream;
            int lim = this.limit;
            do {
                long r2 = this.requested.get();
                long e2 = 0L;
                while (e2 != r2) {
                    int p2;
                    boolean empty;
                    Throwable ex;
                    if (this.cancelled) {
                        q2.clear();
                        return;
                    }
                    boolean d2 = this.done;
                    if (d2 && (ex = this.error) != null) {
                        q2.clear();
                        a2.onError(ex);
                        this.worker.dispose();
                        return;
                    }
                    Object v2 = q2.poll();
                    boolean bl2 = empty = v2 == null;
                    if (d2 && empty) {
                        a2.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    if (empty) break;
                    if (a2.tryOnNext(v2)) {
                        ++e2;
                    }
                    if ((p2 = ++c2) != lim) continue;
                    c2 = 0;
                    this.upstream.request(p2);
                }
                if (e2 == r2) {
                    if (this.cancelled) {
                        q2.clear();
                        return;
                    }
                    if (this.done) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            q2.clear();
                            a2.onError(ex);
                            this.worker.dispose();
                            return;
                        }
                        if (q2.isEmpty()) {
                            a2.onComplete();
                            this.worker.dispose();
                            return;
                        }
                    }
                }
                if (e2 != 0L) {
                    b.c(this.requested, e2);
                }
                this.consumed = c2;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }

    static final class RunOnSubscriber<T>
    extends BaseRunOnSubscriber<T> {
        private static final long serialVersionUID = 1075119423897941642L;
        final d<? super T> downstream;

        RunOnSubscriber(d<? super T> actual, int prefetch, SpscArrayQueue<T> queue, ah.c worker) {
            super(prefetch, queue, worker);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(e s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(this.prefetch);
            }
        }

        @Override
        public void run() {
            int missed = 1;
            int c2 = this.consumed;
            SpscArrayQueue q2 = this.queue;
            d a2 = this.downstream;
            int lim = this.limit;
            while (true) {
                int w2;
                long e2;
                long r2 = this.requested.get();
                for (e2 = 0L; e2 != r2; ++e2) {
                    int p2;
                    boolean empty;
                    Throwable ex;
                    if (this.cancelled) {
                        q2.clear();
                        return;
                    }
                    boolean d2 = this.done;
                    if (d2 && (ex = this.error) != null) {
                        q2.clear();
                        a2.onError(ex);
                        this.worker.dispose();
                        return;
                    }
                    Object v2 = q2.poll();
                    boolean bl2 = empty = v2 == null;
                    if (d2 && empty) {
                        a2.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    if (empty) break;
                    a2.onNext(v2);
                    if ((p2 = ++c2) != lim) continue;
                    c2 = 0;
                    this.upstream.request(p2);
                }
                if (e2 == r2) {
                    if (this.cancelled) {
                        q2.clear();
                        return;
                    }
                    if (this.done) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            q2.clear();
                            a2.onError(ex);
                            this.worker.dispose();
                            return;
                        }
                        if (q2.isEmpty()) {
                            a2.onComplete();
                            this.worker.dispose();
                            return;
                        }
                    }
                }
                if (e2 != 0L && r2 != Long.MAX_VALUE) {
                    this.requested.addAndGet(-e2);
                }
                if ((w2 = this.get()) == missed) {
                    this.consumed = c2;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w2;
            }
        }
    }

    static abstract class BaseRunOnSubscriber<T>
    extends AtomicInteger
    implements o<T>,
    Runnable,
    e {
        private static final long serialVersionUID = 9222303586456402150L;
        final int prefetch;
        final int limit;
        final SpscArrayQueue<T> queue;
        final ah.c worker;
        e upstream;
        volatile boolean done;
        Throwable error;
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        int consumed;

        BaseRunOnSubscriber(int prefetch, SpscArrayQueue<T> queue, ah.c worker) {
            this.prefetch = prefetch;
            this.queue = queue;
            this.limit = prefetch - (prefetch >> 2);
            this.worker = worker;
        }

        @Override
        public final void onNext(T t2) {
            if (this.done) {
                return;
            }
            if (!this.queue.offer(t2)) {
                this.upstream.cancel();
                this.onError(new QueueOverflowException());
                return;
            }
            this.schedule();
        }

        @Override
        public final void onError(Throwable t2) {
            if (this.done) {
                io.reactivex.rxjava3.d.a.onError(t2);
                return;
            }
            this.error = t2;
            this.done = true;
            this.schedule();
        }

        @Override
        public final void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.schedule();
        }

        @Override
        public final void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
                this.schedule();
            }
        }

        @Override
        public final void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                this.worker.dispose();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        final void schedule() {
            if (this.getAndIncrement() == 0) {
                this.worker.f(this);
            }
        }
    }

    final class a
    implements i.a {
        final d<? super T>[] atu;
        final d<T>[] atv;

        a(d<? super T>[] subscribers, d<T>[] parents) {
            this.atu = subscribers;
            this.atv = parents;
        }

        @Override
        public void a(int i2, ah.c w2) {
            ParallelRunOn.this.a(i2, this.atu, this.atv, w2);
        }
    }
}

