/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.b;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.d;
import org.a.e;

public final class ParallelSortedJoin<T>
extends j<T> {
    final io.reactivex.rxjava3.parallel.a<List<T>> atx;
    final Comparator<? super T> aty;

    public ParallelSortedJoin(io.reactivex.rxjava3.parallel.a<List<T>> source, Comparator<? super T> comparator) {
        this.atx = source;
        this.aty = comparator;
    }

    @Override
    protected void d(d<? super T> s2) {
        SortedJoinSubscription<? super T> parent = new SortedJoinSubscription<T>(s2, this.atx.pO(), this.aty);
        s2.onSubscribe(parent);
        this.atx.a(parent.subscribers);
    }

    static final class SortedJoinInnerSubscriber<T>
    extends AtomicReference<e>
    implements o<List<T>> {
        private static final long serialVersionUID = 6751017204873808094L;
        final SortedJoinSubscription<T> parent;
        final int index;

        SortedJoinInnerSubscriber(SortedJoinSubscription<T> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(e s2) {
            SubscriptionHelper.setOnce(this, s2, Long.MAX_VALUE);
        }

        @Override
        public void onNext(List<T> t2) {
            this.parent.innerNext(t2, this.index);
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.innerError(t2);
        }

        @Override
        public void onComplete() {
        }

        void cancel() {
            SubscriptionHelper.cancel(this);
        }
    }

    static final class SortedJoinSubscription<T>
    extends AtomicInteger
    implements e {
        private static final long serialVersionUID = 3481980673745556697L;
        final d<? super T> downstream;
        final SortedJoinInnerSubscriber<T>[] subscribers;
        final List<T>[] lists;
        final int[] indexes;
        final Comparator<? super T> comparator;
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        final AtomicInteger remaining = new AtomicInteger();
        final AtomicReference<Throwable> error = new AtomicReference();

        SortedJoinSubscription(d<? super T> actual, int n2, Comparator<? super T> comparator) {
            this.downstream = actual;
            this.comparator = comparator;
            SortedJoinInnerSubscriber[] s2 = new SortedJoinInnerSubscriber[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                s2[i2] = new SortedJoinInnerSubscriber(this, i2);
            }
            this.subscribers = s2;
            this.lists = new List[n2];
            this.indexes = new int[n2];
            this.remaining.lazySet(n2);
        }

        @Override
        public void request(long n2) {
            if (SubscriptionHelper.validate(n2)) {
                b.a(this.requested, n2);
                if (this.remaining.get() == 0) {
                    this.drain();
                }
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
                if (this.getAndIncrement() == 0) {
                    Arrays.fill(this.lists, null);
                }
            }
        }

        void cancelAll() {
            for (SortedJoinInnerSubscriber<T> s2 : this.subscribers) {
                s2.cancel();
            }
        }

        void innerNext(List<T> value, int index) {
            this.lists[index] = value;
            if (this.remaining.decrementAndGet() == 0) {
                this.drain();
            }
        }

        void innerError(Throwable e2) {
            if (this.error.compareAndSet(null, e2)) {
                this.drain();
            } else if (e2 != this.error.get()) {
                a.onError(e2);
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            d<T> a2 = this.downstream;
            Object[] lists = this.lists;
            int[] indexes = this.indexes;
            int n2 = indexes.length;
            do {
                Throwable ex;
                long e2;
                long r2 = this.requested.get();
                for (e2 = 0L; e2 != r2; ++e2) {
                    if (this.cancelled) {
                        Arrays.fill(lists, null);
                        return;
                    }
                    ex = this.error.get();
                    if (ex != null) {
                        this.cancelAll();
                        Arrays.fill(lists, null);
                        a2.onError(ex);
                        return;
                    }
                    Object min = null;
                    int minIndex = -1;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        boolean smaller;
                        Object list = lists[i2];
                        int index = indexes[i2];
                        if (list.size() == index) continue;
                        if (min == null) {
                            min = list.get(index);
                            minIndex = i2;
                            continue;
                        }
                        Object b2 = list.get(index);
                        try {
                            smaller = this.comparator.compare(min, b2) > 0;
                        }
                        catch (Throwable exc) {
                            io.reactivex.rxjava3.exceptions.a.k(exc);
                            this.cancelAll();
                            Arrays.fill(lists, null);
                            if (!this.error.compareAndSet(null, exc)) {
                                a.onError(exc);
                            }
                            a2.onError(this.error.get());
                            return;
                        }
                        if (!smaller) continue;
                        min = b2;
                        minIndex = i2;
                    }
                    if (min == null) {
                        Arrays.fill(lists, null);
                        a2.onComplete();
                        return;
                    }
                    a2.onNext(min);
                    int n3 = minIndex;
                    indexes[n3] = indexes[n3] + 1;
                }
                if (this.cancelled) {
                    Arrays.fill(lists, null);
                    return;
                }
                ex = this.error.get();
                if (ex != null) {
                    this.cancelAll();
                    Arrays.fill(lists, null);
                    a2.onError(ex);
                    return;
                }
                boolean empty = true;
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (indexes[i3] == lists[i3].size()) continue;
                    empty = false;
                    break;
                }
                if (empty) {
                    Arrays.fill(lists, null);
                    a2.onComplete();
                    return;
                }
                if (e2 == 0L) continue;
                b.c(this.requested, e2);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

