/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ai;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleFlatMap<T, R>
extends ai<R> {
    final ao<? extends T> avj;
    final h<? super T, ? extends ao<? extends R>> avk;

    public SingleFlatMap(ao<? extends T> source, h<? super T, ? extends ao<? extends R>> mapper) {
        this.avk = mapper;
        this.avj = source;
    }

    @Override
    protected void d(al<? super R> downstream) {
        this.avj.c(new SingleFlatMapCallback<T, R>(downstream, this.avk));
    }

    static final class SingleFlatMapCallback<T, R>
    extends AtomicReference<b>
    implements al<T>,
    b {
        private static final long serialVersionUID = 3258103020495908596L;
        final al<? super R> downstream;
        final h<? super T, ? extends ao<? extends R>> mapper;

        SingleFlatMapCallback(al<? super R> actual, h<? super T, ? extends ao<? extends R>> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.setOnce(this, d2)) {
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            ao<R> o2;
            try {
                o2 = Objects.requireNonNull(this.mapper.apply(value), "The single returned by the mapper is null");
            }
            catch (Throwable e2) {
                io.reactivex.rxjava3.exceptions.a.k(e2);
                this.downstream.onError(e2);
                return;
            }
            if (!this.isDisposed()) {
                o2.c(new a<R>(this, this.downstream));
            }
        }

        @Override
        public void onError(Throwable e2) {
            this.downstream.onError(e2);
        }

        static final class a<R>
        implements al<R> {
            final AtomicReference<b> avl;
            final al<? super R> avm;

            a(AtomicReference<b> parent, al<? super R> downstream) {
                this.avl = parent;
                this.avm = downstream;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.replace(this.avl, d2);
            }

            @Override
            public void onSuccess(R value) {
                this.avm.onSuccess(value);
            }

            @Override
            public void onError(Throwable e2) {
                this.avm.onError(e2);
            }
        }
    }
}

