/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.b.c;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ai;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleFlatMapBiSelector<T, U, R>
extends ai<R> {
    final ao<T> avn;
    final h<? super T, ? extends ao<? extends U>> avo;
    final c<? super T, ? super U, ? extends R> avp;

    public SingleFlatMapBiSelector(ao<T> source, h<? super T, ? extends ao<? extends U>> mapper, c<? super T, ? super U, ? extends R> resultSelector) {
        this.avn = source;
        this.avo = mapper;
        this.avp = resultSelector;
    }

    @Override
    protected void d(al<? super R> observer) {
        this.avn.c(new FlatMapBiMainObserver<T, U, R>(observer, this.avo, this.avp));
    }

    static final class FlatMapBiMainObserver<T, U, R>
    implements al<T>,
    b {
        final h<? super T, ? extends ao<? extends U>> avq;
        final InnerObserver<T, U, R> avr;

        FlatMapBiMainObserver(al<? super R> actual, h<? super T, ? extends ao<? extends U>> mapper, c<? super T, ? super U, ? extends R> resultSelector) {
            this.avr = new InnerObserver<T, U, R>(actual, resultSelector);
            this.avq = mapper;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.avr);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.avr.get());
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.setOnce(this.avr, d2)) {
                this.avr.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            ao<U> next;
            try {
                next = Objects.requireNonNull(this.avq.apply(value), "The mapper returned a null MaybeSource");
            }
            catch (Throwable ex) {
                a.k(ex);
                this.avr.downstream.onError(ex);
                return;
            }
            if (DisposableHelper.replace(this.avr, null)) {
                this.avr.value = value;
                next.c(this.avr);
            }
        }

        @Override
        public void onError(Throwable e2) {
            this.avr.downstream.onError(e2);
        }

        static final class InnerObserver<T, U, R>
        extends AtomicReference<b>
        implements al<U> {
            private static final long serialVersionUID = -2897979525538174559L;
            final al<? super R> downstream;
            final c<? super T, ? super U, ? extends R> resultSelector;
            T value;

            InnerObserver(al<? super R> actual, c<? super T, ? super U, ? extends R> resultSelector) {
                this.downstream = actual;
                this.resultSelector = resultSelector;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onSuccess(U value) {
                R r2;
                T t2 = this.value;
                this.value = null;
                try {
                    r2 = Objects.requireNonNull(this.resultSelector.apply(t2, value), "The resultSelector returned a null value");
                }
                catch (Throwable ex) {
                    a.k(ex);
                    this.downstream.onError(ex);
                    return;
                }
                this.downstream.onSuccess(r2);
            }

            @Override
            public void onError(Throwable e2) {
                this.downstream.onError(e2);
            }
        }
    }
}

