/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.a;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.core.d;
import io.reactivex.rxjava3.core.g;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleFlatMapCompletable<T>
extends a {
    final ao<T> avs;
    final h<? super T, ? extends g> avt;

    public SingleFlatMapCompletable(ao<T> source, h<? super T, ? extends g> mapper) {
        this.avs = source;
        this.avt = mapper;
    }

    @Override
    protected void d(d observer) {
        FlatMapCompletableObserver<? super T> parent = new FlatMapCompletableObserver<T>(observer, this.avt);
        observer.onSubscribe(parent);
        this.avs.c(parent);
    }

    static final class FlatMapCompletableObserver<T>
    extends AtomicReference<b>
    implements al<T>,
    d,
    b {
        private static final long serialVersionUID = -2177128922851101253L;
        final d downstream;
        final h<? super T, ? extends g> mapper;

        FlatMapCompletableObserver(d actual, h<? super T, ? extends g> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.replace(this, d2);
        }

        @Override
        public void onSuccess(T value) {
            g cs;
            try {
                cs = Objects.requireNonNull(this.mapper.apply(value), "The mapper returned a null CompletableSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.onError(ex);
                return;
            }
            if (!this.isDisposed()) {
                cs.c(this);
            }
        }

        @Override
        public void onError(Throwable e2) {
            this.downstream.onError(e2);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

