/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ag;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.core.z;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.observers.BasicIntQueueDisposable;
import java.util.Iterator;
import java.util.Objects;

public final class SingleFlatMapIterableObservable<T, R>
extends z<R> {
    final ao<T> avw;
    final h<? super T, ? extends Iterable<? extends R>> avx;

    public SingleFlatMapIterableObservable(ao<T> source, h<? super T, ? extends Iterable<? extends R>> mapper) {
        this.avw = source;
        this.avx = mapper;
    }

    @Override
    protected void d(ag<? super R> observer) {
        this.avw.c(new FlatMapIterableObserver<T, R>(observer, this.avx));
    }

    static final class FlatMapIterableObserver<T, R>
    extends BasicIntQueueDisposable<R>
    implements al<T> {
        private static final long serialVersionUID = -8938804753851907758L;
        final ag<? super R> downstream;
        final h<? super T, ? extends Iterable<? extends R>> mapper;
        b upstream;
        volatile Iterator<? extends R> it;
        volatile boolean cancelled;
        boolean outputFused;

        FlatMapIterableObserver(ag<? super R> actual, h<? super T, ? extends Iterable<? extends R>> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            boolean has;
            Iterator<R> iterator;
            ag<R> a2 = this.downstream;
            try {
                iterator = this.mapper.apply(value).iterator();
                has = iterator.hasNext();
            }
            catch (Throwable ex) {
                a.k(ex);
                this.downstream.onError(ex);
                return;
            }
            if (!has) {
                a2.onComplete();
                return;
            }
            if (!this.outputFused) {
                boolean b2;
                do {
                    R v2;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        v2 = iterator.next();
                    }
                    catch (Throwable ex) {
                        a.k(ex);
                        a2.onError(ex);
                        return;
                    }
                    a2.onNext(v2);
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        b2 = iterator.hasNext();
                    }
                    catch (Throwable ex) {
                        a.k(ex);
                        a2.onError(ex);
                        return;
                    }
                } while (b2);
                a2.onComplete();
                return;
            }
            this.it = iterator;
            a2.onNext(null);
            a2.onComplete();
        }

        @Override
        public void onError(Throwable e2) {
            this.upstream = DisposableHelper.DISPOSED;
            this.downstream.onError(e2);
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.upstream = DisposableHelper.DISPOSED;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        public void clear() {
            this.it = null;
        }

        @Override
        public boolean isEmpty() {
            return this.it == null;
        }

        @Override
        @f
        public R poll() {
            Iterator<R> iterator = this.it;
            if (iterator != null) {
                R v2 = Objects.requireNonNull(iterator.next(), "The iterator returned a null value");
                if (!iterator.hasNext()) {
                    this.it = null;
                }
                return v2;
            }
            return null;
        }
    }
}

