/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.core.q;
import io.reactivex.rxjava3.core.t;
import io.reactivex.rxjava3.core.w;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleFlatMapMaybe<T, R>
extends q<R> {
    final ao<? extends T> avy;
    final h<? super T, ? extends w<? extends R>> avz;

    public SingleFlatMapMaybe(ao<? extends T> source, h<? super T, ? extends w<? extends R>> mapper) {
        this.avz = mapper;
        this.avy = source;
    }

    @Override
    protected void d(t<? super R> downstream) {
        this.avy.c(new FlatMapSingleObserver<T, R>(downstream, this.avz));
    }

    static final class a<R>
    implements t<R> {
        final AtomicReference<b> avA;
        final t<? super R> avB;

        a(AtomicReference<b> parent, t<? super R> downstream) {
            this.avA = parent;
            this.avB = downstream;
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.replace(this.avA, d2);
        }

        @Override
        public void onSuccess(R value) {
            this.avB.onSuccess(value);
        }

        @Override
        public void onError(Throwable e2) {
            this.avB.onError(e2);
        }

        @Override
        public void onComplete() {
            this.avB.onComplete();
        }
    }

    static final class FlatMapSingleObserver<T, R>
    extends AtomicReference<b>
    implements al<T>,
    b {
        private static final long serialVersionUID = -5843758257109742742L;
        final t<? super R> downstream;
        final h<? super T, ? extends w<? extends R>> mapper;

        FlatMapSingleObserver(t<? super R> actual, h<? super T, ? extends w<? extends R>> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.setOnce(this, d2)) {
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            w<R> ms;
            try {
                ms = Objects.requireNonNull(this.mapper.apply(value), "The mapper returned a null MaybeSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.onError(ex);
                return;
            }
            if (!this.isDisposed()) {
                ms.c(new a<R>(this, this.downstream));
            }
        }

        @Override
        public void onError(Throwable e2) {
            this.downstream.onError(e2);
        }
    }
}

