/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ai;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleFlatMapNotification<T, R>
extends ai<R> {
    final ao<T> avC;
    final h<? super T, ? extends ao<? extends R>> avD;
    final h<? super Throwable, ? extends ao<? extends R>> avE;

    public SingleFlatMapNotification(ao<T> source, h<? super T, ? extends ao<? extends R>> onSuccessMapper, h<? super Throwable, ? extends ao<? extends R>> onErrorMapper) {
        this.avC = source;
        this.avD = onSuccessMapper;
        this.avE = onErrorMapper;
    }

    @Override
    protected void d(al<? super R> observer) {
        this.avC.c(new FlatMapSingleObserver<T, R>(observer, this.avD, this.avE));
    }

    static final class FlatMapSingleObserver<T, R>
    extends AtomicReference<b>
    implements al<T>,
    b {
        private static final long serialVersionUID = 4375739915521278546L;
        final al<? super R> downstream;
        final h<? super T, ? extends ao<? extends R>> onSuccessMapper;
        final h<? super Throwable, ? extends ao<? extends R>> onErrorMapper;
        b upstream;

        FlatMapSingleObserver(al<? super R> actual, h<? super T, ? extends ao<? extends R>> onSuccessMapper, h<? super Throwable, ? extends ao<? extends R>> onErrorMapper) {
            this.downstream = actual;
            this.onSuccessMapper = onSuccessMapper;
            this.onErrorMapper = onErrorMapper;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            ao<R> source;
            try {
                source = Objects.requireNonNull(this.onSuccessMapper.apply(value), "The onSuccessMapper returned a null SingleSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.downstream.onError(ex);
                return;
            }
            if (!this.isDisposed()) {
                source.c(new a());
            }
        }

        @Override
        public void onError(Throwable e2) {
            ao<R> source;
            try {
                source = Objects.requireNonNull(this.onErrorMapper.apply(e2), "The onErrorMapper returned a null SingleSource");
            }
            catch (Throwable ex) {
                io.reactivex.rxjava3.exceptions.a.k(ex);
                this.downstream.onError(new CompositeException(e2, ex));
                return;
            }
            if (!this.isDisposed()) {
                source.c(new a());
            }
        }

        final class a
        implements al<R> {
            a() {
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(FlatMapSingleObserver.this, d2);
            }

            @Override
            public void onSuccess(R value) {
                FlatMapSingleObserver.this.downstream.onSuccess(value);
            }

            @Override
            public void onError(Throwable e2) {
                FlatMapSingleObserver.this.downstream.onError(e2);
            }
        }
    }
}

