/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.core.j;
import io.reactivex.rxjava3.core.o;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.a;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.a.c;
import org.a.d;
import org.a.e;

public final class SingleFlatMapPublisher<T, R>
extends j<R> {
    final ao<T> avG;
    final h<? super T, ? extends c<? extends R>> avH;

    public SingleFlatMapPublisher(ao<T> source, h<? super T, ? extends c<? extends R>> mapper) {
        this.avG = source;
        this.avH = mapper;
    }

    @Override
    protected void d(d<? super R> downstream) {
        this.avG.c(new SingleFlatMapPublisherObserver<T, R>(downstream, this.avH));
    }

    static final class SingleFlatMapPublisherObserver<S, T>
    extends AtomicLong
    implements al<S>,
    o<T>,
    e {
        private static final long serialVersionUID = 7759721921468635667L;
        final d<? super T> downstream;
        final h<? super S, ? extends c<? extends T>> mapper;
        final AtomicReference<e> parent;
        b disposable;

        SingleFlatMapPublisherObserver(d<? super T> actual, h<? super S, ? extends c<? extends T>> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
            this.parent = new AtomicReference();
        }

        @Override
        public void onSubscribe(b d2) {
            this.disposable = d2;
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onSuccess(S value) {
            c<T> f2;
            try {
                f2 = Objects.requireNonNull(this.mapper.apply(value), "the mapper returned a null Publisher");
            }
            catch (Throwable e2) {
                a.k(e2);
                this.downstream.onError(e2);
                return;
            }
            if (this.parent.get() != SubscriptionHelper.CANCELLED) {
                f2.subscribe(this);
            }
        }

        @Override
        public void onSubscribe(e s2) {
            SubscriptionHelper.deferredSetOnce(this.parent, this, s2);
        }

        @Override
        public void onNext(T t2) {
            this.downstream.onNext(t2);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void onError(Throwable e2) {
            this.downstream.onError(e2);
        }

        @Override
        public void request(long n2) {
            SubscriptionHelper.deferredRequest(this.parent, this, n2);
        }

        @Override
        public void cancel() {
            this.disposable.dispose();
            SubscriptionHelper.cancel(this.parent);
        }
    }
}

