/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.core.ai;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleTimeout<T>
extends ai<T> {
    final ao<T> awz;
    final long awA;
    final TimeUnit awB;
    final ah awC;
    final ao<? extends T> awD;

    public SingleTimeout(ao<T> source, long timeout, TimeUnit unit, ah scheduler, ao<? extends T> other) {
        this.awz = source;
        this.awA = timeout;
        this.awB = unit;
        this.awC = scheduler;
        this.awD = other;
    }

    @Override
    protected void d(al<? super T> observer) {
        TimeoutMainObserver<? extends T> parent = new TimeoutMainObserver<T>(observer, this.awD, this.awA, this.awB);
        observer.onSubscribe(parent);
        DisposableHelper.replace(parent.task, this.awC.a(parent, this.awA, this.awB));
        this.awz.c(parent);
    }

    static final class TimeoutMainObserver<T>
    extends AtomicReference<b>
    implements al<T>,
    b,
    Runnable {
        private static final long serialVersionUID = 37497744973048446L;
        final al<? super T> downstream;
        final AtomicReference<b> task;
        final TimeoutFallbackObserver<T> fallback;
        ao<? extends T> other;
        final long timeout;
        final TimeUnit unit;

        TimeoutMainObserver(al<? super T> actual, ao<? extends T> other, long timeout, TimeUnit unit) {
            this.downstream = actual;
            this.other = other;
            this.timeout = timeout;
            this.unit = unit;
            this.task = new AtomicReference();
            this.fallback = other != null ? new TimeoutFallbackObserver<T>(actual) : null;
        }

        @Override
        public void run() {
            if (DisposableHelper.dispose(this)) {
                ao<T> other = this.other;
                if (other == null) {
                    this.downstream.onError(new TimeoutException(ExceptionHelper.Y(this.timeout, this.unit)));
                } else {
                    this.other = null;
                    other.c(this.fallback);
                }
            }
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this, d2);
        }

        @Override
        public void onSuccess(T t2) {
            b d2 = (b)this.get();
            if (d2 != DisposableHelper.DISPOSED && this.compareAndSet(d2, DisposableHelper.DISPOSED)) {
                DisposableHelper.dispose(this.task);
                this.downstream.onSuccess(t2);
            }
        }

        @Override
        public void onError(Throwable e2) {
            b d2 = (b)this.get();
            if (d2 != DisposableHelper.DISPOSED && this.compareAndSet(d2, DisposableHelper.DISPOSED)) {
                DisposableHelper.dispose(this.task);
                this.downstream.onError(e2);
            } else {
                a.onError(e2);
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
            DisposableHelper.dispose(this.task);
            if (this.fallback != null) {
                DisposableHelper.dispose(this.fallback);
            }
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((b)this.get());
        }

        static final class TimeoutFallbackObserver<T>
        extends AtomicReference<b>
        implements al<T> {
            private static final long serialVersionUID = 2071387740092105509L;
            final al<? super T> downstream;

            TimeoutFallbackObserver(al<? super T> downstream) {
                this.downstream = downstream;
            }

            @Override
            public void onSubscribe(b d2) {
                DisposableHelper.setOnce(this, d2);
            }

            @Override
            public void onSuccess(T t2) {
                this.downstream.onSuccess(t2);
            }

            @Override
            public void onError(Throwable e2) {
                this.downstream.onError(e2);
            }
        }
    }
}

