/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.b.g;
import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.b.s;
import io.reactivex.rxjava3.core.ai;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleUsing<T, U>
extends ai<T> {
    final s<U> awL;
    final h<? super U, ? extends ao<? extends T>> awM;
    final g<? super U> awN;
    final boolean awO;

    public SingleUsing(s<U> resourceSupplier, h<? super U, ? extends ao<? extends T>> singleFunction, g<? super U> disposer, boolean eager) {
        this.awL = resourceSupplier;
        this.awM = singleFunction;
        this.awN = disposer;
        this.awO = eager;
    }

    @Override
    protected void d(al<? super T> observer) {
        ao<T> source;
        U resource;
        try {
            resource = this.awL.get();
        }
        catch (Throwable ex) {
            io.reactivex.rxjava3.exceptions.a.k(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        try {
            source = Objects.requireNonNull(this.awM.apply(resource), "The singleFunction returned a null SingleSource");
        }
        catch (Throwable ex2) {
            CompositeException ex2;
            io.reactivex.rxjava3.exceptions.a.k(ex2);
            if (this.awO) {
                try {
                    this.awN.accept(resource);
                }
                catch (Throwable exc) {
                    io.reactivex.rxjava3.exceptions.a.k(exc);
                    ex2 = new CompositeException(ex2, exc);
                }
            }
            EmptyDisposable.error((Throwable)ex2, observer);
            if (!this.awO) {
                try {
                    this.awN.accept(resource);
                }
                catch (Throwable exc) {
                    io.reactivex.rxjava3.exceptions.a.k(exc);
                    a.onError(exc);
                }
            }
            return;
        }
        source.c(new UsingSingleObserver<T, U>(observer, resource, this.awO, this.awN));
    }

    static final class UsingSingleObserver<T, U>
    extends AtomicReference<Object>
    implements al<T>,
    b {
        private static final long serialVersionUID = -5331524057054083935L;
        final al<? super T> downstream;
        final g<? super U> disposer;
        final boolean eager;
        b upstream;

        UsingSingleObserver(al<? super T> actual, U resource, boolean eager, g<? super U> disposer) {
            super(resource);
            this.downstream = actual;
            this.eager = eager;
            this.disposer = disposer;
        }

        @Override
        public void dispose() {
            if (this.eager) {
                this.disposeResource();
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
            } else {
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
                this.disposeResource();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(b d2) {
            if (DisposableHelper.validate(this.upstream, d2)) {
                this.upstream = d2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingSingleObserver u2 = this.getAndSet(this);
                if (u2 != this) {
                    try {
                        this.disposer.accept(u2);
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        this.downstream.onError(ex);
                        return;
                    }
                } else {
                    return;
                }
            }
            this.downstream.onSuccess(value);
            if (!this.eager) {
                this.disposeResource();
            }
        }

        @Override
        public void onError(Throwable e2) {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingSingleObserver u2 = this.getAndSet(this);
                if (u2 != this) {
                    try {
                        this.disposer.accept(u2);
                    }
                    catch (Throwable ex) {
                        io.reactivex.rxjava3.exceptions.a.k(ex);
                        e2 = new CompositeException(e2, ex);
                    }
                } else {
                    return;
                }
            }
            this.downstream.onError(e2);
            if (!this.eager) {
                this.disposeResource();
            }
        }

        void disposeResource() {
            UsingSingleObserver u2 = this.getAndSet(this);
            if (u2 != this) {
                try {
                    this.disposer.accept(u2);
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    a.onError(ex);
                }
            }
        }
    }
}

