/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.b.h;
import io.reactivex.rxjava3.core.ai;
import io.reactivex.rxjava3.core.al;
import io.reactivex.rxjava3.core.ao;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.single.x;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleZipArray<T, R>
extends ai<R> {
    final ao<? extends T>[] awP;
    final h<? super Object[], ? extends R> awQ;

    public SingleZipArray(ao<? extends T>[] sources, h<? super Object[], ? extends R> zipper) {
        this.awP = sources;
        this.awQ = zipper;
    }

    @Override
    protected void d(al<? super R> observer) {
        ao<? extends T>[] sources = this.awP;
        int n2 = sources.length;
        if (n2 == 1) {
            sources[0].c(new x.a(observer, new a()));
            return;
        }
        ZipCoordinator parent = new ZipCoordinator(observer, n2, this.awQ);
        observer.onSubscribe(parent);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (parent.isDisposed()) {
                return;
            }
            ao source = sources[i2];
            if (source == null) {
                parent.innerError(new NullPointerException("One of the sources is null"), i2);
                return;
            }
            source.c(parent.observers[i2]);
        }
    }

    final class a
    implements h<T, R> {
        a() {
        }

        @Override
        public R apply(T t2) throws Throwable {
            return Objects.requireNonNull(SingleZipArray.this.awQ.apply((Object[])new Object[]{t2}), "The zipper returned a null value");
        }
    }

    static final class ZipSingleObserver<T>
    extends AtomicReference<b>
    implements al<T> {
        private static final long serialVersionUID = 3323743579927613702L;
        final ZipCoordinator<T, ?> parent;
        final int index;

        ZipSingleObserver(ZipCoordinator<T, ?> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public void onSubscribe(b d2) {
            DisposableHelper.setOnce(this, d2);
        }

        @Override
        public void onSuccess(T value) {
            this.parent.innerSuccess(value, this.index);
        }

        @Override
        public void onError(Throwable e2) {
            this.parent.innerError(e2, this.index);
        }
    }

    static final class ZipCoordinator<T, R>
    extends AtomicInteger
    implements b {
        private static final long serialVersionUID = -5556924161382950569L;
        final al<? super R> downstream;
        final h<? super Object[], ? extends R> zipper;
        final ZipSingleObserver<T>[] observers;
        Object[] values;

        ZipCoordinator(al<? super R> observer, int n2, h<? super Object[], ? extends R> zipper) {
            super(n2);
            this.downstream = observer;
            this.zipper = zipper;
            ZipSingleObserver[] o2 = new ZipSingleObserver[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                o2[i2] = new ZipSingleObserver(this, i2);
            }
            this.observers = o2;
            this.values = new Object[n2];
        }

        @Override
        public boolean isDisposed() {
            return this.get() <= 0;
        }

        @Override
        public void dispose() {
            if (this.getAndSet(0) > 0) {
                for (ZipSingleObserver<T> d2 : this.observers) {
                    d2.dispose();
                }
                this.values = null;
            }
        }

        void innerSuccess(T value, int index) {
            Object[] values = this.values;
            if (values != null) {
                values[index] = value;
            }
            if (this.decrementAndGet() == 0) {
                R v2;
                try {
                    v2 = Objects.requireNonNull(this.zipper.apply((Object[])values), "The zipper returned a null value");
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.exceptions.a.k(ex);
                    this.values = null;
                    this.downstream.onError(ex);
                    return;
                }
                this.values = null;
                this.downstream.onSuccess(v2);
            }
        }

        void disposeExcept(int index) {
            int i2;
            ZipSingleObserver<T>[] observers = this.observers;
            int n2 = observers.length;
            for (i2 = 0; i2 < index; ++i2) {
                observers[i2].dispose();
            }
            for (i2 = index + 1; i2 < n2; ++i2) {
                observers[i2].dispose();
            }
        }

        void innerError(Throwable ex, int index) {
            if (this.getAndSet(0) > 0) {
                this.disposeExcept(index);
                this.values = null;
                this.downstream.onError(ex);
            } else {
                io.reactivex.rxjava3.d.a.onError(ex);
            }
        }
    }
}

