/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.schedulers;

import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.schedulers.a;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;

abstract class AbstractDirectTask
extends AtomicReference<Future<?>>
implements b,
a {
    private static final long serialVersionUID = 1811839108042568751L;
    protected final Runnable runnable;
    protected final boolean interruptOnCancel;
    protected Thread runner;
    protected static final FutureTask<Void> FINISHED = new FutureTask<Object>(Functions.KO, null);
    protected static final FutureTask<Void> DISPOSED = new FutureTask<Object>(Functions.KO, null);

    AbstractDirectTask(Runnable runnable, boolean interruptOnCancel) {
        this.runnable = runnable;
        this.interruptOnCancel = interruptOnCancel;
    }

    @Override
    public final void dispose() {
        Future f2 = (Future)this.get();
        if (f2 != FINISHED && f2 != DISPOSED && this.compareAndSet(f2, DISPOSED) && f2 != null) {
            this.h(f2);
        }
    }

    @Override
    public final boolean isDisposed() {
        Future f2 = (Future)this.get();
        return f2 == FINISHED || f2 == DISPOSED;
    }

    public final void setFuture(Future<?> future) {
        Future f2;
        while ((f2 = (Future)this.get()) != FINISHED) {
            if (f2 == DISPOSED) {
                this.h(future);
                break;
            }
            if (!this.compareAndSet(f2, future)) continue;
            break;
        }
    }

    private void h(Future<?> future) {
        if (this.runner == Thread.currentThread()) {
            future.cancel(false);
        } else {
            future.cancel(this.interruptOnCancel);
        }
    }

    @Override
    public Runnable getWrappedRunnable() {
        return this.runnable;
    }

    @Override
    public String toString() {
        Thread r2;
        Future f2 = (Future)this.get();
        String status = f2 == FINISHED ? "Finished" : (f2 == DISPOSED ? "Disposed" : ((r2 = this.runner) != null ? "Running on " + this.runner : "Waiting"));
        return this.getClass().getSimpleName() + "[" + status + "]";
    }
}

