/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.schedulers;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.disposables.c;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.schedulers.ScheduledDirectPeriodicTask;
import io.reactivex.rxjava3.internal.schedulers.ScheduledDirectTask;
import io.reactivex.rxjava3.internal.schedulers.ScheduledRunnable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ExecutorScheduler
extends ah {
    final boolean axn;
    final boolean axo;
    @e
    final Executor axp;

    public ExecutorScheduler(@e Executor executor, boolean interruptibleWorker, boolean fair) {
        this.axp = executor;
        this.axn = interruptibleWorker;
        this.axo = fair;
    }

    @Override
    @e
    public ah.c oS() {
        return new ExecutorWorker(this.axp, this.axn, this.axo);
    }

    @Override
    @e
    public io.reactivex.rxjava3.disposables.b e(@e Runnable run) {
        Runnable decoratedRun = io.reactivex.rxjava3.d.a.h(run);
        try {
            if (this.axp instanceof ExecutorService) {
                ScheduledDirectTask task = new ScheduledDirectTask(decoratedRun, this.axn);
                Future<Void> f2 = ((ExecutorService)this.axp).submit(task);
                task.setFuture(f2);
                return task;
            }
            if (this.axn) {
                ExecutorWorker.InterruptibleRunnable interruptibleTask = new ExecutorWorker.InterruptibleRunnable(decoratedRun, null);
                this.axp.execute(interruptibleTask);
                return interruptibleTask;
            }
            ExecutorWorker.BooleanRunnable br2 = new ExecutorWorker.BooleanRunnable(decoratedRun);
            this.axp.execute(br2);
            return br2;
        }
        catch (RejectedExecutionException ex) {
            io.reactivex.rxjava3.d.a.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    @Override
    @e
    public io.reactivex.rxjava3.disposables.b a(@e Runnable run, long delay, TimeUnit unit) {
        Runnable decoratedRun = io.reactivex.rxjava3.d.a.h(run);
        if (this.axp instanceof ScheduledExecutorService) {
            try {
                ScheduledDirectTask task = new ScheduledDirectTask(decoratedRun, this.axn);
                ScheduledFuture<Void> f2 = ((ScheduledExecutorService)this.axp).schedule(task, delay, unit);
                task.setFuture(f2);
                return task;
            }
            catch (RejectedExecutionException ex) {
                io.reactivex.rxjava3.d.a.onError(ex);
                return EmptyDisposable.INSTANCE;
            }
        }
        DelayedRunnable dr = new DelayedRunnable(decoratedRun);
        io.reactivex.rxjava3.disposables.b delayed = b.axB.a(new a(dr), delay, unit);
        dr.timed.replace(delayed);
        return dr;
    }

    @Override
    @e
    public io.reactivex.rxjava3.disposables.b a(@e Runnable run, long initialDelay, long period, TimeUnit unit) {
        if (this.axp instanceof ScheduledExecutorService) {
            Runnable decoratedRun = io.reactivex.rxjava3.d.a.h(run);
            try {
                ScheduledDirectPeriodicTask task = new ScheduledDirectPeriodicTask(decoratedRun, this.axn);
                ScheduledFuture<?> f2 = ((ScheduledExecutorService)this.axp).scheduleAtFixedRate(task, initialDelay, period, unit);
                task.setFuture(f2);
                return task;
            }
            catch (RejectedExecutionException ex) {
                io.reactivex.rxjava3.d.a.onError(ex);
                return EmptyDisposable.INSTANCE;
            }
        }
        return super.a(run, initialDelay, period, unit);
    }

    final class a
    implements Runnable {
        private final DelayedRunnable axq;

        a(DelayedRunnable dr) {
            this.axq = dr;
        }

        @Override
        public void run() {
            this.axq.direct.replace(ExecutorScheduler.this.e(this.axq));
        }
    }

    static final class DelayedRunnable
    extends AtomicReference<Runnable>
    implements io.reactivex.rxjava3.disposables.b,
    io.reactivex.rxjava3.schedulers.a,
    Runnable {
        private static final long serialVersionUID = -4101336210206799084L;
        final SequentialDisposable timed = new SequentialDisposable();
        final SequentialDisposable direct = new SequentialDisposable();

        DelayedRunnable(Runnable run) {
            super(run);
        }

        @Override
        public void run() {
            Runnable r2 = (Runnable)this.get();
            if (r2 != null) {
                try {
                    try {
                        r2.run();
                    }
                    finally {
                        this.lazySet(null);
                        this.timed.lazySet(DisposableHelper.DISPOSED);
                        this.direct.lazySet(DisposableHelper.DISPOSED);
                    }
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.d.a.onError(ex);
                    throw ex;
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get() == null;
        }

        @Override
        public void dispose() {
            if (this.getAndSet(null) != null) {
                this.timed.dispose();
                this.direct.dispose();
            }
        }

        @Override
        public Runnable getWrappedRunnable() {
            Runnable r2 = (Runnable)this.get();
            return r2 != null ? r2 : Functions.KO;
        }
    }

    public static final class ExecutorWorker
    extends ah.c
    implements Runnable {
        final boolean axs;
        final boolean axt;
        final Executor axu;
        final MpscLinkedQueue<Runnable> axv;
        volatile boolean disposed;
        final AtomicInteger axw = new AtomicInteger();
        final io.reactivex.rxjava3.disposables.a axx = new io.reactivex.rxjava3.disposables.a();

        public ExecutorWorker(Executor executor, boolean interruptibleWorker, boolean fair) {
            this.axu = executor;
            this.axv = new MpscLinkedQueue();
            this.axs = interruptibleWorker;
            this.axt = fair;
        }

        @Override
        @e
        public io.reactivex.rxjava3.disposables.b f(@e Runnable run) {
            io.reactivex.rxjava3.disposables.b disposable;
            io.reactivex.rxjava3.disposables.b task;
            if (this.disposed) {
                return EmptyDisposable.INSTANCE;
            }
            Runnable decoratedRun = io.reactivex.rxjava3.d.a.h(run);
            if (this.axs) {
                InterruptibleRunnable interruptibleTask = new InterruptibleRunnable(decoratedRun, this.axx);
                this.axx.a((io.reactivex.rxjava3.disposables.b)interruptibleTask);
                task = interruptibleTask;
                disposable = interruptibleTask;
            } else {
                BooleanRunnable runnableTask;
                task = runnableTask = new BooleanRunnable(decoratedRun);
                disposable = runnableTask;
            }
            this.axv.offer((Runnable)((Object)task));
            if (this.axw.getAndIncrement() == 0) {
                try {
                    this.axu.execute(this);
                }
                catch (RejectedExecutionException ex) {
                    this.disposed = true;
                    this.axv.clear();
                    io.reactivex.rxjava3.d.a.onError(ex);
                    return EmptyDisposable.INSTANCE;
                }
            }
            return disposable;
        }

        @Override
        @e
        public io.reactivex.rxjava3.disposables.b b(@e Runnable run, long delay, @e TimeUnit unit) {
            if (delay <= 0L) {
                return this.f(run);
            }
            if (this.disposed) {
                return EmptyDisposable.INSTANCE;
            }
            SequentialDisposable first = new SequentialDisposable();
            SequentialDisposable mar = new SequentialDisposable(first);
            Runnable decoratedRun = io.reactivex.rxjava3.d.a.h(run);
            ScheduledRunnable sr = new ScheduledRunnable(new a(mar, decoratedRun), this.axx);
            this.axx.a((io.reactivex.rxjava3.disposables.b)sr);
            if (this.axu instanceof ScheduledExecutorService) {
                try {
                    ScheduledFuture<Object> f2 = ((ScheduledExecutorService)this.axu).schedule(sr, delay, unit);
                    sr.setFuture(f2);
                }
                catch (RejectedExecutionException ex) {
                    this.disposed = true;
                    io.reactivex.rxjava3.d.a.onError(ex);
                    return EmptyDisposable.INSTANCE;
                }
            } else {
                io.reactivex.rxjava3.disposables.b d2 = b.axB.a(sr, delay, unit);
                sr.setFuture(new io.reactivex.rxjava3.internal.schedulers.b(d2));
            }
            first.replace(sr);
            return mar;
        }

        @Override
        public void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                this.axx.dispose();
                if (this.axw.getAndIncrement() == 0) {
                    this.axv.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void run() {
            if (this.axt) {
                this.qv();
            } else {
                this.qw();
            }
        }

        void qv() {
            MpscLinkedQueue<Runnable> q2 = this.axv;
            if (this.disposed) {
                q2.clear();
                return;
            }
            Runnable run = q2.poll();
            run.run();
            if (this.disposed) {
                q2.clear();
                return;
            }
            if (this.axw.decrementAndGet() != 0) {
                this.axu.execute(this);
            }
        }

        void qw() {
            int missed = 1;
            MpscLinkedQueue<Runnable> q2 = this.axv;
            do {
                Runnable run;
                if (this.disposed) {
                    q2.clear();
                    return;
                }
                while ((run = q2.poll()) != null) {
                    run.run();
                    if (!this.disposed) continue;
                    q2.clear();
                    return;
                }
                if (!this.disposed) continue;
                q2.clear();
                return;
            } while ((missed = this.axw.addAndGet(-missed)) != 0);
        }

        static final class InterruptibleRunnable
        extends AtomicInteger
        implements io.reactivex.rxjava3.disposables.b,
        Runnable {
            private static final long serialVersionUID = -3603436687413320876L;
            final Runnable run;
            final c tasks;
            volatile Thread thread;
            static final int READY = 0;
            static final int RUNNING = 1;
            static final int FINISHED = 2;
            static final int INTERRUPTING = 3;
            static final int INTERRUPTED = 4;

            InterruptibleRunnable(Runnable run, c tasks) {
                this.run = run;
                this.tasks = tasks;
            }

            @Override
            public void run() {
                block10: {
                    if (this.get() == 0) {
                        this.thread = Thread.currentThread();
                        if (this.compareAndSet(0, 1)) {
                            try {
                                try {
                                    this.run.run();
                                    break block10;
                                }
                                catch (Throwable ex) {
                                    io.reactivex.rxjava3.d.a.onError(ex);
                                    throw ex;
                                }
                            }
                            finally {
                                this.thread = null;
                                if (this.compareAndSet(1, 2)) {
                                    this.cleanup();
                                } else {
                                    while (this.get() == 3) {
                                        Thread.yield();
                                    }
                                    Thread.interrupted();
                                }
                            }
                        }
                        this.thread = null;
                    }
                }
            }

            @Override
            public void dispose() {
                int state;
                while ((state = this.get()) < 2) {
                    if (state == 0) {
                        if (!this.compareAndSet(0, 4)) continue;
                        this.cleanup();
                        break;
                    }
                    if (!this.compareAndSet(1, 3)) continue;
                    Thread t2 = this.thread;
                    if (t2 != null) {
                        t2.interrupt();
                        this.thread = null;
                    }
                    this.set(4);
                    this.cleanup();
                    break;
                }
            }

            void cleanup() {
                if (this.tasks != null) {
                    this.tasks.c(this);
                }
            }

            @Override
            public boolean isDisposed() {
                return this.get() >= 2;
            }
        }

        final class a
        implements Runnable {
            private final SequentialDisposable axy;
            private final Runnable axz;

            a(SequentialDisposable mar, Runnable decoratedRun) {
                this.axy = mar;
                this.axz = decoratedRun;
            }

            @Override
            public void run() {
                this.axy.replace(ExecutorWorker.this.f(this.axz));
            }
        }

        static final class BooleanRunnable
        extends AtomicBoolean
        implements io.reactivex.rxjava3.disposables.b,
        Runnable {
            private static final long serialVersionUID = -2421395018820541164L;
            final Runnable actual;

            BooleanRunnable(Runnable actual) {
                this.actual = actual;
            }

            @Override
            public void run() {
                if (this.get()) {
                    return;
                }
                try {
                    this.actual.run();
                }
                catch (Throwable ex) {
                    io.reactivex.rxjava3.d.a.onError(ex);
                    throw ex;
                }
                finally {
                    this.lazySet(true);
                }
            }

            @Override
            public void dispose() {
                this.lazySet(true);
            }

            @Override
            public boolean isDisposed() {
                return this.get();
            }
        }
    }

    static final class b {
        static final ah axB = io.reactivex.rxjava3.schedulers.b.sa();

        b() {
        }
    }
}

