/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.schedulers;

import io.reactivex.rxjava3.annotations.e;
import io.reactivex.rxjava3.annotations.f;
import io.reactivex.rxjava3.core.ah;
import io.reactivex.rxjava3.d.a;
import io.reactivex.rxjava3.disposables.b;
import io.reactivex.rxjava3.disposables.c;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.schedulers.ScheduledDirectPeriodicTask;
import io.reactivex.rxjava3.internal.schedulers.ScheduledDirectTask;
import io.reactivex.rxjava3.internal.schedulers.ScheduledRunnable;
import io.reactivex.rxjava3.internal.schedulers.d;
import io.reactivex.rxjava3.internal.schedulers.j;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class g
extends ah.c {
    private final ScheduledExecutorService ayo;
    volatile boolean disposed;

    public g(ThreadFactory threadFactory) {
        this.ayo = j.a(threadFactory);
    }

    @Override
    @e
    public b f(@e Runnable run) {
        return this.b(run, 0L, null);
    }

    @Override
    @e
    public b b(@e Runnable action, long delayTime, @e TimeUnit unit) {
        if (this.disposed) {
            return EmptyDisposable.INSTANCE;
        }
        return this.a(action, delayTime, unit, null);
    }

    public b a(Runnable run, long delayTime, TimeUnit unit) {
        ScheduledDirectTask task = new ScheduledDirectTask(a.h(run), true);
        try {
            Future<Void> f2 = delayTime <= 0L ? this.ayo.submit(task) : this.ayo.schedule(task, delayTime, unit);
            task.setFuture(f2);
            return task;
        }
        catch (RejectedExecutionException ex) {
            a.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    public b a(Runnable run, long initialDelay, long period, TimeUnit unit) {
        Runnable decoratedRun = a.h(run);
        if (period <= 0L) {
            d periodicWrapper = new d(decoratedRun, this.ayo);
            try {
                Future<Void> f2 = initialDelay <= 0L ? this.ayo.submit(periodicWrapper) : this.ayo.schedule(periodicWrapper, initialDelay, unit);
                periodicWrapper.i(f2);
            }
            catch (RejectedExecutionException ex) {
                a.onError(ex);
                return EmptyDisposable.INSTANCE;
            }
            return periodicWrapper;
        }
        ScheduledDirectPeriodicTask task = new ScheduledDirectPeriodicTask(decoratedRun, true);
        try {
            ScheduledFuture<?> f3 = this.ayo.scheduleAtFixedRate(task, initialDelay, period, unit);
            task.setFuture(f3);
            return task;
        }
        catch (RejectedExecutionException ex) {
            a.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    @e
    public ScheduledRunnable a(Runnable run, long delayTime, @e TimeUnit unit, @f c parent) {
        Runnable decoratedRun = a.h(run);
        ScheduledRunnable sr = new ScheduledRunnable(decoratedRun, parent);
        if (parent != null && !parent.a(sr)) {
            return sr;
        }
        try {
            Future<Object> f2 = delayTime <= 0L ? this.ayo.submit(sr) : this.ayo.schedule(sr, delayTime, unit);
            sr.setFuture(f2);
        }
        catch (RejectedExecutionException ex) {
            if (parent != null) {
                parent.b(sr);
            }
            a.onError(ex);
        }
        return sr;
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.ayo.shutdownNow();
        }
    }

    public void shutdown() {
        if (!this.disposed) {
            this.disposed = true;
            this.ayo.shutdown();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }
}

